/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.yacas;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.drawj2d.yacas.Grapher;

public class PlotDataParser {
    Graphics2D g;
    Dimension dim;
    private int xleft = 0;
    private int ytop = 0;
    private boolean verbose = false;
    private final boolean debug = false;

    public PlotDataParser(Graphics2D g, int pxwidth, int pxheight) {
        this.g = g;
        this.dim = new Dimension(pxwidth, pxheight);
    }

    public void setOrigin(int xleft, int ytop) {
        this.xleft = xleft;
        this.ytop = ytop;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean sourceFile(String sourcefile) {
        boolean success = false;
        StringBuilder sb = new StringBuilder();
        try {
            InputStreamReader eingabestrom = !sourcefile.equals("_opt_stdin") ? new InputStreamReader(new FileInputStream(new File(sourcefile))) : new InputStreamReader(System.in);
            BufferedReader eingabe = new BufferedReader(eingabestrom);
            boolean isEOF = false;
            do {
                String zeile;
                if ((zeile = eingabe.readLine()) != null) {
                    sb.append(this.AddOutputLine(zeile));
                    sb.append("\n");
                    continue;
                }
                isEOF = true;
            } while (!isEOF);
            eingabe.close();
            eingabestrom.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(PlotDataParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.verbose) {
            System.out.println(sb.toString());
        }
        Grapher yg_parser = new Grapher(sb.toString());
        success = true;
        yg_parser.paint(this.g, 0, 0, this.dim);
        return success;
    }

    private String AddOutputLine(String outp) {
        String dollared = "";
        if (outp.length() > 0) {
            int dollarPos = outp.indexOf("$");
            while (dollarPos >= 0) {
                outp = outp.substring(dollarPos + 1, outp.length());
                dollarPos = outp.indexOf("$");
                dollared = outp.substring(0, dollarPos);
                outp = outp.substring(dollarPos + 1, outp.length());
                int plotPos = dollared.indexOf("plot2d:");
                if (plotPos >= 0) {
                    dollared = dollared.substring(plotPos + 7);
                }
                dollarPos = outp.indexOf("$");
            }
        }
        return dollared;
    }
}

