/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import java.util.ArrayList;
import java.util.Arrays;
import no.geosoft.cc.geometry.Geometry;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class StatFequilibriumCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        boolean intersectionfound;
        double \u03b2;
        double \u03b1;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        if (argd.length < 6) {
            throw new HeclException("Illegal nb of arguments.");
        }
        assert (argd.length >= 6);
        double x0 = argd[0];
        double y0 = argd[1];
        double Fx = argd[2];
        double Fy = argd[3];
        if (Math.hypot(Fx, Fy) == 0.0) {
            throw new HeclException("Illegal arguments. Force length must not be 0.");
        }
        switch (argd.length) {
            case 6: {
                \u03b1 = argd[4];
                \u03b2 = argd[5];
                if (\u03b1 != \u03b2) break;
                throw new HeclException("Illegal arguments in x0 y0 Fx Fy alpha beta. Alpha and beta must differ.");
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        double[] intersection = new double[2];
        double dAx = Math.cos(Math.toRadians(\u03b1));
        double dAy = Math.sin(Math.toRadians(\u03b1));
        double dBx = Math.cos(Math.toRadians(\u03b2));
        double dBy = Math.sin(Math.toRadians(\u03b2));
        int intersectionType = Geometry.findLineSegmentIntersection(0.0, 0.0, dAx, dAy, -Fx, -Fy, -Fx + dBx, -Fy + dBy, intersection);
        switch (intersectionType) {
            case 0: 
            case 1: {
                intersectionfound = true;
                break;
            }
            case -2: 
            case -1: {
                intersectionfound = false;
                break;
            }
            default: {
                assert (false);
                intersectionfound = false;
            }
        }
        if (!intersectionfound) {
            throw new HeclException("No intersection point.");
        }
        double Ax = intersection[0];
        double Ay = intersection[1];
        String xstr = StringThing.get(DoubleThing.create(x0));
        String ystr = StringThing.get(DoubleThing.create(y0));
        String Fxstr = StringThing.get(DoubleThing.create(Ax));
        String Fystr = StringThing.get(DoubleThing.create(Ay));
        String answer = xstr + " " + ystr + " " + Fxstr + " " + Fystr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

