/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import net.sf.drawj2d.cmd.statics.clKraft;
import net.sf.drawj2d.cmd.statics.clResultierende;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class StatEquilibriumCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        if (argv.length < 2) {
            throw new HeclException("Illegal nb of arguments.");
        }
        clKraft[] Flist = new clKraft[argv.length - 1];
        for (int i = 1; i < argv.length; ++i) {
            Object[] currentargv = ListThing.getArray(argv[i]);
            if (currentargv.length != 4) {
                throw new HeclException("Illegal argument format. \"x0 y0 Fx Fy\" (all numbers) expected.");
            }
            double Fx = NumberThing.asNumber((Thing)currentargv[2]).doubleValue();
            double Fy = NumberThing.asNumber((Thing)currentargv[3]).doubleValue();
            double x0 = NumberThing.asNumber((Thing)currentargv[0]).doubleValue();
            double y0 = NumberThing.asNumber((Thing)currentargv[1]).doubleValue();
            Flist[i - 1] = new clKraft(Fx, Fy, x0, y0);
        }
        clResultierende res = new clResultierende();
        for (clKraft Fi : Flist) {
            res.add(Fi);
        }
        double[] R = res.F();
        double[] point = res.pkt();
        String Rxstr = StringThing.get(DoubleThing.create(-R[0]));
        String Rystr = StringThing.get(DoubleThing.create(-R[1]));
        String xstr = StringThing.get(DoubleThing.create(point[0]));
        String ystr = StringThing.get(DoubleThing.create(point[1]));
        String answer = xstr + " " + ystr + " " + Rxstr + " " + Rystr;
        return new Thing(answer);
    }
}

