/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import no.geosoft.cc.geometry.Geometry;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomVectorCmd
implements Command {
    API api;
    boolean debug = false;

    public GeomVectorCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        double[] p0 = new double[]{0.0, 0.0, 0.0};
        double[] p1 = new double[]{0.0, 0.0, 0.0};
        switch (argd.length) {
            case 4: {
                p0[0] = argd[0];
                p0[1] = argd[1];
                p1[0] = argd[2];
                p1[1] = argd[3];
                break;
            }
            case 2: {
                double[] here = this.api.here();
                p0[0] = here[0];
                p0[1] = here[1];
                p1[0] = argd[0];
                p1[1] = argd[1];
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        double[] vector = Geometry.createVector(p0, p1);
        String xstr = StringThing.get(DoubleThing.create(vector[0]));
        String ystr = StringThing.get(DoubleThing.create(vector[1]));
        String answer = xstr + " " + ystr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

