/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import no.geosoft.cc.geometry.Geometry;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomParallelCmd
implements Command {
    API api;
    boolean debug = false;

    public GeomParallelCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        double L;
        double dist;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        switch (argd.length) {
            case 5: {
                dist = argd[4];
                break;
            }
            case 4: {
                double[] here = this.api.here();
                dist = Geometry.distance(argd[0], argd[1], argd[2], argd[3], here[0], here[1]);
                L = Math.hypot(argd[2] - argd[0], argd[3] - argd[1]);
                double tmpPx = argd[0] - (argd[3] - argd[1]) / L * dist;
                double tmpPy = argd[1] + (argd[2] - argd[0]) / L * dist;
                if (Geometry.sameSide(argd[0], argd[1], argd[2], argd[3], here[0], here[1], tmpPx, tmpPy) >= 0) break;
                dist *= -1.0;
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        assert (argd.length > 3);
        L = Math.hypot(argd[2] - argd[0], argd[3] - argd[1]);
        double dx = -(argd[3] - argd[1]) / L * dist;
        double dy = (argd[2] - argd[0]) / L * dist;
        double xP = argd[0] + dx;
        double yP = argd[1] + dy;
        double xQ = argd[2] + dx;
        double yQ = argd[3] + dy;
        String xPstr = StringThing.get(DoubleThing.create(xP));
        String yPstr = StringThing.get(DoubleThing.create(yP));
        String xQstr = StringThing.get(DoubleThing.create(xQ));
        String yQstr = StringThing.get(DoubleThing.create(yQ));
        String answer = xPstr + " " + yPstr + " " + xQstr + " " + yQstr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

