/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class UnitCmd
implements Command {
    API api;
    boolean debug = false;

    public UnitCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        switch (argv.length - 1) {
            case 0: {
                break;
            }
            case 1: {
                double unit_in_mm = NumberThing.asNumber(argv[1]).doubleValue();
                this.api.unitlength(unit_in_mm);
                break;
            }
            case 2: {
                double unit;
                String unitname;
                double scale = NumberThing.asNumber(argv[1]).doubleValue();
                switch (unitname = StringThing.get(argv[2])) {
                    case "mm": {
                        unit = 1.0;
                        break;
                    }
                    case "cm": {
                        unit = 10.0;
                        break;
                    }
                    case "meter": 
                    case "m": {
                        unit = 1000.0;
                        break;
                    }
                    case "km": {
                        unit = 1000000.0;
                        break;
                    }
                    case "\u00b5m": {
                        unit = 0.001;
                        break;
                    }
                    case "nm": {
                        unit = 1.0E-6;
                        break;
                    }
                    case "inch": 
                    case "in": {
                        unit = 25.4;
                        break;
                    }
                    case "foot": 
                    case "feet": 
                    case "ft": {
                        unit = 304.79999999999995;
                        break;
                    }
                    case "yard": 
                    case "yd": {
                        unit = 914.4;
                        break;
                    }
                    case "mile": {
                        unit = 1609344.0;
                        break;
                    }
                    case "point": 
                    case "pt": {
                        unit = 0.35277777777777775;
                        break;
                    }
                    default: {
                        try {
                            unit = Double.parseDouble(unitname);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new HeclException("Unknown unit: " + unitname);
                        }
                    }
                }
                this.api.unitlength(scale, unit);
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        String answer = StringThing.get(DoubleThing.create(this.api.getunitlength()));
        return new Thing(answer);
    }
}

