/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.Thing;

public class SegmentCmd
implements Command {
    API api;
    boolean debug = false;

    public SegmentCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        switch (argd.length) {
            case 5: {
                double radius = argd[2];
                double startangle = argd[3];
                double endangle = argd[4];
                this.api.arc(argd[0], argd[1], radius, startangle, endangle);
                this.api.movepolar(radius, startangle);
                double[] arcstart = this.api.here();
                this.api.moveto(argd[0], argd[1]);
                this.api.movepolar(radius, endangle);
                this.api.lineto(arcstart[0], arcstart[1]);
                this.api.moveto(argd[0], argd[1]);
                break;
            }
            case 3: {
                double radius = argd[0];
                double startangle = argd[1];
                double endangle = argd[2];
                double[] currentpos = this.api.here();
                this.api.arc(radius, startangle, endangle);
                this.api.movepolar(radius, startangle);
                double[] arcstart = this.api.here();
                this.api.moveto(currentpos);
                this.api.movepolar(radius, endangle);
                this.api.lineto(arcstart[0], arcstart[1]);
                this.api.moveto(currentpos);
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return null;
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

