/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class PenCmd
implements Command {
    API api;
    boolean debug = false;

    public PenCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        if (argv.length == 1) {
            this.api.pen();
        } else {
            assert (argv.length > 1);
            ArrayList<Thing> singleargv = this.splitArgv(argv);
            for (Thing arg : singleargv) {
                if (NumberThing.isNumber(arg)) {
                    float size = NumberThing.asNumber(arg).floatValue();
                    this.api.pen(size);
                    continue;
                }
                String str = StringThing.get(arg);
                int linetype = this.getLineType(str);
                if (linetype > 0) {
                    this.api.pen(linetype);
                    continue;
                }
                Color color = this.getColor(str);
                this.api.pen(color);
            }
        }
        return null;
    }

    private int getLineType(String str) {
        String s = str.toLowerCase();
        if (s.equals("dashed")) {
            return 2;
        }
        if (s.equals("dotted")) {
            return 3;
        }
        if (s.equals("dashdotted")) {
            return 4;
        }
        if (s.equals("solid")) {
            return 1;
        }
        return -1;
    }

    private Color getColor(String colorstring) {
        Color color;
        block32: {
            String c = colorstring.toLowerCase();
            color = Color.black;
            if (c.equals("black") || c.equals("k")) {
                color = Color.black;
            } else if (c.equals("blue") || c.equals("b")) {
                color = Color.blue;
            } else if (c.equals("cyan") || c.equals("c")) {
                color = Color.cyan;
            } else if (c.equals("darkgray") || c.equals("d")) {
                color = Color.darkGray;
            } else if (c.equals("gray") || c.equals("a")) {
                color = Color.gray;
            } else if (c.equals("green") || c.equals("g")) {
                color = Color.green;
            } else if (c.equals("lightgray") || c.equals("l")) {
                color = Color.lightGray;
            } else if (c.equals("magenta") || c.equals("m")) {
                color = Color.magenta;
            } else if (c.equals("orange") || c.equals("o")) {
                color = Color.orange;
            } else if (c.equals("pink") || c.equals("p")) {
                color = Color.pink;
            } else if (c.equals("red") || c.equals("r")) {
                color = Color.red;
            } else if (c.equals("white") || c.equals("w")) {
                color = Color.white;
            } else if (c.equals("yellow") || c.equals("y")) {
                color = Color.yellow;
            } else if (c.equals("brown")) {
                color = new Color(8864541);
            } else if (c.equals("darkorange")) {
                color = new Color(0xFF6600);
            } else {
                try {
                    color = Color.decode(colorstring);
                }
                catch (NumberFormatException nfe) {
                    if (!this.debug) break block32;
                    System.out.println(nfe.getMessage());
                }
            }
        }
        return color;
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

