/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import net.sf.drawj2d.cmd.API;
import net.sf.drawj2d.cmd.ArcCmd;
import net.sf.drawj2d.cmd.ArrowCmd;
import net.sf.drawj2d.cmd.ArrowrelCmd;
import net.sf.drawj2d.cmd.ArrowsCmd;
import net.sf.drawj2d.cmd.ArrowsrelCmd;
import net.sf.drawj2d.cmd.AssertCmd;
import net.sf.drawj2d.cmd.BlockCmd;
import net.sf.drawj2d.cmd.BlockflipCmd;
import net.sf.drawj2d.cmd.BlockrotateCmd;
import net.sf.drawj2d.cmd.BlockscaleCmd;
import net.sf.drawj2d.cmd.BoxCmd;
import net.sf.drawj2d.cmd.CircleCmd;
import net.sf.drawj2d.cmd.CubiccurveCmd;
import net.sf.drawj2d.cmd.DimangleCmd;
import net.sf.drawj2d.cmd.DimlineCmd;
import net.sf.drawj2d.cmd.DimlinerelCmd;
import net.sf.drawj2d.cmd.DotCmd;
import net.sf.drawj2d.cmd.EllipseCmd;
import net.sf.drawj2d.cmd.EndblockCmd;
import net.sf.drawj2d.cmd.ExprCmd;
import net.sf.drawj2d.cmd.ExprinputCmd;
import net.sf.drawj2d.cmd.FillboxCmd;
import net.sf.drawj2d.cmd.FillcircleCmd;
import net.sf.drawj2d.cmd.FillellipseCmd;
import net.sf.drawj2d.cmd.FillpolygonCmd;
import net.sf.drawj2d.cmd.FillrectCmd;
import net.sf.drawj2d.cmd.FillrodCmd;
import net.sf.drawj2d.cmd.FillsectorCmd;
import net.sf.drawj2d.cmd.FillsegmentCmd;
import net.sf.drawj2d.cmd.Fkt;
import net.sf.drawj2d.cmd.FontCmd;
import net.sf.drawj2d.cmd.Force2Cmd;
import net.sf.drawj2d.cmd.ForceCmd;
import net.sf.drawj2d.cmd.ForceUnitCmd;
import net.sf.drawj2d.cmd.FuCmd;
import net.sf.drawj2d.cmd.HereCmd;
import net.sf.drawj2d.cmd.ImageCmd;
import net.sf.drawj2d.cmd.LabelCmd;
import net.sf.drawj2d.cmd.LineCmd;
import net.sf.drawj2d.cmd.LinemidCmd;
import net.sf.drawj2d.cmd.LinepolarCmd;
import net.sf.drawj2d.cmd.LinerelCmd;
import net.sf.drawj2d.cmd.LinetoxCmd;
import net.sf.drawj2d.cmd.MmCmd;
import net.sf.drawj2d.cmd.MovepolarCmd;
import net.sf.drawj2d.cmd.MoverelCmd;
import net.sf.drawj2d.cmd.MovetoCmd;
import net.sf.drawj2d.cmd.MovetoxCmd;
import net.sf.drawj2d.cmd.NfCmd;
import net.sf.drawj2d.cmd.OffsetCmd;
import net.sf.drawj2d.cmd.OpacityCmd;
import net.sf.drawj2d.cmd.PenCmd;
import net.sf.drawj2d.cmd.PointCmd;
import net.sf.drawj2d.cmd.PolygonCmd;
import net.sf.drawj2d.cmd.QuadcurveCmd;
import net.sf.drawj2d.cmd.RectCmd;
import net.sf.drawj2d.cmd.RodCmd;
import net.sf.drawj2d.cmd.SectorCmd;
import net.sf.drawj2d.cmd.SegmentCmd;
import net.sf.drawj2d.cmd.TexdimangleCmd;
import net.sf.drawj2d.cmd.TexlabelCmd;
import net.sf.drawj2d.cmd.TextCmd;
import net.sf.drawj2d.cmd.UnitCmd;
import net.sf.drawj2d.cmd.geom.GeomAddCmd;
import net.sf.drawj2d.cmd.geom.GeomAngleCmd;
import net.sf.drawj2d.cmd.geom.GeomAngleRadCmd;
import net.sf.drawj2d.cmd.geom.GeomAreaCmd;
import net.sf.drawj2d.cmd.geom.GeomAzimuthCmd;
import net.sf.drawj2d.cmd.geom.GeomCentroidCmd;
import net.sf.drawj2d.cmd.geom.GeomCrossproductCmd;
import net.sf.drawj2d.cmd.geom.GeomDistanceCmd;
import net.sf.drawj2d.cmd.geom.GeomDivideCmd;
import net.sf.drawj2d.cmd.geom.GeomDotproductCmd;
import net.sf.drawj2d.cmd.geom.GeomExtendCmd;
import net.sf.drawj2d.cmd.geom.GeomIntersectCmd;
import net.sf.drawj2d.cmd.geom.GeomIntersectlinepathCmd;
import net.sf.drawj2d.cmd.geom.GeomLengthCmd;
import net.sf.drawj2d.cmd.geom.GeomMultiplyCmd;
import net.sf.drawj2d.cmd.geom.GeomNormCmd;
import net.sf.drawj2d.cmd.geom.GeomOnlineCmd;
import net.sf.drawj2d.cmd.geom.GeomParallelCmd;
import net.sf.drawj2d.cmd.geom.GeomPolarCmd;
import net.sf.drawj2d.cmd.geom.GeomRotateCmd;
import net.sf.drawj2d.cmd.geom.GeomSubtractCmd;
import net.sf.drawj2d.cmd.geom.GeomToxCmd;
import net.sf.drawj2d.cmd.geom.GeomVectorCmd;
import net.sf.drawj2d.cmd.statics.StatAbsCmd;
import net.sf.drawj2d.cmd.statics.StatActionlineCmd;
import net.sf.drawj2d.cmd.statics.StatAddCmd;
import net.sf.drawj2d.cmd.statics.StatDistanceCmd;
import net.sf.drawj2d.cmd.statics.StatEquilibriumCmd;
import net.sf.drawj2d.cmd.statics.StatFequilibriumCmd;
import net.sf.drawj2d.cmd.statics.StatMequilibriumCmd;
import net.sf.drawj2d.cmd.statics.StatMomentCmd;
import net.sf.drawj2d.cmd.statics.StatMove2Cmd;
import net.sf.drawj2d.cmd.statics.StatMoveCmd;
import net.sf.drawj2d.cmd.statics.StatMultiplyCmd;
import net.sf.drawj2d.cmd.statics.StatSubtractCmd;
import net.sf.drawj2d.cmd.statics.StatTipCmd;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.Thing;
import org.hecl.files.FileCmds;
import org.hecl.files.HeclFileUtils;

public class HCLparser {
    Graphics2D g;
    Interp interp;
    private boolean verbose = false;
    private final boolean debug = false;

    public HCLparser(Graphics2D g) {
        this.g = g;
        this.initialize();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void initialize() {
        API api = new API(this.g);
        try {
            this.interp = new Interp();
        }
        catch (HeclException he) {
            System.err.println("Error initializing the Hecl interpreter: " + he);
            System.exit(1);
        }
        try {
            FileCmds.loadRestricted(this.interp);
            this.extend(this.interp, api);
            this.extendModules(this.interp, api);
            this.extendHecl(this.interp, api);
        }
        catch (HeclException e) {
            System.err.println("Hecl exception: " + e);
            e.printStackTrace();
        }
    }

    private void extend(Interp ip, API api) throws HeclException {
        ip.addCommand("unitlength", new UnitCmd(api));
        ip.addCommand("unitsize", new UnitCmd(api));
        ip.addCommand("line", new LineCmd(api));
        ip.addCommand("lineto", new LineCmd(api));
        ip.addCommand("l", new LineCmd(api));
        ip.addCommand("linetox", new LinetoxCmd(api, true));
        ip.addCommand("lx", new LinetoxCmd(api, true));
        ip.addCommand("linetoy", new LinetoxCmd(api, false));
        ip.addCommand("ly", new LinetoxCmd(api, false));
        ip.addCommand("linerel", new LinerelCmd(api));
        ip.addCommand("lr", new LinerelCmd(api));
        ip.addCommand("linepolar", new LinepolarCmd(api));
        ip.addCommand("lp", new LinepolarCmd(api));
        ip.addCommand("linemid", new LinemidCmd(api));
        ip.addCommand("lm", new LinemidCmd(api));
        ip.addCommand("arrow", new ArrowCmd(api));
        ip.addCommand("arrowto", new ArrowCmd(api));
        ip.addCommand("arrowrel", new ArrowrelCmd(api));
        ip.addCommand("arrows", new ArrowsCmd(api));
        ip.addCommand("arrowsto", new ArrowsCmd(api));
        ip.addCommand("arrowsrel", new ArrowsrelCmd(api));
        ip.addCommand("point", new PointCmd(api));
        ip.addCommand("pt", new PointCmd(api));
        ip.addCommand("p", new PointCmd(api));
        ip.addCommand("dot", new DotCmd(api));
        ip.addCommand("moveto", new MovetoCmd(api));
        ip.addCommand("m", new MovetoCmd(api));
        ip.addCommand("movetox", new MovetoxCmd(api, true));
        ip.addCommand("mx", new MovetoxCmd(api, true));
        ip.addCommand("movetoy", new MovetoxCmd(api, false));
        ip.addCommand("my", new MovetoxCmd(api, false));
        ip.addCommand("moverel", new MoverelCmd(api));
        ip.addCommand("mr", new MoverelCmd(api));
        ip.addCommand("movepolar", new MovepolarCmd(api));
        ip.addCommand("mp", new MovepolarCmd(api));
        ip.addCommand("pen", new PenCmd(api));
        ip.addCommand("opacity", new OpacityCmd(api));
        ip.addCommand("circle", new CircleCmd(api));
        ip.addCommand("ellipse", new EllipseCmd(api));
        ip.addCommand("arc", new ArcCmd(api));
        ip.addCommand("segment", new SegmentCmd(api));
        ip.addCommand("sector", new SectorCmd(api));
        ip.addCommand("quadcurve", new QuadcurveCmd(api));
        ip.addCommand("parabola", new QuadcurveCmd(api));
        ip.addCommand("cubiccurve", new CubiccurveCmd(api));
        ip.addCommand("rect", new RectCmd(api));
        ip.addCommand("rectangle", new RectCmd(api));
        ip.addCommand("rod", new RodCmd(api));
        ip.addCommand("polygon", new PolygonCmd(api));
        ip.addCommand("box", new BoxCmd(api));
        ip.addCommand("label", new LabelCmd(api));
        ip.addCommand("lb", new LabelCmd(api));
        ip.addCommand("texlabel", new TexlabelCmd(api));
        ip.addCommand("tlb", new TexlabelCmd(api));
        ip.addCommand("text", new TextCmd(api));
        ip.addCommand("dimline", new DimlineCmd(api, false));
        ip.addCommand("texdimline", new DimlineCmd(api, true));
        ip.addCommand("dimlineto", new DimlineCmd(api, false));
        ip.addCommand("texdimlineto", new DimlineCmd(api, true));
        ip.addCommand("dimlinerel", new DimlinerelCmd(api, false));
        ip.addCommand("texdimlinerel", new DimlinerelCmd(api, true));
        ip.addCommand("dimangle", new DimangleCmd(api));
        ip.addCommand("texdimangle", new TexdimangleCmd(api));
        ip.addCommand("fillrectangle", new FillrectCmd(api));
        ip.addCommand("fillrect", new FillrectCmd(api));
        ip.addCommand("fillbox", new FillboxCmd(api));
        ip.addCommand("fillrod", new FillrodCmd(api));
        ip.addCommand("fillpolygon", new FillpolygonCmd(api));
        ip.addCommand("fillcircle", new FillcircleCmd(api));
        ip.addCommand("fillellipse", new FillellipseCmd(api));
        ip.addCommand("fillsegment", new FillsegmentCmd(api));
        ip.addCommand("fillsector", new FillsectorCmd(api));
        ip.addCommand("image", new ImageCmd(api));
        ip.addCommand("offset", new OffsetCmd(api));
        ip.addCommand("font", new FontCmd(api));
        ip.addCommand("forceunitlength", new ForceUnitCmd(api));
        ip.addCommand("force", new ForceCmd(api, false));
        ip.addCommand("texforce", new ForceCmd(api, true));
        ip.addCommand("force2", new Force2Cmd(api, false));
        ip.addCommand("texforce2", new Force2Cmd(api, true));
        ip.addCommand("expr", new ExprCmd(api));
        ip.addCommand("exprinput", new ExprinputCmd(api));
        ip.addCommand("here", new HereCmd(api));
        ip.addCommand("r", new HereCmd(api));
        ip.addCommand("mm", new MmCmd(api));
        ip.addCommand("fu", new FuCmd(api));
        ip.addCommand("kN", new FuCmd(api));
        ip.addCommand("nf", new NfCmd(api));
        ip.addCommand("assert", new AssertCmd());
        ip.addCommand("block", new BlockCmd(api));
        ip.addCommand("endblock", new EndblockCmd(api));
        ip.addCommand("block.rotate", new BlockrotateCmd(api));
        ip.addCommand("block.flip", new BlockflipCmd(api));
        ip.addCommand("block.scale", new BlockscaleCmd(api));
    }

    private void extendModules(Interp ip, API api) throws HeclException {
        ip.addCommand("geom.intersect", new GeomIntersectCmd());
        ip.addCommand("geom.intersectlinepath", new GeomIntersectlinepathCmd());
        ip.addCommand("geom.area", new GeomAreaCmd());
        ip.addCommand("geom.centroid", new GeomCentroidCmd());
        ip.addCommand("geom.vector", new GeomVectorCmd(api));
        ip.addCommand("geom.v", new GeomVectorCmd(api));
        ip.addCommand("geom.crossproduct", new GeomCrossproductCmd());
        ip.addCommand("geom.crossprod", new GeomCrossproductCmd());
        ip.addCommand("geom.dotproduct", new GeomDotproductCmd());
        ip.addCommand("geom.dotprod", new GeomDotproductCmd());
        ip.addCommand("geom.anglerad", new GeomAngleRadCmd(api));
        ip.addCommand("geom.angle", new GeomAngleCmd(api));
        ip.addCommand("geom.length", new GeomLengthCmd());
        ip.addCommand("geom.hypot", new GeomLengthCmd());
        ip.addCommand("geom.abs", new GeomLengthCmd());
        ip.addCommand("geom.norm", new GeomNormCmd());
        ip.addCommand("geom.online", new GeomOnlineCmd());
        ip.addCommand("geom.add", new GeomAddCmd());
        ip.addCommand("++", new GeomAddCmd());
        ip.addCommand("geom.subtract", new GeomSubtractCmd());
        ip.addCommand("--", new GeomSubtractCmd());
        ip.addCommand("geom.multiply", new GeomMultiplyCmd());
        ip.addCommand("**", new GeomMultiplyCmd());
        ip.addCommand("geom.divide", new GeomDivideCmd());
        ip.addCommand("//", new GeomDivideCmd());
        ip.addCommand("geom.rotate", new GeomRotateCmd());
        ip.addCommand("geom.polar", new GeomPolarCmd());
        ip.addCommand("geom.parallel", new GeomParallelCmd(api));
        ip.addCommand("geom.extend", new GeomExtendCmd());
        ip.addCommand("geom.distance", new GeomDistanceCmd(api));
        ip.addCommand("geom.dist", new GeomDistanceCmd(api));
        ip.addCommand("geom.azimuth", new GeomAzimuthCmd(api));
        ip.addCommand("geom.azi", new GeomAzimuthCmd(api));
        ip.addCommand("geom.tox", new GeomToxCmd(api, true));
        ip.addCommand("tx", new GeomToxCmd(api, true));
        ip.addCommand("geom.toy", new GeomToxCmd(api, false));
        ip.addCommand("ty", new GeomToxCmd(api, false));
        ip.addCommand("stat.add", new StatAddCmd());
        ip.addCommand("+++", new StatAddCmd());
        ip.addCommand("stat.subtract", new StatSubtractCmd());
        ip.addCommand("---", new StatSubtractCmd());
        ip.addCommand("stat.multiply", new StatMultiplyCmd());
        ip.addCommand("***", new StatMultiplyCmd());
        ip.addCommand("stat.abs", new StatAbsCmd());
        ip.addCommand("stat.move", new StatMoveCmd());
        ip.addCommand("stat.move2", new StatMove2Cmd(api));
        ip.addCommand("stat.actionline", new StatActionlineCmd(api));
        ip.addCommand("stat.distance", new StatDistanceCmd(api));
        ip.addCommand("stat.dist", new StatDistanceCmd(api));
        ip.addCommand("stat.moment", new StatMomentCmd(api));
        ip.addCommand("stat.mequi", new StatMequilibriumCmd(api));
        ip.addCommand("stat.equi", new StatEquilibriumCmd());
        ip.addCommand("stat.fequi", new StatFequilibriumCmd());
        ip.addCommand("stat.tip", new StatTipCmd(api));
    }

    private void extendHecl(Interp ip, API api) throws HeclException {
        ip.eval(new Thing("proc X {pos} {return [lindex $pos 0]}"));
        ip.eval(new Thing("proc Y {pos} {return [lindex $pos 1]}"));
        ip.eval(new Thing("proc XY {force} {return \"[lindex $force 0] [lindex $force 1]\"}"));
        ip.eval(new Thing("proc FX {force} {return [lindex $force 2]}"));
        ip.eval(new Thing("proc FY {force} {return [lindex $force 3]}"));
        ip.eval(new Thing("proc FXY {force} {return \"[lindex $force 2] [lindex $force 3]\"}"));
    }

    public boolean sourceFile(String sourcefile) {
        boolean success = false;
        try {
            if (!sourcefile.equals("_opt_stdin")) {
                HeclFileUtils.sourceFile(this.interp, sourcefile);
                success = true;
            } else {
                LinkedList<String> sourcelist = new LinkedList<String>();
                InputStreamReader eingabestrom = new InputStreamReader(System.in, "UTF-8");
                BufferedReader eingabe = new BufferedReader(eingabestrom);
                boolean isEOF = false;
                do {
                    String zeile;
                    if ((zeile = eingabe.readLine()) != null) {
                        sourcelist.add(zeile);
                        continue;
                    }
                    isEOF = true;
                } while (!isEOF);
                eingabe.close();
                eingabestrom.close();
                if (this.verbose) {
                    System.out.println();
                }
                int zeilennr = 0;
                for (String s : sourcelist) {
                    ++zeilennr;
                    if (this.verbose) {
                        System.out.println(Fkt.nf(zeilennr, 3) + ":  " + s);
                    }
                    Thing input = new Thing(s);
                    Thing ans = this.interp.eval(input);
                    if (!this.verbose) continue;
                    System.out.println("   @  " + ans.toString());
                }
                if (this.verbose) {
                    System.out.println();
                }
                success = true;
            }
        }
        catch (HeclException e) {
            System.err.println("Hecl exception: " + e);
            success = false;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            success = false;
        }
        this.interp.terminate();
        return success;
    }
}

