/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.Thing;

public class FillsectorCmd
implements Command {
    API api;
    boolean debug = false;

    public FillsectorCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        double extent;
        double endangle;
        double startangle;
        double radius;
        double y1;
        double x1;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        double[] X = new double[3];
        double[] Y = new double[3];
        switch (argd.length) {
            case 5: {
                x1 = argd[0];
                y1 = argd[1];
                radius = argd[2];
                startangle = argd[3];
                endangle = argd[4];
                break;
            }
            case 3: {
                x1 = this.api.here()[0];
                y1 = this.api.here()[1];
                radius = argd[0];
                startangle = argd[1];
                endangle = argd[2];
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        for (extent = endangle - startangle; extent < 0.0; extent += 360.0) {
        }
        while (extent > 360.0) {
            extent -= 360.0;
        }
        this.api.moveto(x1, y1);
        this.api.movepolar(radius, startangle);
        double[] arcstart = this.api.here();
        this.api.moveto(x1, y1);
        this.api.movepolar(radius, endangle);
        double[] arcend = this.api.here();
        X[0] = x1;
        Y[0] = y1;
        X[2] = arcend[0];
        Y[2] = arcend[1];
        this.api.moveto(x1, y1);
        if (extent <= 180.0) {
            if (extent < 180.0) {
                X[1] = arcstart[0];
                Y[1] = arcstart[1];
                this.api.fillpolygon(X, Y);
            }
            this.api.fillsegment(radius, startangle, endangle);
        } else {
            double oppositeangle = startangle + 180.0;
            this.api.movepolar(radius, oppositeangle);
            double[] opposite = this.api.here();
            X[1] = opposite[0];
            Y[1] = opposite[1];
            this.api.fillpolygon(X, Y);
            this.api.fillsegment(radius, startangle, oppositeangle);
            this.api.fillsegment(radius, oppositeangle, endangle);
        }
        return null;
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

