/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.bgd;

public class clHintergrundLinie {
    private double[] von = new double[2];
    private double[] bis = new double[2];

    clHintergrundLinie(double vonX, double vonZ, double bisX, double bisZ) {
        this.von[0] = vonX;
        this.von[1] = vonZ;
        this.bis[0] = bisX;
        this.bis[1] = bisZ;
    }

    public boolean skaliere(double faktorx, double faktorz) {
        assert (Math.abs(faktorx) >= 1.0E-9);
        assert (Math.abs(faktorz) >= 1.0E-9);
        this.von[0] = faktorx * this.von[0];
        this.von[1] = faktorz * this.von[1];
        this.bis[0] = faktorx * this.bis[0];
        this.bis[1] = faktorz * this.bis[1];
        return true;
    }

    public void verschiebe(double dx, double dz) {
        this.von[0] = this.von[0] + dx;
        this.von[1] = this.von[1] + dz;
        this.bis[0] = this.bis[0] + dx;
        this.bis[1] = this.bis[1] + dz;
    }

    public void rotiere(double rot) {
        double X = this.von[0];
        double Z = this.von[1];
        this.von[0] = X * Math.cos(rot) - Z * Math.sin(rot);
        this.von[1] = X * Math.sin(rot) + Z * Math.cos(rot);
        X = this.bis[0];
        Z = this.bis[1];
        this.bis[0] = X * Math.cos(rot) - Z * Math.sin(rot);
        this.bis[1] = X * Math.sin(rot) + Z * Math.cos(rot);
    }

    public double[] getVon() {
        return this.von;
    }

    public double[] getBis() {
        return this.bis;
    }
}

