/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.bgd;

import java.io.BufferedReader;
import java.util.ArrayList;
import net.sf.drawj2d.bgd.clHintergrundBogen;
import net.sf.drawj2d.bgd.clHintergrundKreis;
import net.sf.drawj2d.bgd.clHintergrundLinie;
import net.sf.drawj2d.bgd.clHintergrundPunkt;
import net.sf.drawj2d.bgd.clParserBGD;

public class clBGD {
    ArrayList<clHintergrundLinie> hgLinien = new ArrayList();
    ArrayList<clHintergrundPunkt> hgPunkte = new ArrayList();
    ArrayList<clHintergrundKreis> hgKreise = new ArrayList();
    ArrayList<clHintergrundBogen> hgBogen = new ArrayList();
    private static final int LINE = 1;
    private static final int POLYLINE = 2;
    private static final int LWPOLYLINE = 3;
    private static final int CIRCLE = 4;
    private static final int POINT = 5;
    private static final int TEXT = 6;
    private static final int ARC = 7;
    private static final int INSERT = 8;
    private static final int SOLID = 9;
    private static final int DIMENSION = 10;
    private static final int FEHLER = -1;
    private final boolean verbose;

    public clBGD(String datei, boolean verbose) {
        this.verbose = verbose;
        this.einlesenBGD(datei);
    }

    public clBGD(BufferedReader eingabe, boolean verbose) {
        this.verbose = verbose;
        clParserBGD doc = new clParserBGD(eingabe);
        this.einlesenDOC(doc);
    }

    private boolean einlesenBGD(String datei) {
        if (this.verbose) {
            System.out.println("BGD: " + datei);
        }
        clParserBGD doc = new clParserBGD(datei);
        boolean success = this.einlesenDOC(doc);
        return success;
    }

    private boolean einlesenDOC(clParserBGD doc) {
        if (doc == null) {
            System.err.println("Error in clBGD: doc == null");
            System.err.println("Reading bgd failed");
            return false;
        }
        int entityNameNr = 0;
        clHintergrundLinie aktLinie = null;
        clHintergrundPunkt aktPunkt = null;
        clHintergrundKreis aktKreis = null;
        clHintergrundBogen aktBogen = null;
        try {
            block9: while (doc.hasMoreElements()) {
                entityNameNr = 0;
                String entityName = doc.getEntityName();
                if (entityName.equals("Line")) {
                    entityNameNr = 1;
                }
                if (entityName.equals("Circle")) {
                    entityNameNr = 4;
                }
                if (entityName.equals("Point")) {
                    entityNameNr = 5;
                }
                if (entityName.equals("Arc")) {
                    entityNameNr = 7;
                }
                if (entityName.equals("Fehler")) {
                    entityNameNr = -1;
                }
                switch (entityNameNr) {
                    case 5: {
                        double[] data = doc.getEntity();
                        aktPunkt = new clHintergrundPunkt(data[0], data[2]);
                        this.hgPunkte.add(aktPunkt);
                        continue block9;
                    }
                    case 1: {
                        double[] data = doc.getEntity();
                        aktLinie = new clHintergrundLinie(data[0], data[2], data[3], data[5]);
                        this.hgLinien.add(aktLinie);
                        continue block9;
                    }
                    case 4: {
                        double[] data = doc.getEntity();
                        aktKreis = new clHintergrundKreis(data[0], data[2], data[3]);
                        this.hgKreise.add(aktKreis);
                        continue block9;
                    }
                    case 7: {
                        double[] data = doc.getEntity();
                        aktBogen = new clHintergrundBogen(data[0], data[2], data[3], data[4], data[5]);
                        this.hgBogen.add(aktBogen);
                        continue block9;
                    }
                    case -1: {
                        System.err.println("Error while parsing entity.");
                        continue block9;
                    }
                }
                System.err.println("UNKNOWN entity: " + entityName);
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            return false;
        }
        if (this.verbose) {
            System.out.println("");
        }
        return true;
    }

    public boolean skaliere(double faktorx, double faktorz) {
        if (Math.abs(faktorx) < 1.0E-9 || Math.abs(faktorz) < 1.0E-9) {
            System.err.println("factor < 1E-9 not allowed");
            return false;
        }
        if (faktorx == 1.0 && faktorz == 1.0) {
            return true;
        }
        if (Math.abs(faktorx) != Math.abs(faktorz)) {
            if (!this.hgKreise.isEmpty()) {
                System.out.println("Hintergrundkreise koennen nicht verzerrt werden.");
            }
            if (!this.hgBogen.isEmpty()) {
                System.out.println("Hintergrundboegen koennen nicht verzerrt werden.");
            }
        }
        for (clHintergrundLinie aktuell : this.hgLinien) {
            aktuell.skaliere(faktorx, faktorz);
        }
        for (clHintergrundPunkt aktpkt : this.hgPunkte) {
            aktpkt.skaliere(faktorx, faktorz);
        }
        for (clHintergrundKreis aktkreis : this.hgKreise) {
            aktkreis.skaliere(faktorx, faktorz);
        }
        for (clHintergrundBogen aktbogen : this.hgBogen) {
            aktbogen.skaliere(faktorx, faktorz);
        }
        return true;
    }

    public void verschiebe(double dx, double dz) {
        if (dx == 0.0 && dz == 0.0) {
            return;
        }
        for (clHintergrundLinie aktuell : this.hgLinien) {
            aktuell.verschiebe(dx, dz);
        }
        for (clHintergrundPunkt aktpkt : this.hgPunkte) {
            aktpkt.verschiebe(dx, dz);
        }
        for (clHintergrundKreis aktkreis : this.hgKreise) {
            aktkreis.verschiebe(dx, dz);
        }
        for (clHintergrundBogen aktbogen : this.hgBogen) {
            aktbogen.verschiebe(dx, dz);
        }
    }

    public void rotiere(double rot) {
        if (rot == 0.0) {
            return;
        }
        for (clHintergrundLinie aktuell : this.hgLinien) {
            aktuell.rotiere(rot);
        }
        for (clHintergrundPunkt aktpkt : this.hgPunkte) {
            aktpkt.rotiere(rot);
        }
        for (clHintergrundKreis aktkreis : this.hgKreise) {
            aktkreis.rotiere(rot);
        }
        for (clHintergrundBogen aktbogen : this.hgBogen) {
            aktbogen.rotiere(rot);
        }
    }

    public ArrayList<clHintergrundLinie> getHgLinien() {
        return this.hgLinien;
    }

    public ArrayList<clHintergrundPunkt> getHgPunkte() {
        return this.hgPunkte;
    }

    public ArrayList<clHintergrundKreis> getHgKreise() {
        return this.hgKreise;
    }

    public ArrayList<clHintergrundBogen> getHgBogen() {
        return this.hgBogen;
    }

    void testen() {
        System.out.println("");
        for (clHintergrundLinie aktuell : this.hgLinien) {
            System.out.print("von " + aktuell.getVon()[0] + " " + aktuell.getVon()[1]);
            System.out.println("  bis " + aktuell.getBis()[0] + " " + aktuell.getBis()[1]);
        }
        for (clHintergrundPunkt aktpkt : this.hgPunkte) {
            System.out.println("Punkt " + aktpkt.getPkt()[0] + " " + aktpkt.getPkt()[1]);
        }
    }

    public static void main(String[] args) {
        System.out.println("Open file: " + args[0]);
        new clBGD(args[0], true);
    }
}

