/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.bgd;

import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sf.drawj2d.bgd.clBGD;
import net.sf.drawj2d.bgd.clHintergrundBogen;
import net.sf.drawj2d.bgd.clHintergrundKreis;
import net.sf.drawj2d.bgd.clHintergrundLinie;
import net.sf.drawj2d.bgd.clHintergrundPunkt;
import net.sf.drawj2d.cmd.API;
import net.sf.drawj2d.cmd.Fkt;

public class BgdInterpreter {
    API api;
    clBGD bgd;
    double mmwidth;
    double mmheight;
    double[] bounds = new double[]{-4.0, 11.0, -4.0, 4.0};
    private final double[] mstliste = new double[]{1.0, 2.0, 5.0};
    private boolean verbose = false;
    private final boolean debug = false;

    public BgdInterpreter(Graphics2D g, double mmwidth, double mmheight) {
        this.api = new API(g);
        assert (mmwidth > 0.0);
        assert (mmheight > 0.0);
        this.mmwidth = mmwidth;
        this.mmheight = mmheight;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean sourceFile(String sourcefile) {
        boolean success = false;
        try {
            if (!sourcefile.equals("_opt_stdin")) {
                this.bgd = new clBGD(sourcefile, this.verbose);
                success = true;
            } else {
                InputStreamReader eingabestrom = new InputStreamReader(System.in);
                BufferedReader eingabe = new BufferedReader(eingabestrom);
                this.bgd = new clBGD(eingabe, this.verbose);
                eingabe.close();
                eingabestrom.close();
                success = true;
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            success = false;
        }
        this.bounds = this.calculateBounds();
        return success;
    }

    private double[] calculateBounds() {
        double z0;
        double x1;
        double z1;
        double x0;
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minZ = Double.MAX_VALUE;
        double maxZ = -1.7976931348623157E308;
        for (clHintergrundPunkt clHintergrundPunkt2 : this.bgd.getHgPunkte()) {
            if (clHintergrundPunkt2.getPkt()[0] > maxX) {
                maxX = clHintergrundPunkt2.getPkt()[0];
            }
            if (clHintergrundPunkt2.getPkt()[0] < minX) {
                minX = clHintergrundPunkt2.getPkt()[0];
            }
            if (clHintergrundPunkt2.getPkt()[1] > maxZ) {
                maxZ = clHintergrundPunkt2.getPkt()[1];
            }
            if (!(clHintergrundPunkt2.getPkt()[1] < minZ)) continue;
            minZ = clHintergrundPunkt2.getPkt()[1];
        }
        for (clHintergrundLinie clHintergrundLinie2 : this.bgd.getHgLinien()) {
            x0 = clHintergrundLinie2.getVon()[0];
            double z02 = clHintergrundLinie2.getVon()[1];
            double x12 = clHintergrundLinie2.getBis()[0];
            z1 = clHintergrundLinie2.getBis()[1];
            if (x0 > maxX) {
                maxX = x0;
            }
            if (x0 < minX) {
                minX = x0;
            }
            if (z02 > maxZ) {
                maxZ = z02;
            }
            if (z02 < minZ) {
                minZ = z02;
            }
            if (x12 > maxX) {
                maxX = x12;
            }
            if (x12 < minX) {
                minX = x12;
            }
            if (z1 > maxZ) {
                maxZ = z1;
            }
            if (!(z1 < minZ)) continue;
            minZ = z1;
        }
        for (clHintergrundKreis clHintergrundKreis2 : this.bgd.getHgKreise()) {
            x0 = clHintergrundKreis2.getZentrum()[0] - clHintergrundKreis2.getRadius();
            x1 = clHintergrundKreis2.getZentrum()[0] + clHintergrundKreis2.getRadius();
            z0 = clHintergrundKreis2.getZentrum()[1] - clHintergrundKreis2.getRadius();
            z1 = clHintergrundKreis2.getZentrum()[1] + clHintergrundKreis2.getRadius();
            if (x0 > maxX) {
                maxX = x0;
            }
            if (x0 < minX) {
                minX = x0;
            }
            if (z0 > maxZ) {
                maxZ = z0;
            }
            if (z0 < minZ) {
                minZ = z0;
            }
            if (x1 > maxX) {
                maxX = x1;
            }
            if (x1 < minX) {
                minX = x1;
            }
            if (z1 > maxZ) {
                maxZ = z1;
            }
            if (!(z1 < minZ)) continue;
            minZ = z1;
        }
        for (clHintergrundBogen clHintergrundBogen2 : this.bgd.getHgBogen()) {
            x0 = clHintergrundBogen2.getZentrum()[0] + clHintergrundBogen2.getRadius() * Math.cos(clHintergrundBogen2.getSektor()[0]);
            x1 = clHintergrundBogen2.getZentrum()[0] + clHintergrundBogen2.getRadius() * Math.cos(clHintergrundBogen2.getSektor()[1]);
            z0 = clHintergrundBogen2.getZentrum()[1] - clHintergrundBogen2.getRadius() * Math.sin(clHintergrundBogen2.getSektor()[0]);
            z1 = clHintergrundBogen2.getZentrum()[1] - clHintergrundBogen2.getRadius() * Math.sin(clHintergrundBogen2.getSektor()[1]);
            if (x0 > maxX) {
                maxX = x0;
            }
            if (x0 < minX) {
                minX = x0;
            }
            if (z0 > maxZ) {
                maxZ = z0;
            }
            if (z0 < minZ) {
                minZ = z0;
            }
            if (x1 > maxX) {
                maxX = x1;
            }
            if (x1 < minX) {
                minX = x1;
            }
            if (z1 > maxZ) {
                maxZ = z1;
            }
            if (!(z1 < minZ)) continue;
            minZ = z1;
        }
        if (minX == maxX && minZ == maxZ) {
            minX -= 6.0;
            maxX += 6.0;
            minZ -= 4.0;
            maxZ += 4.0;
        }
        if (minX == Double.MAX_VALUE) {
            minX = -1.0;
        }
        if (maxX == -1.7976931348623157E308) {
            maxX = 11.0;
        }
        if (minZ == Double.MAX_VALUE) {
            minZ = -4.0;
        }
        if (maxZ == -1.7976931348623157E308) {
            maxZ = 4.0;
        }
        double[] b = new double[]{minX, maxX, minZ, maxZ};
        return b;
    }

    public void interpret(boolean autoscale) {
        double r;
        double z1;
        double x1;
        if (autoscale) {
            double unitwidth = this.bounds[1] - this.bounds[0];
            assert (unitwidth >= 0.0);
            double unitheight = this.bounds[3] - this.bounds[2];
            assert (unitheight >= 0.0);
            assert (Math.max(unitwidth, unitheight) > 0.0);
            double maxmmx = this.mmwidth / unitwidth;
            double maxmmz = this.mmheight / unitheight;
            double maxmm = Math.min(maxmmx, maxmmz);
            double mst = 1000.0 / maxmm;
            double[] n\u00e4chstgr\u00f6sser = new double[this.mstliste.length];
            for (int i = 0; i < this.mstliste.length; ++i) {
                double temp = Math.ceil(Math.log(mst / this.mstliste[i]) / Math.log(10.0));
                n\u00e4chstgr\u00f6sser[i] = this.mstliste[i] * Math.pow(10.0, temp);
            }
            mst = Fkt.min(n\u00e4chstgr\u00f6sser);
            double mm = 1000.0 / mst;
            if (this.verbose) {
                System.out.println("Autoscale 1:" + Fkt.nf(mst, 1) + ", mm: " + mm);
            }
            this.api.moveto(25.0, this.mmheight - 15.0);
            this.api.label("1:" + Fkt.nf(mst, 1));
            this.api.moveto(0.0, 0.0);
            this.api.unitlength(mm);
            double dX = this.api.mm(this.mmwidth / 2.0) - (this.bounds[0] + unitwidth / 2.0);
            double dY = this.api.mm(this.mmheight / 2.0) - (this.bounds[2] + unitheight / 2.0);
            if (this.verbose) {
                System.out.println("Autooffset dX = " + Fkt.nf(dX, 3) + "m, dY = " + Fkt.nf(dY, 3) + "m");
            }
            if (this.verbose) {
                System.out.println();
            }
            this.api.offset(dX, dY);
        }
        for (clHintergrundPunkt aktpkt : this.bgd.getHgPunkte()) {
            x1 = aktpkt.getPkt()[0];
            z1 = aktpkt.getPkt()[1];
            this.api.point(x1, z1);
        }
        for (clHintergrundLinie aktlinie : this.bgd.getHgLinien()) {
            double x0 = aktlinie.getVon()[0];
            double z0 = aktlinie.getVon()[1];
            double x12 = aktlinie.getBis()[0];
            double z12 = aktlinie.getBis()[1];
            this.api.line(x0, z0, x12, z12);
        }
        for (clHintergrundKreis aktkreis : this.bgd.getHgKreise()) {
            x1 = aktkreis.getZentrum()[0];
            z1 = aktkreis.getZentrum()[1];
            r = aktkreis.getRadius();
            this.api.circle(x1, z1, r);
        }
        for (clHintergrundBogen aktbogen : this.bgd.getHgBogen()) {
            x1 = aktbogen.getZentrum()[0];
            z1 = aktbogen.getZentrum()[1];
            r = aktbogen.getRadius();
            double startsektor = -aktbogen.getSektor()[1];
            double endsektor = -aktbogen.getSektor()[0];
            this.api.arc(x1, z1, r, startsektor, endsektor);
        }
    }
}

