/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.xml.pull.XmlPullParserException;
import javolution37.javolution.xml.pull.XmlPullParserImpl;
import javolution37.javolution.xml.sax.Attributes;
import javolution37.javolution.xml.sax.ContentHandler;
import javolution37.javolution.xml.sax.DefaultHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XmlSaxParserImpl
implements Reusable {
    private static DefaultHandler DEFAULT_HANDLER = new DefaultHandler();
    private ContentHandler _contentHandler;
    private ErrorHandler _errorHandler;
    private final XmlPullParserImpl _pullParser = new XmlPullParserImpl();
    private final LocatorImpl _locator = new LocatorImpl();
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    int[] _startLength = new int[2];
    private static final CharSequence NO_CHAR = new CharSequence(){

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new IndexOutOfBoundsException();
        }
    };

    public XmlSaxParserImpl() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler == DEFAULT_HANDLER ? null : this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler == DEFAULT_HANDLER ? null : this._errorHandler;
    }

    public void parse(InputStream in) throws IOException, SAXException {
        this._pullParser.setInput(in);
        this.parseAll();
    }

    public void parse(ByteBuffer byteBuffer) throws IOException, SAXException {
        this._pullParser.setInput(byteBuffer);
        this.parseAll();
    }

    public void parse(Reader reader) throws IOException, SAXException {
        this._pullParser.setInput(reader);
        this.parseAll();
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return true;
        }
        throw new SAXNotRecognizedException("Feature " + name + " not recognized");
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotRecognizedException("Feature " + name + " not recognized");
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + name + " not recognized");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + name + " not recognized");
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    @Override
    public void reset() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
        this._pullParser.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAll() throws IOException, SAXException {
        try {
            int eventType = this._pullParser.getEventType();
            if (eventType != 0) {
                throw new SAXException("Currently parsing");
            }
            this._contentHandler.startDocument();
            block5: while (true) {
                if ((eventType = this._pullParser.nextToken()) == 2) {
                    int depth = this._pullParser.getDepth();
                    int nsStart = this._pullParser.getNamespaceCount(depth - 1);
                    int nsEnd = this._pullParser.getNamespaceCount(depth);
                    for (int i = nsStart; i < nsEnd; ++i) {
                        CharSequence prefix = this._pullParser.getNamespacePrefix(i);
                        prefix = prefix == null ? NO_CHAR : prefix;
                        CharSequence uri = this._pullParser.getNamespaceUri(i);
                        this._contentHandler.startPrefixMapping(prefix, uri);
                    }
                    CharSequence localName = this._pullParser.getName();
                    CharSequence uri = this._pullParser.getNamespace();
                    CharSequence qName = this._pullParser.getQName();
                    Attributes atts = this._pullParser.getSaxAttributes();
                    this._contentHandler.startElement(uri, localName, qName, atts);
                    continue;
                }
                if (eventType == 3) {
                    CharSequence localName = this._pullParser.getName();
                    CharSequence uri = this._pullParser.getNamespace();
                    CharSequence qName = this._pullParser.getQName();
                    this._contentHandler.endElement(uri, localName, qName);
                    int depth = this._pullParser.getDepth();
                    int nsStart = this._pullParser.getNamespaceCount(depth);
                    int nsEnd = this._pullParser.getNamespaceCount(depth + 1);
                    int i = nsStart;
                    while (true) {
                        if (i >= nsEnd) continue block5;
                        CharSequence prefix = this._pullParser.getNamespacePrefix(i);
                        prefix = prefix == null ? NO_CHAR : prefix;
                        this._contentHandler.endPrefixMapping(prefix);
                        ++i;
                    }
                }
                if (eventType == 4 || eventType == 5) {
                    if (this._pullParser.isWhitespace()) {
                        char[] ch = this._pullParser.getTextCharacters(this._startLength);
                        this._contentHandler.ignorableWhitespace(ch, this._startLength[0], this._startLength[1]);
                        continue;
                    }
                    char[] ch = this._pullParser.getTextCharacters(this._startLength);
                    this._contentHandler.characters(ch, this._startLength[0], this._startLength[1]);
                    continue;
                }
                if (eventType == 1) break;
            }
        }
        catch (XmlPullParserException e) {
            SAXParseException error = new SAXParseException(e.getMessage(), this._locator);
            this._errorHandler.fatalError(error);
        }
        finally {
            this._contentHandler.endDocument();
            this.reset();
        }
    }

    private class LocatorImpl
    implements Locator {
        private LocatorImpl() {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return XmlSaxParserImpl.this._pullParser.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return XmlSaxParserImpl.this._pullParser.getColumnNumber();
        }
    }
}

