/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.realtime.MemoryArea;
import javolution37.javolution.lang.ClassInitializer;
import javolution37.javolution.lang.Reflection;
import javolution37.javolution.lang.Text;
import javolution37.javolution.lang.TypeFormat;
import javolution37.javolution.util.FastCollection;
import javolution37.javolution.util.FastComparator;
import javolution37.javolution.util.FastMap;
import javolution37.javolution.util.FastTable;
import javolution37.javolution.util.LocalMap;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlException;

public abstract class XmlFormat<T> {
    private static final FastMap<String, String> CLASS_TRANSFORMATIONS = new FastMap().setShared(true);
    private static final FastMap DEFAULT_INSTANCES = new FastMap().setShared(true);
    private static final LocalMap DYNAMIC_INSTANCES = new LocalMap();
    private static final LocalMap CLASS_TO_FORMAT = new LocalMap();
    private static final LocalMap CLASS_TO_ALIAS = new LocalMap();
    private static FastMap CLASS_NAME_TO_CLASS = new FastMap().setShared(true);
    private static FastMap LOCAL_NAME_TO_URI_CLASS = new FastMap().setShared(true);
    private static final LocalMap ALIAS_TO_CLASS = new LocalMap();
    public static final XmlFormat<Object> DEFAULT_XML = new XmlFormat(){

        public void format(Object obj, XmlElement xml) {
        }

        public Object parse(XmlElement xml) {
            return xml.object();
        }
    };
    static final Null NULL = new Null();
    static final XmlFormat NULL_XML = new XmlFormat((Class)NULL.getClass()){

        @Override
        public String identifier(boolean isReference) {
            return null;
        }

        public void format(Object obj, XmlElement xml) {
        }

        public Object parse(XmlElement xml) {
            return null;
        }
    };
    public static final XmlFormat<Class> CLASS_XML;
    public static final XmlFormat<String> STRING_XML;
    public static final XmlFormat<Text> TEXT_XML;
    public static final XmlFormat<Appendable> APPENDABLE_XML;
    static final XmlFormat FAST_COMPARATOR_XML;
    public static final XmlFormat<Collection> COLLECTION_XML;
    public static final XmlFormat<Map> MAP_XML;
    public static final XmlFormat<Boolean> BOOLEAN_XML;
    public static final XmlFormat<Byte> BYTE_XML;
    public static final XmlFormat<Character> CHARACTER_XML;
    public static final XmlFormat<Integer> INTEGER_XML;
    public static final XmlFormat<Long> LONG_XML;
    public static final XmlFormat<Short> SHORT_XML;
    public static final XmlFormat<Float> FLOAT_XML;
    public static final XmlFormat<Double> DOUBLE_XML;
    private static Reflection.Method STRING_INTERN;

    protected XmlFormat() {
    }

    protected XmlFormat(Class<T> rootClass) {
        if (DEFAULT_INSTANCES.put(rootClass, this) != null) {
            throw new IllegalStateException("XmlFormat already mapped to " + rootClass);
        }
    }

    protected XmlFormat(String className) {
        this(XmlFormat.classForName(className));
    }

    private static Class classForName(String className) {
        Class cls = Reflection.getClass(className);
        if (cls == null) {
            throw new XmlException("Class: " + cls + " not found");
        }
        return cls;
    }

    public static void setFormat(Class forClass, XmlFormat that) {
        DYNAMIC_INSTANCES.put(forClass, that);
        CLASS_TO_FORMAT.clear();
    }

    public static <T> XmlFormat<T> getInstance(Class<T> forClass) {
        Object xmlFormat = CLASS_TO_FORMAT.get(forClass);
        return xmlFormat != null ? (XmlFormat)xmlFormat : XmlFormat.searchInstanceFor(forClass, false);
    }

    public static void setAlias(Class forClass, String alias) {
        CLASS_TO_ALIAS.put(forClass, alias);
        ALIAS_TO_CLASS.put(alias, forClass);
    }

    public String defaultName() {
        return null;
    }

    public String identifier(boolean isReference) {
        return isReference ? "j:ref" : "j:id";
    }

    public T allocate(XmlElement xml) {
        return null;
    }

    public abstract void format(T var1, XmlElement var2);

    public abstract T parse(XmlElement var1);

    private static XmlFormat searchInstanceFor(Class clazz, boolean forceInherited) {
        Class cls;
        ClassInitializer.initialize(clazz);
        XmlFormat bestMatchFormat = null;
        Class bestMatchClass = null;
        FastCollection dynamicEntries = (FastCollection)((Object)DYNAMIC_INSTANCES.entrySet());
        FastCollection.Record r = dynamicEntries.head();
        FastMap.Entry end = dynamicEntries.tail();
        while ((r = r.getNext()) != end) {
            Map.Entry e = (Map.Entry)((Object)r);
            cls = (Class)e.getKey();
            if (cls == clazz && forceInherited || !cls.isAssignableFrom(clazz) || bestMatchClass != null && !bestMatchClass.isAssignableFrom(cls)) continue;
            bestMatchClass = cls;
            bestMatchFormat = (XmlFormat)e.getValue();
        }
        FastCollection.Record e = DEFAULT_INSTANCES.head();
        end = DEFAULT_INSTANCES.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Class cl = (Class)((FastMap.Entry)e).getKey();
            if (cl == clazz && forceInherited || (cls = (Class)((FastMap.Entry)e).getKey()) == clazz && forceInherited || !cls.isAssignableFrom(clazz) || bestMatchClass != null && (bestMatchClass == cls || !bestMatchClass.isAssignableFrom(cls))) continue;
            bestMatchClass = cls;
            bestMatchFormat = (XmlFormat)((FastMap.Entry)e).getValue();
        }
        if (bestMatchFormat == null) {
            bestMatchFormat = DEFAULT_XML;
        }
        if (!forceInherited) {
            CLASS_TO_FORMAT.put(clazz, bestMatchFormat);
        }
        return bestMatchFormat;
    }

    static String aliasFor(Class cls) {
        return (String)CLASS_TO_ALIAS.get(cls);
    }

    static Class classFor(CharSequence name) {
        Class cls = (Class)CLASS_NAME_TO_CLASS.get(name);
        return cls != null ? cls : XmlFormat.searchClassFor(name);
    }

    private static Class searchClassFor(CharSequence name) {
        Class cls;
        String transformedName = CLASS_TRANSFORMATIONS.get(name);
        if (transformedName != null) {
            name = transformedName;
        }
        if ((cls = (Class)ALIAS_TO_CLASS.get(name)) != null) {
            return cls;
        }
        String className = name.toString();
        cls = Reflection.getClass(className);
        if (cls == null) {
            throw new XmlException("Class: " + cls + " not found");
        }
        CLASS_NAME_TO_CLASS.put(XmlFormat.intern(className), cls);
        return cls;
    }

    static Class classFor(CharSequence uri, CharSequence localName) {
        FastTable uriClassTable = (FastTable)LOCAL_NAME_TO_URI_CLASS.get(localName);
        if (uriClassTable != null) {
            for (int i = 0; i < uriClassTable.size(); i += 2) {
                if (!uri.equals(uriClassTable.get(i))) continue;
                return (Class)uriClassTable.get(i + 1);
            }
        }
        return XmlFormat.searchClassFor(uri, localName);
    }

    private static Class searchClassFor(CharSequence uri, CharSequence localName) {
        Class cls;
        String uriString = uri.toString();
        final String localNameString = localName.toString();
        if (!uriString.startsWith("java:")) {
            throw new XmlException("Invalid package uri (" + uriString + "), the package uri should start with \"java:\"");
        }
        String uriSubString = uriString.substring(5) + (uriString.length() > 5 ? "." : "");
        String className = uriSubString + localName;
        String transformedName = CLASS_TRANSFORMATIONS.get(className);
        if (transformedName != null) {
            className = transformedName;
        }
        if ((cls = Reflection.getClass(className)) == null) {
            if (transformedName == null) {
                throw new XmlException("Class: " + cls + " not found");
            }
            throw new XmlException("Class: " + cls + " not found (after classname transformation)");
        }
        FastTable uriClassTable = (FastTable)LOCAL_NAME_TO_URI_CLASS.get(localNameString);
        if (uriClassTable == null) {
            MemoryArea.getMemoryArea(LOCAL_NAME_TO_URI_CLASS).executeInArea(new Runnable(){

                @Override
                public void run() {
                    LOCAL_NAME_TO_URI_CLASS.put(XmlFormat.intern(localNameString), new FastTable());
                }
            });
            uriClassTable = (FastTable)LOCAL_NAME_TO_URI_CLASS.get(localNameString);
        }
        uriClassTable.add(XmlFormat.intern(uriString));
        uriClassTable.add(cls);
        return cls;
    }

    private static String intern(String str) {
        return STRING_INTERN != null ? (String)STRING_INTERN.invoke(str) : str;
    }

    public static void addClassTransformation(String oldName, String newName) {
        CLASS_TRANSFORMATIONS.put(oldName, newName);
    }

    static {
        CLASS_TO_ALIAS.putDefault(NULL.getClass(), "null");
        ALIAS_TO_CLASS.putDefault("null", NULL.getClass());
        CLASS_XML = new XmlFormat("java.lang.Class"){

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("name", ((Class)obj).getName());
            }

            public Object parse(XmlElement xml) {
                Class cls = Reflection.getClass(xml.getAttribute("name", ""));
                if (cls == null) {
                    throw new XmlException("Class: " + cls + " not found");
                }
                return cls;
            }
        };
        STRING_XML = new XmlFormat("java.lang.String"){

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (String)obj);
            }

            public Object parse(XmlElement xml) {
                return xml.getAttribute("value", "");
            }
        };
        TEXT_XML = new XmlFormat("javolution37.javolution.lang.Text"){

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (Text)obj);
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                return csq != null ? Text.valueOf(csq) : Text.EMPTY;
            }
        };
        APPENDABLE_XML = new XmlFormat("java.lang.Appendable"){

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", Text.valueOf(obj));
            }

            public Object parse(XmlElement xml) {
                Appendable appendable = (Appendable)xml.object();
                CharSequence csq = xml.getAttribute("value");
                try {
                    return csq != null ? appendable.append(csq) : appendable;
                }
                catch (IOException e) {
                    throw new XmlException(e);
                }
            }
        };
        FAST_COMPARATOR_XML = new XmlFormat("javolution37.javolution.util.FastComparator"){

            public Object allocate(XmlElement xml) {
                if (xml.objectClass() == FastComparator.DEFAULT.getClass()) {
                    return FastComparator.DEFAULT;
                }
                if (xml.objectClass() == FastComparator.DIRECT.getClass()) {
                    return FastComparator.DIRECT;
                }
                if (xml.objectClass() == FastComparator.IDENTITY.getClass()) {
                    return FastComparator.IDENTITY;
                }
                if (xml.objectClass() == FastComparator.LEXICAL.getClass()) {
                    return FastComparator.LEXICAL;
                }
                if (xml.objectClass() == FastComparator.REHASH.getClass()) {
                    return FastComparator.REHASH;
                }
                return null;
            }

            public void format(Object obj, XmlElement xml) {
            }

            public Object parse(XmlElement xml) {
                return xml.object();
            }
        };
        COLLECTION_XML = new XmlFormat("java.util.Collection"){

            public Object allocate(XmlElement xml) {
                return xml.object();
            }

            public void format(Object obj, XmlElement xml) {
                FastComparator valueComparator;
                Collection collection = (Collection)obj;
                if (collection instanceof FastCollection && (valueComparator = ((FastCollection)collection).getValueComparator()) != FastComparator.DEFAULT) {
                    xml.add(valueComparator, "ValueComparator");
                }
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    xml.add(i.next());
                }
            }

            public Object parse(XmlElement xml) {
                FastComparator valueComparator;
                Collection collection = (Collection)xml.object();
                if (collection instanceof FastCollection && (valueComparator = (FastComparator)xml.get("ValueComparator")) != null) {
                    ((FastCollection)collection).setValueComparator(valueComparator);
                }
                while (xml.hasNext()) {
                    collection.add(xml.getNext());
                }
                return collection;
            }
        };
        MAP_XML = new XmlFormat("java.util.Map"){

            public Object allocate(XmlElement xml) {
                return xml.object();
            }

            public void format(Object obj, XmlElement xml) {
                Map map = (Map)obj;
                if (map instanceof FastMap) {
                    FastComparator valueComparator;
                    FastComparator keyComparator = ((FastMap)map).getKeyComparator();
                    if (keyComparator != FastComparator.DEFAULT) {
                        xml.add(keyComparator, "KeyComparator");
                    }
                    if ((valueComparator = ((FastMap)map).getValueComparator()) != FastComparator.DEFAULT) {
                        xml.add(valueComparator, "ValueComparator");
                    }
                }
                for (Map.Entry entry : map.entrySet()) {
                    xml.add(entry.getKey(), "Key");
                    xml.add(entry.getValue(), "Value");
                }
            }

            public Object parse(XmlElement xml) {
                Map map = (Map)xml.object();
                if (map instanceof FastMap) {
                    FastComparator valueComparator;
                    FastComparator keyComparator = (FastComparator)xml.get("KeyComparator");
                    if (keyComparator != null) {
                        ((FastMap)map).setKeyComparator(keyComparator);
                    }
                    if ((valueComparator = (FastComparator)xml.get("ValueComparator")) != null) {
                        ((FastMap)map).setValueComparator(valueComparator);
                    }
                }
                while (xml.hasNext()) {
                    Object key = xml.get("Key");
                    Object value = xml.get("Value");
                    map.put(key, value);
                }
                return map;
            }
        };
        BOOLEAN_XML = new XmlFormat("java.lang.Boolean"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (boolean)((Boolean)obj));
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Boolean(TypeFormat.parseBoolean(csq));
            }
        };
        BYTE_XML = new XmlFormat("java.lang.Byte"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (int)((Byte)obj).byteValue());
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Byte(TypeFormat.parseByte(csq));
            }
        };
        CHARACTER_XML = new XmlFormat("java.lang.Character"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", Text.valueOf(((Character)obj).charValue()));
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null || csq.length() != 1) {
                    throw new XmlException("Missing or invalid value attribute");
                }
                return new Character(csq.charAt(0));
            }
        };
        INTEGER_XML = new XmlFormat("java.lang.Integer"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (int)((Integer)obj));
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Integer(TypeFormat.parseInt(csq));
            }
        };
        LONG_XML = new XmlFormat("java.lang.Long"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (long)((Long)obj));
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Long(TypeFormat.parseLong(csq));
            }
        };
        SHORT_XML = new XmlFormat("java.lang.Short"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (int)((Short)obj).shortValue());
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Short(TypeFormat.parseShort(csq));
            }
        };
        FLOAT_XML = new XmlFormat("java.lang.Float"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", ((Float)obj).floatValue());
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Float(TypeFormat.parseFloat(csq));
            }
        };
        DOUBLE_XML = new XmlFormat("java.lang.Double"){

            @Override
            public String identifier(boolean isReference) {
                return null;
            }

            public void format(Object obj, XmlElement xml) {
                xml.setAttribute("value", (double)((Double)obj));
            }

            public Object parse(XmlElement xml) {
                CharSequence csq = xml.getAttribute("value");
                if (csq == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Double(TypeFormat.parseDouble(csq));
            }
        };
        STRING_INTERN = Reflection.getMethod("java.lang.String.intern()");
    }

    private static class Null {
        private Null() {
        }
    }
}

