/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution37.javolution.Configuration;
import javolution37.javolution.lang.PersistentReference;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.lang.Text;
import javolution37.javolution.lang.TextBuilder;
import javolution37.javolution.realtime.Realtime;
import javolution37.javolution.realtime.RealtimeObject;
import javolution37.javolution.util.FastCollection;
import javolution37.javolution.util.FastComparator;

public class FastMap<K, V>
extends RealtimeObject
implements Map<K, V>,
Reusable,
Serializable {
    private static final int R0 = 5;
    private static final int M0 = 31;
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        @Override
        public Object create() {
            return new FastMap();
        }

        @Override
        public void cleanup(Object obj) {
            ((FastMap)obj).reset();
        }
    };
    private transient Entry<K, V>[][] _entries;
    private transient Entry<K, V> _head = new Entry();
    private transient Entry<K, V> _tail = new Entry();
    private transient int _size;
    private transient Values _values = new Values();
    private transient KeySet _keySet = new KeySet();
    private transient EntrySet _entrySet = new EntrySet();
    private transient Map<K, V> _unmodifiable = new Unmodifiable();
    private transient FastMap<K, V> _oldEntries;
    private transient FastComparator _keyComparator = FastComparator.DEFAULT;
    private transient FastComparator _keyComp = Configuration.isPoorSystemHash() ? FastComparator.REHASH : null;
    private transient boolean _isShared;
    private static final Entry[] NULL_BLOCK = new Entry[32];
    static volatile boolean CHECK_POINT;

    public FastMap() {
        this(4);
    }

    public FastMap(String id) {
        this(256);
        PersistentReference<FastMap<K, V>> ref = new PersistentReference<FastMap<K, V>>(id);
        FastMap persistentMap = (FastMap)ref.get();
        if (persistentMap != null) {
            this.putAll(persistentMap);
        }
        ref.set(this);
    }

    public FastMap(int capacity) {
        int tableLength;
        for (tableLength = 32; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new Entry[tableLength >> 5][];
        int i = 0;
        while (i < this._entries.length) {
            this._entries[i++] = new Entry[32];
        }
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        Entry<K, V> previous = this._tail;
        int i2 = 0;
        while (i2++ < capacity) {
            Entry newEntry = new Entry();
            newEntry._previous = (Entry)previous;
            ((Entry)previous)._next = newEntry;
            previous = newEntry;
        }
    }

    public FastMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    private FastMap(Entry<K, V>[][] entries) {
        this._entries = entries;
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
    }

    public static <K, V> FastMap<K, V> newInstance() {
        return (FastMap)FACTORY.object();
    }

    public final Entry<K, V> head() {
        return this._head;
    }

    public final Entry<K, V> tail() {
        return this._tail;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final boolean isEmpty() {
        return ((Entry)this._head)._next == this._tail;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        return this._values.contains(value);
    }

    @Override
    public final V get(Object key) {
        Entry<K, V> entry = this.getEntry(key, this._keyComp == null ? key.hashCode() : this._keyComp.hashCodeOf(key));
        return (V)(entry != null ? ((Entry)entry)._value : null);
    }

    public final Entry<K, V> getEntry(Object key) {
        return this.getEntry(key, this._keyComp == null ? key.hashCode() : this._keyComp.hashCodeOf(key));
    }

    @Override
    public final V put(K key, V value) {
        int keyHash;
        int n = keyHash = this._keyComp == null ? key.hashCode() : this._keyComp.hashCodeOf(key);
        if (this._isShared) {
            return this.putShared(key, value, keyHash);
        }
        Entry<K, V> entry = this.getEntry(key, keyHash);
        if (entry == null) {
            this.addEntry(keyHash, key, value);
            return null;
        }
        Object prevValue = ((Entry)entry)._value;
        ((Entry)entry)._value = value;
        return (V)prevValue;
    }

    private synchronized V putShared(K key, V value, int keyHash) {
        Entry<K, V> entry = this.getEntry(key, keyHash);
        if (entry == null) {
            this.addEntry(keyHash, key, value);
            return null;
        }
        Object prevValue = ((Entry)entry)._value;
        ((Entry)entry)._value = value;
        return (V)prevValue;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        if (map instanceof FastMap) {
            FastMap fm = (FastMap)map;
            Entry e = fm._head;
            Entry<K, V> end = fm._tail;
            while ((e = e._next) != end) {
                this.put(e._key, e._value);
            }
        } else {
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public final V remove(Object key) {
        if (this._isShared) {
            return this.removeShared(key);
        }
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            Object prevValue = ((Entry)entry)._value;
            this.removeEntry(entry);
            return (V)prevValue;
        }
        return null;
    }

    private synchronized V removeShared(Object key) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            --this._size;
            ((Entry)entry).detach();
            return (V)((Entry)entry)._value;
        }
        return null;
    }

    public FastMap<K, V> setShared(boolean isShared) {
        this._isShared = isShared;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FastMap<K, V> setKeyComparator(FastComparator keyComparator) {
        this._keyComparator = keyComparator;
        this._keyComp = keyComparator instanceof FastComparator.Default ? (Configuration.isPoorSystemHash() ? FastComparator.REHASH : null) : (keyComparator instanceof FastComparator.Direct ? null : keyComparator);
        return this;
    }

    public FastComparator getKeyComparator() {
        return this._keyComparator;
    }

    public FastMap<K, V> setValueComparator(FastComparator valueComparator) {
        this._values.setValueComparator(valueComparator);
        return this;
    }

    public FastComparator getValueComparator() {
        return this._values.getValueComparator();
    }

    @Override
    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry e = this._head;
        Entry<K, V> end = this._tail;
        while ((e = e._next) != end) {
            e._key = null;
            e._value = null;
            Entry[][] table = e._table;
            table[((Entry)e)._keyHash >> 5 & table.length - 1][((Entry)e)._keyHash & 0x1F] = null;
        }
        this._tail = ((Entry)this._head)._next;
        this._size = 0;
        this._oldEntries = null;
    }

    private synchronized void clearShared() {
        Entry e = this._head;
        Entry<K, V> end = this._tail;
        while ((e = e._next) != end) {
            Entry[][] table = e._table;
            table[((Entry)e)._keyHash >> 5 & table.length - 1][((Entry)e)._keyHash & 0x1F] = null;
        }
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        this._oldEntries = null;
        this._size = 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map) {
            Map that = (Map)obj;
            if (this.size() == that.size()) {
                Set thatEntrySet = that.entrySet();
                Entry e = this._head;
                Entry<K, V> end = this._tail;
                while ((e = e._next) != end) {
                    if (thatEntrySet.contains(e)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        Entry e = this._head;
        Entry<K, V> end = this._tail;
        while ((e = e._next) != end) {
            code += e.hashCode();
        }
        return code;
    }

    @Override
    public Text toText() {
        return this._entrySet.toText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream out) {
        int maxOccupancy = 0;
        int totalCollisions = 0;
        int size = 0;
        for (int i = 0; i < this._entries.length; ++i) {
            for (int j = 0; j < this._entries[i].length; ++j) {
                Entry entry = this._entries[i][j];
                int occupancy = 0;
                while (entry != null) {
                    if (++occupancy > maxOccupancy) {
                        maxOccupancy = occupancy;
                    }
                    if (occupancy > 1) {
                        ++totalCollisions;
                    }
                    entry = entry._beside;
                    ++size;
                }
            }
        }
        TextBuilder percentCollisions = TextBuilder.newInstance();
        if (size != 0) {
            percentCollisions.append(100 * totalCollisions / size);
            percentCollisions.append('%');
        } else {
            percentCollisions.append("N/A");
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print("SIZE: " + size);
            out.print(", TABLE LENGTH: " + this._entries.length * this._entries[0].length);
            out.print(", AVG COLLISIONS: " + percentCollisions);
            out.print(", MAX SLOT OCCUPANCY: " + maxOccupancy);
            out.print(", KEY COMPARATOR: " + (this._keyComp == null ? FastComparator.DIRECT : this._keyComp));
            out.print(", SHARED: " + this._isShared);
            out.println();
            if (this._oldEntries != null) {
                out.print(" + ");
                this._oldEntries.printStatistics(out);
            }
        }
    }

    @Override
    public final Collection<V> values() {
        return this._values;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    @Override
    public final Set<K> keySet() {
        return this._keySet;
    }

    public final Map<K, V> unmodifiable() {
        return this._unmodifiable;
    }

    private final Entry<K, V> getEntry(Object key, int keyHash) {
        Entry entry = this._entries[keyHash >> 5 & this._entries.length - 1][keyHash & 0x1F];
        while (entry != null) {
            if (key == entry._key || entry._keyHash == keyHash && (this._keyComp == null ? key.equals(entry._key) : this._keyComp.areEqual(key, entry._key))) {
                return entry;
            }
            entry = entry._beside;
        }
        return this._oldEntries != null ? super.getEntry(key, keyHash) : null;
    }

    private void addEntry(int hash, K key, V value) {
        if (this._size++ >> 5 >= this._entries.length) {
            this.increaseEntryTable();
        }
        if (((Entry)this._tail)._next == null) {
            this.increaseCapacity();
        }
        Entry newTail = ((Entry)this._tail)._next;
        ((Entry)this._tail)._key = key;
        ((Entry)this._tail)._value = value;
        ((Entry)this._tail)._keyHash = hash;
        Entry.access$1002(this._tail, this._entries);
        int index = hash >> 5 & this._entries.length - 1;
        Entry<K, V>[] tmp = this._entries[index];
        if (tmp == NULL_BLOCK) {
            this.newBlock(index);
            tmp = this._entries[index];
        }
        Entry<K, V> beside = tmp[hash & 0x1F];
        ((Entry)this._tail)._beside = (Entry)beside;
        tmp[hash & 0x1F] = this._tail;
        this._tail = newTail;
    }

    private final void removeEntry(Entry entry) {
        --this._size;
        entry._key = null;
        entry._value = null;
        entry.detach();
        Entry next = ((Entry)this._tail)._next;
        entry._previous = (Entry)this._tail;
        entry._next = next;
        ((Entry)this._tail)._next = entry;
        if (next != null) {
            next._previous = entry;
        }
    }

    private void newBlock(final int index) {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                ((FastMap)FastMap.this)._entries[index] = new Entry[32];
            }
        });
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                Entry newEntry0 = new Entry();
                FastMap.this._tail._next = newEntry0;
                newEntry0._previous = FastMap.this._tail;
                Entry newEntry1 = new Entry();
                newEntry0._next = newEntry1;
                newEntry1._previous = newEntry0;
                Entry newEntry2 = new Entry();
                newEntry1._next = newEntry2;
                newEntry2._previous = newEntry1;
                Entry newEntry3 = new Entry();
                newEntry2._next = newEntry3;
                newEntry3._previous = newEntry2;
            }
        });
    }

    private void increaseEntryTable() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                FastMap tmp;
                int newLength = FastMap.this._entries.length << 3;
                if (newLength <= 8) {
                    tmp = new FastMap(new Entry[8][]);
                } else if (newLength <= 64) {
                    tmp = new FastMap(new Entry[64][]);
                } else if (newLength <= 512) {
                    tmp = new FastMap(new Entry[512][]);
                } else if (newLength <= 4096) {
                    tmp = new FastMap(new Entry[4096][]);
                } else if (newLength <= 32768) {
                    tmp = new FastMap(new Entry[32768][]);
                } else if (newLength <= 262144) {
                    tmp = new FastMap(new Entry[262144][]);
                } else if (newLength <= 0x200000) {
                    tmp = new FastMap(new Entry[0x200000][]);
                } else if (newLength <= 0x1000000) {
                    tmp = new FastMap(new Entry[0x1000000][]);
                } else if (newLength <= 0x8000000) {
                    tmp = new FastMap(new Entry[0x8000000][]);
                } else {
                    return;
                }
                int i = 0;
                while (i < tmp._entries.length) {
                    tmp._entries[i++] = NULL_BLOCK;
                }
                Entry[][] newEntries = tmp._entries;
                FastMap.access$1602(tmp, FastMap.this._entries);
                tmp._oldEntries = FastMap.this._oldEntries;
                tmp._keyComp = FastMap.this._keyComp;
                tmp._head = null;
                tmp._tail = null;
                tmp._size = -1;
                FastMap.this._oldEntries = tmp;
                FastMap.checkpoint();
                FastMap.access$1602(FastMap.this, newEntries);
            }
        });
    }

    @Override
    public boolean move(Realtime.ObjectSpace os) {
        if (super.move(os)) {
            Entry e = this._head;
            Entry<K, V> end = this._tail;
            while ((e = e._next) != end) {
                if (e._key instanceof Realtime) {
                    ((Realtime)e._key).move(os);
                }
                if (!(e._value instanceof Realtime)) continue;
                ((Realtime)e._value).move(os);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.setShared(false);
        this.clear();
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size = stream.readInt();
        int entriesLength = stream.readInt();
        this._entries = new Entry[entriesLength][];
        int i = 0;
        while (i < this._entries.length) {
            this._entries[i++] = NULL_BLOCK;
        }
        this._head = new Entry();
        this._tail = new Entry();
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._unmodifiable = new Unmodifiable();
        this.setShared(stream.readBoolean());
        this.setKeyComparator((FastComparator)stream.readObject());
        this.setValueComparator((FastComparator)stream.readObject());
        for (i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.addEntry(this._keyComparator.hashCodeOf(key), key, value);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this._size);
        stream.writeInt(this._entries.length);
        stream.writeBoolean(this._isShared);
        stream.writeObject(this._keyComparator);
        stream.writeObject(this._values.getValueComparator());
        Entry e = this._head;
        Entry<K, V> end = this._tail;
        while ((e = e._next) != end) {
            stream.writeObject(e._key);
            stream.writeObject(e._value);
        }
    }

    private static void checkpoint() {
        if (CHECK_POINT) {
            throw new Error();
        }
    }

    static /* synthetic */ Entry[][] access$1602(FastMap x0, Entry[][] x1) {
        x0._entries = x1;
        return x1;
    }

    private final class Unmodifiable
    extends RealtimeObject
    implements Map,
    Serializable {
        private Unmodifiable() {
        }

        @Override
        public boolean equals(Object obj) {
            return FastMap.this.equals(obj);
        }

        @Override
        public int hashCode() {
            return FastMap.this.hashCode();
        }

        @Override
        public Text toText() {
            return FastMap.this.toText();
        }

        @Override
        public int size() {
            return FastMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return FastMap.this.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return FastMap.this.containsValue(value);
        }

        public Object get(Object key) {
            return FastMap.this.get(key);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Set keySet() {
            return (Set)FastMap.this._keySet.unmodifiable();
        }

        public Collection values() {
            return FastMap.this._values.unmodifiable();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }
    }

    public static final class Entry<K, V>
    implements Map.Entry<K, V>,
    FastCollection.Record {
        private Entry<K, V> _next;
        private Entry<K, V> _previous;
        private K _key;
        private V _value;
        private Entry<K, V> _beside;
        private Entry<K, V>[][] _table;
        private int _keyHash;

        private Entry() {
        }

        @Override
        public final Entry<K, V> getNext() {
            return this._next;
        }

        @Override
        public final Entry<K, V> getPrevious() {
            return this._previous;
        }

        @Override
        public final K getKey() {
            return this._key;
        }

        @Override
        public final V getValue() {
            return this._value;
        }

        @Override
        public final V setValue(V value) {
            V old = this._value;
            this._value = value;
            return old;
        }

        @Override
        public boolean equals(Object that) {
            if (that instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)that;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        private final void detach() {
            this._previous._next = this._next;
            this._next._previous = this._previous;
            int index = this._keyHash >> 5 & this._table.length - 1;
            Entry<K, V> beside = this._beside;
            Entry<K, V> previous = this._table[index][this._keyHash & 0x1F];
            if (previous == this) {
                this._table[index][this._keyHash & 0x1F] = beside;
            } else {
                while (previous._beside != this) {
                    previous = previous._beside;
                }
                previous._beside = beside;
            }
        }

        static /* synthetic */ Entry[][] access$1002(Entry x0, Entry[][] x1) {
            x0._table = x1;
            return x1;
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private KeySet() {
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            return FastMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return FastMap.this.remove(obj) != null;
        }

        @Override
        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        @Override
        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._key;
        }

        @Override
        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private EntrySet() {
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Map.Entry) {
                Entry entry = (Entry)obj;
                Entry mapEntry = FastMap.this.getEntry(entry.getKey());
                return entry.equals(mapEntry);
            }
            return false;
        }

        @Override
        public Text toText() {
            Text text = Text.valueOf('[');
            Text equ = Text.valueOf('=');
            Text sep = Text.valueOf(", ");
            Entry e = FastMap.this._head;
            Entry end = FastMap.this._tail;
            while ((e = e._next) != end) {
                text = text.concat(Text.valueOf(e._key)).concat(equ).concat(Text.valueOf(e._value));
                if (e._next == end) continue;
                text = text.concat(sep);
            }
            return text.concat(Text.valueOf(']'));
        }

        @Override
        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        @Override
        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return (Map.Entry)((Object)record);
        }

        @Override
        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class Values
    extends FastCollection {
        private Values() {
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }

        @Override
        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        @Override
        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._value;
        }

        @Override
        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }
}

