/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.realtime.MemoryArea;
import javolution37.javolution.lang.PersistentReference;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.realtime.Realtime;
import javolution37.javolution.realtime.RealtimeObject;
import javolution37.javolution.util.FastCollection;
import javolution37.javolution.util.FastComparator;

public class FastList<E>
extends FastCollection<E>
implements Reusable,
List<E> {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        @Override
        public Object create() {
            return new FastList();
        }

        @Override
        public void cleanup(Object obj) {
            ((FastList)obj).reset();
        }
    };
    private transient Node<E> _head = new Node();
    private transient Node<E> _tail = new Node();
    private transient int _size;

    public FastList() {
        this(4);
    }

    public FastList(String id) {
        this(256);
        PersistentReference<FastList<E>> ref = new PersistentReference<FastList<E>>(id);
        FastList persistentList = (FastList)ref.get();
        if (persistentList != null) {
            this.addAll(persistentList);
        }
        ref.set(this);
    }

    public FastList(int capacity) {
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        Node<E> previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            Node newNode = new Node();
            newNode._previous = (Node)previous;
            ((Node)previous)._next = newNode;
            previous = newNode;
        }
    }

    public FastList(Collection<? extends E> values) {
        this(values.size());
        this.addAll(values);
    }

    public static <E> FastList<E> newInstance() {
        return (FastList)FACTORY.object();
    }

    @Override
    public final boolean add(E value) {
        this.addLast(value);
        return true;
    }

    @Override
    public int hashCode() {
        FastComparator comp = this.getValueComparator();
        int h = 1;
        Node n = this._head;
        Node<E> end = this._tail;
        while ((n = n._next) != end) {
            h = 31 * h + comp.hashCodeOf(n._value);
        }
        return h;
    }

    @Override
    public final E get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return (E)((Node)this.nodeAt(index))._value;
    }

    @Override
    public final E set(int index, E value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> node = this.nodeAt(index);
        Object previousValue = ((Node)node)._value;
        ((Node)node)._value = value;
        return (E)previousValue;
    }

    @Override
    public final void add(int index, E value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> indexNode = this.nodeAt(index);
        if (values instanceof FastList) {
            FastList list = (FastList)values;
            Node n = list._head;
            Node<E> end = list._tail;
            while ((n = n._next) != end) {
                this.addBefore(indexNode, n._value);
            }
        } else {
            Iterator<E> i = values.iterator();
            while (i.hasNext()) {
                this.addBefore(indexNode, i.next());
            }
        }
        return values.size() != 0;
    }

    @Override
    public final E remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> node = this.nodeAt(index);
        Object previousValue = ((Node)node)._value;
        this.delete(node);
        return (E)previousValue;
    }

    @Override
    public final int indexOf(Object value) {
        FastComparator comp = this.getValueComparator();
        int index = 0;
        Node n = this._head;
        Node<E> end = this._tail;
        while ((n = n._next) != end) {
            if (comp.areEqual(value, n._value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object value) {
        FastComparator comp = this.getValueComparator();
        int index = this.size() - 1;
        Node n = this._tail;
        Node<E> end = this._head;
        while ((n = n._previous) != end) {
            if (comp.areEqual(value, n._value)) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public final Iterator<E> iterator() {
        FastListIterator i = (FastListIterator)FastListIterator.FACTORY.object();
        i._list = this;
        i._length = this._size;
        i._nextNode = ((Node)this._head)._next;
        i._nextIndex = 0;
        return i;
    }

    @Override
    public final ListIterator<E> listIterator() {
        FastListIterator i = (FastListIterator)FastListIterator.FACTORY.object();
        i._list = this;
        i._length = this._size;
        i._nextNode = ((Node)this._head)._next;
        i._nextIndex = 0;
        return i;
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        if (index >= 0 && index <= this._size) {
            FastListIterator i = (FastListIterator)FastListIterator.FACTORY.object();
            i._list = this;
            i._length = this._size;
            i._nextNode = this.nodeAt(index);
            i._nextIndex = index;
            return i;
        }
        throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        SubList subList = (SubList)SubList.FACTORY.object();
        subList._list = this;
        subList._head = ((Node)this.nodeAt(fromIndex))._previous;
        subList._tail = this.nodeAt(toIndex);
        subList._size = toIndex - fromIndex;
        return subList;
    }

    @Override
    public final E getFirst() {
        Node node = ((Node)this._head)._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final E getLast() {
        Node node = ((Node)this._tail)._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final void addFirst(E value) {
        this.addBefore(((Node)this._head)._next, value);
    }

    @Override
    public void addLast(E value) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        ((Node)this._tail)._value = value;
        this._tail = ((Node)this._tail)._next;
        ++this._size;
    }

    @Override
    public final E removeFirst() {
        Node first = ((Node)this._head)._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        Object previousValue = first._value;
        this.delete(first);
        return (E)previousValue;
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        Node last = ((Node)this._tail)._previous;
        Object previousValue = last._value;
        this._tail = last;
        last._value = null;
        return (E)previousValue;
    }

    public final void addBefore(Node<E> next, E value) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        ++this._size;
        Node newNode = ((Node)this._tail)._next;
        Node tailNext = ((Node)this._tail)._next = newNode._next;
        if (tailNext != null) {
            tailNext._previous = (Node)this._tail;
        }
        Node previous = ((Node)next)._previous;
        previous._next = newNode;
        ((Node)next)._previous = newNode;
        newNode._next = (Node)next;
        newNode._previous = previous;
        newNode._value = value;
    }

    private final Node<E> nodeAt(int index) {
        int size = this._size;
        if (index <= size >> 1) {
            Node node = this._head;
            int i = index;
            while (i-- >= 0) {
                node = node._next;
            }
            return node;
        }
        Node node = this._tail;
        int i = size - index;
        while (i-- > 0) {
            node = node._previous;
        }
        return node;
    }

    @Override
    public final Node<E> head() {
        return this._head;
    }

    @Override
    public final Node<E> tail() {
        return this._tail;
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((Node)record)._value;
    }

    @Override
    public final void delete(FastCollection.Record record) {
        Node node = (Node)record;
        --this._size;
        node._value = null;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        Node next = ((Node)this._tail)._next;
        node._previous = (Node)this._tail;
        node._next = next;
        ((Node)this._tail)._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        Node n = this._head;
        Node<E> end = this._tail;
        while ((n = n._next) != end) {
            n._value = null;
        }
        this._tail = ((Node)this._head)._next;
        this._size = 0;
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    @Override
    public void reset() {
        super.setValueComparator(FastComparator.DIRECT);
        this.clear();
    }

    @Override
    public boolean move(Realtime.ObjectSpace os) {
        if (super.move(os)) {
            Node n = this._head;
            Node<E> end = this._tail;
            while ((n = n._next) != end) {
                if (!(n._value instanceof Realtime)) continue;
                ((Realtime)n._value).move(os);
            }
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this._head = new Node();
        this._tail = new Node();
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        int size = stream.readInt();
        this.setValueComparator((FastComparator)stream.readObject());
        int i = size;
        while (i-- != 0) {
            this.addLast(stream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this._size);
        stream.writeObject(this.getValueComparator());
        Node node = this._head;
        int i = this._size;
        while (i-- != 0) {
            node = node._next;
            stream.writeObject(node._value);
        }
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                Node newNode0 = new Node();
                FastList.this._tail._next = newNode0;
                newNode0._previous = FastList.this._tail;
                Node newNode1 = new Node();
                newNode0._next = newNode1;
                newNode1._previous = newNode0;
                Node newNode2 = new Node();
                newNode1._next = newNode2;
                newNode2._previous = newNode1;
                Node newNode3 = new Node();
                newNode2._next = newNode3;
                newNode3._previous = newNode2;
            }
        });
    }

    private static final class SubList
    extends FastCollection
    implements List,
    Serializable {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            protected Object create() {
                return new SubList();
            }

            @Override
            protected void cleanup(Object obj) {
                SubList sl = (SubList)obj;
                sl._list = null;
                sl._head = null;
                sl._tail = null;
            }
        };
        private FastList _list;
        private Node _head;
        private Node _tail;
        private int _size;

        private SubList() {
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public FastCollection.Record head() {
            return this._head;
        }

        @Override
        public FastCollection.Record tail() {
            return this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(FastCollection.Record record) {
            this._list.delete(record);
        }

        public boolean addAll(int index, Collection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node indexNode = this.nodeAt(index);
            Iterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            return values.size() != 0;
        }

        public Object get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        public Object set(int index, Object value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node node = this.nodeAt(index);
            Object previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        public void add(int index, Object element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
        }

        public Object remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node node = this.nodeAt(index);
            Object previousValue = node._value;
            this._list.delete(node);
            return previousValue;
        }

        @Override
        public int indexOf(Object value) {
            FastComparator comp = this._list.getValueComparator();
            int index = 0;
            Node n = this._head;
            Node end = this._tail;
            while ((n = n._next) != end) {
                if (comp.areEqual(value, n._value)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            FastComparator comp = this.getValueComparator();
            int index = this.size() - 1;
            Node n = this._tail;
            Node end = this._head;
            while ((n = n._previous) != end) {
                if (comp.areEqual(value, n._value)) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                FastListIterator i = (FastListIterator)FastListIterator.FACTORY.object();
                i._list = this._list;
                i._length = this._size;
                i._nextNode = this.nodeAt(index);
                i._nextIndex = index;
                return i;
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = (SubList)FACTORY.object();
            subList._list = this._list;
            subList._head = this.nodeAt(fromIndex)._previous;
            subList._tail = this.nodeAt(toIndex);
            subList._size = toIndex - fromIndex;
            return subList;
        }

        private final Node nodeAt(int index) {
            if (index <= this._size >> 1) {
                Node node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            Node node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }
    }

    private static final class FastListIterator
    extends RealtimeObject
    implements ListIterator {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            protected Object create() {
                return new FastListIterator();
            }

            @Override
            protected void cleanup(Object obj) {
                FastListIterator i = (FastListIterator)obj;
                i._list = null;
                i._currentNode = null;
                i._nextNode = null;
            }
        };
        private FastList _list;
        private Node _nextNode;
        private Node _currentNode;
        private int _length;
        private int _nextIndex;

        private FastListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public Object next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        public Object previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object o) {
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        public void set(Object o) {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (this._currentNode != null) {
                if (this._nextNode == this._currentNode) {
                    this._nextNode = this._nextNode._next;
                } else {
                    --this._nextIndex;
                }
                this._list.delete(this._currentNode);
                this._currentNode = null;
                --this._length;
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public static final class Node<E>
    implements FastCollection.Record,
    Serializable {
        private Node<E> _next;
        private Node<E> _previous;
        private E _value;

        private Node() {
        }

        public final E getValue() {
            return this._value;
        }

        @Override
        public final Node<E> getNext() {
            return this._next;
        }

        @Override
        public final Node<E> getPrevious() {
            return this._previous;
        }
    }
}

