/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution37.javolution.lang.Text;
import javolution37.javolution.realtime.RealtimeObject;
import javolution37.javolution.util.FastComparator;
import javolution37.javolution.util.FastIterator;

public abstract class FastCollection<E>
extends RealtimeObject
implements Collection<E>,
Serializable {
    private FastComparator _valueComp = FastComparator.DEFAULT;
    private Unmodifiable _unmodifiable;

    protected FastCollection() {
    }

    @Override
    public abstract int size();

    public abstract Record head();

    public abstract Record tail();

    public abstract E valueOf(Record var1);

    public abstract void delete(Record var1);

    public Collection<E> unmodifiable() {
        if (this._unmodifiable == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                @Override
                public void run() {
                    FastCollection.this._unmodifiable = new Unmodifiable();
                }
            });
        }
        return this._unmodifiable;
    }

    @Override
    public Iterator<E> iterator() {
        return FastIterator.valueOf(this);
    }

    public FastCollection<E> setValueComparator(FastComparator comparator) {
        this._valueComp = comparator;
        return this;
    }

    public FastComparator getValueComparator() {
        return this._valueComp;
    }

    @Override
    public boolean add(E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object value) {
        FastComparator valueComp = this.getValueComparator();
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (!valueComp.areEqual(value, this.valueOf(r))) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Record head = this.head();
        for (Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object value) {
        FastComparator valueComp = this.getValueComparator();
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (!valueComp.areEqual(value, this.valueOf(r))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c instanceof FastCollection) {
            return this.addAll((FastCollection)c);
        }
        boolean modified = false;
        Iterator<E> itr = c.iterator();
        int pos = c.size();
        while (--pos >= 0) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    private boolean addAll(FastCollection<? extends E> c) {
        boolean modified = false;
        Record r = c.head();
        Record end = c.tail();
        while ((r = r.getNext()) != end) {
            if (!this.add(c.valueOf(r))) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof FastCollection) {
            return this.containsAll((FastCollection)c);
        }
        Iterator<?> itr = c.iterator();
        int pos = c.size();
        while (--pos >= 0) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    private boolean containsAll(FastCollection<?> c) {
        Record r = c.head();
        Record end = c.tail();
        while ((r = r.getNext()) != end) {
            if (this.contains(c.valueOf(r))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Record head = this.head();
        Record r = this.tail().getPrevious();
        while (r != head) {
            Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Record head = this.head();
        Record r = this.tail().getPrevious();
        while (r != head) {
            Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            throw new UnsupportedOperationException("Destination array too small");
        }
        if (array.length > size) {
            array[size] = null;
        }
        int i = 0;
        T[] arrayView = array;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    @Override
    public Text toText() {
        Text sep = Text.valueOf(", ");
        Text text = Text.valueOf('[');
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            text = text.concat(Text.valueOf(this.valueOf(r)));
            if (r.getNext() == end) continue;
            text = text.concat(sep);
        }
        return text.concat(Text.valueOf(']'));
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof List) {
            return this.equalsList(obj);
        }
        return obj == this || obj instanceof Collection && ((Collection)obj).size() == this.size() && this.containsAll((Collection)obj);
    }

    private boolean equalsList(Object obj) {
        FastComparator comp = this.getValueComparator();
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (this.size() != list.size()) {
                return false;
            }
            Record r1 = this.head();
            Iterator i2 = list.iterator();
            int i = this.size();
            while (i-- != 0) {
                Object o2;
                E o1 = this.valueOf(r1 = r1.getNext());
                if (comp.areEqual(o1, o2 = i2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        FastComparator valueComp = this.getValueComparator();
        int hash = 0;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += valueComp.hashCodeOf(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        FastComparator comp = this.getValueComparator();
        int h = 1;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + comp.hashCodeOf(this.valueOf(r));
        }
        return h;
    }

    private final class Unmodifiable
    extends FastCollection
    implements Set,
    List {
        private Unmodifiable() {
        }

        @Override
        public int size() {
            return FastCollection.this.size();
        }

        @Override
        public Record head() {
            return FastCollection.this.head();
        }

        @Override
        public Record tail() {
            return FastCollection.this.tail();
        }

        public Object valueOf(Record record) {
            return FastCollection.this.valueOf(record);
        }

        @Override
        public boolean contains(Object value) {
            return FastCollection.this.contains(value);
        }

        @Override
        public boolean containsAll(Collection c) {
            return FastCollection.this.containsAll(c);
        }

        @Override
        public FastComparator getValueComparator() {
            return FastCollection.this.getValueComparator();
        }

        public FastCollection setValueComparator(FastComparator comparator) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean add(Object obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object get(int index) {
            return ((List)((Object)FastCollection.this)).get(index);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(Object o) {
            return ((List)((Object)FastCollection.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)((Object)FastCollection.this)).lastIndexOf(o);
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public ListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public List subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }

    public static interface Record {
        public Record getPrevious();

        public Record getNext();
    }
}

