/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import javolution37.javolution.realtime.Context;
import javolution37.javolution.util.StandardLog;

public abstract class LogContext
extends Context {
    public static final StandardLog STANDARD = new StandardLog();
    public static final LogContext NULL = new NullLog();
    public static final LogContext SYSTEM = new SystemLog();
    public static final LogContext SYSTEM_ERR = new SystemErrLog();
    private static volatile LogContext Default = STANDARD;

    public static LogContext current() {
        for (Context ctx = Context.current(); ctx != null; ctx = ctx.getOuter()) {
            if (!(ctx instanceof LogContext)) continue;
            return (LogContext)ctx;
        }
        return Default;
    }

    public static LogContext getDefault() {
        return Default;
    }

    public static void setDefault(LogContext defaultLog) {
        Default = defaultLog;
    }

    public static void info(CharSequence message) {
        LogContext logContext = LogContext.current();
        logContext.logInfo(message);
    }

    public static void warning(CharSequence message) {
        LogContext logContext = LogContext.current();
        logContext.logWarning(message);
    }

    public static void error(Throwable error) {
        LogContext logContext = LogContext.current();
        logContext.logError(error, null);
    }

    public static void error(Throwable error, CharSequence message) {
        LogContext logContext = LogContext.current();
        logContext.logError(error, message);
    }

    public abstract boolean isInfoLogged();

    public abstract void logInfo(CharSequence var1);

    public abstract boolean isWarningLogged();

    public abstract void logWarning(CharSequence var1);

    public abstract boolean isErrorLogged();

    public abstract void logError(Throwable var1, CharSequence var2);

    @Override
    protected void enterAction() {
    }

    @Override
    protected void exitAction() {
    }

    private static class SystemErrLog
    extends LogContext {
        private SystemErrLog() {
        }

        @Override
        public boolean isInfoLogged() {
            return false;
        }

        @Override
        public boolean isWarningLogged() {
            return true;
        }

        @Override
        public boolean isErrorLogged() {
            return true;
        }

        @Override
        public void logInfo(CharSequence message) {
        }

        @Override
        public void logWarning(CharSequence message) {
            System.err.print("[warning] ");
            System.err.println(message);
        }

        @Override
        public void logError(Throwable error, CharSequence message) {
            System.err.print("[error] ");
            System.err.print(error.getClass().getName());
            if (message != null) {
                System.err.print(" - ");
                System.err.println(message);
            } else {
                String errorMessage = error.getMessage();
                if (errorMessage != null) {
                    System.err.print(" - ");
                    System.err.println(errorMessage);
                } else {
                    System.err.println();
                }
            }
            error.printStackTrace();
        }
    }

    private static class SystemLog
    extends LogContext {
        private SystemLog() {
        }

        @Override
        public boolean isInfoLogged() {
            return true;
        }

        @Override
        public boolean isWarningLogged() {
            return true;
        }

        @Override
        public boolean isErrorLogged() {
            return true;
        }

        @Override
        public void logInfo(CharSequence message) {
            System.out.print("[info] ");
            System.out.println(message);
        }

        @Override
        public void logWarning(CharSequence message) {
            System.err.print("[warning] ");
            System.err.println(message);
        }

        @Override
        public void logError(Throwable error, CharSequence message) {
            System.err.print("[error] ");
            System.err.print(error.getClass().getName());
            if (message != null) {
                System.err.print(" - ");
                System.err.println(message);
            } else {
                String errorMessage = error.getMessage();
                if (errorMessage != null) {
                    System.err.print(" - ");
                    System.err.println(errorMessage);
                } else {
                    System.err.println();
                }
            }
            error.printStackTrace();
        }
    }

    private static class NullLog
    extends LogContext {
        private NullLog() {
        }

        @Override
        public boolean isInfoLogged() {
            return false;
        }

        @Override
        public boolean isWarningLogged() {
            return false;
        }

        @Override
        public boolean isErrorLogged() {
            return false;
        }

        @Override
        public void logInfo(CharSequence message) {
        }

        @Override
        public void logWarning(CharSequence message) {
        }

        @Override
        public void logError(Throwable error, CharSequence message) {
        }
    }
}

