/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import javolution37.javolution.JavolutionError;
import javolution37.javolution.lang.Reflection;
import javolution37.javolution.realtime.Context;
import javolution37.javolution.realtime.PoolContext;

public class HeapContext
extends Context {
    private static final Class CLASS = Reflection.getClass("javolution37.javolution.realtime.HeapContext");

    public static HeapContext current() {
        Context ctx;
        if (ctx.inheritedPoolContext != null) {
            return null;
        }
        for (ctx = Context.current(); ctx != null; ctx = ctx.getOuter()) {
            if (!(ctx instanceof HeapContext)) continue;
            return (HeapContext)ctx;
        }
        throw new JavolutionError("No heap context or pool context");
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    @Override
    protected void enterAction() {
        this.inheritedPoolContext = null;
        PoolContext outer = this.getOuter().inheritedPoolContext;
        if (outer != null) {
            outer.setInUsePoolsLocal(false);
        }
    }

    @Override
    protected void exitAction() {
        PoolContext outer = this.getOuter().inheritedPoolContext;
        if (outer != null) {
            outer.setInUsePoolsLocal(true);
        }
    }
}

