/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.lang;

public final class MathLib {
    private static long Seed = System.currentTimeMillis() + 8682522807148012L;
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;
    public static final double FOUR_PI = Math.PI * 4;
    public static final double PI_SQUARE = Math.PI * Math.PI;
    public static final double LOG2 = 0.6931471805599453;
    public static final double LOG10 = 2.302585092994046;
    public static final double SQRT2 = 1.4142135623730951;
    public static final double NaN = Double.NaN;
    public static final double Infinity = Double.POSITIVE_INFINITY;
    private static double INV_LOG10 = 0.4342944819032518;
    private static final double INV_MAX_VALUE = 4.656612875245797E-10;
    private static final double[] POW_10_POS = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E128, 1.0E129, 1.0E130, 1.0E131, 1.0E132, 1.0E133, 1.0E134, 1.0E135, 1.0E136, 1.0E137, 1.0E138, 1.0E139, 1.0E140, 1.0E141, 1.0E142, 1.0E143, 1.0E144, 1.0E145, 1.0E146, 1.0E147, 1.0E148, 1.0E149, 1.0E150, 1.0E151, 1.0E152, 1.0E153, 1.0E154, 1.0E155, 1.0E156, 1.0E157, 1.0E158, 1.0E159, 1.0E160, 1.0E161, 1.0E162, 1.0E163, 1.0E164, 1.0E165, 1.0E166, 1.0E167, 1.0E168, 1.0E169, 1.0E170, 1.0E171, 1.0E172, 1.0E173, 1.0E174, 1.0E175, 1.0E176, 1.0E177, 1.0E178, 1.0E179, 1.0E180, 1.0E181, 1.0E182, 1.0E183, 1.0E184, 1.0E185, 1.0E186, 1.0E187, 1.0E188, 1.0E189, 1.0E190, 1.0E191, 1.0E192, 1.0E193, 1.0E194, 1.0E195, 1.0E196, 1.0E197, 1.0E198, 1.0E199, 1.0E200, 1.0E201, 1.0E202, 1.0E203, 1.0E204, 1.0E205, 1.0E206, 1.0E207, 1.0E208, 1.0E209, 1.0E210, 1.0E211, 1.0E212, 1.0E213, 1.0E214, 1.0E215, 1.0E216, 1.0E217, 1.0E218, 1.0E219, 1.0E220, 1.0E221, 1.0E222, 1.0E223, 1.0E224, 1.0E225, 1.0E226, 1.0E227, 1.0E228, 1.0E229, 1.0E230, 1.0E231, 1.0E232, 1.0E233, 1.0E234, 1.0E235, 1.0E236, 1.0E237, 1.0E238, 1.0E239, 1.0E240, 1.0E241, 1.0E242, 1.0E243, 1.0E244, 1.0E245, 1.0E246, 1.0E247, 1.0E248, 1.0E249, 1.0E250, 1.0E251, 1.0E252, 1.0E253, 1.0E254, 1.0E255, 1.0E256, 1.0E257, 1.0E258, 1.0E259, 1.0E260, 1.0E261, 1.0E262, 1.0E263, 1.0E264, 1.0E265, 1.0E266, 1.0E267, 1.0E268, 1.0E269, 1.0E270, 1.0E271, 1.0E272, 1.0E273, 1.0E274, 1.0E275, 1.0E276, 1.0E277, 1.0E278, 1.0E279, 1.0E280, 1.0E281, 1.0E282, 1.0E283, 1.0E284, 1.0E285, 1.0E286, 1.0E287, 1.0E288, 1.0E289, 1.0E290, 1.0E291, 1.0E292, 1.0E293, 1.0E294, 1.0E295, 1.0E296, 1.0E297, 1.0E298, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E303, 1.0E304, 1.0E305, 1.0E306, 1.0E307, 1.0E308};
    private static final double[] POW_10_NEG = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0E-16, 1.0E-17, 1.0E-18, 1.0E-19, 1.0E-20, 1.0E-21, 1.0E-22, 1.0E-23, 1.0E-24, 1.0E-25, 1.0E-26, 1.0E-27, 1.0E-28, 1.0E-29, 1.0E-30, 1.0E-31, 1.0E-32, 1.0E-33, 1.0E-34, 1.0E-35, 1.0E-36, 1.0E-37, 1.0E-38, 1.0E-39, 1.0E-40, 1.0E-41, 1.0E-42, 1.0E-43, 1.0E-44, 1.0E-45, 1.0E-46, 1.0E-47, 1.0E-48, 1.0E-49, 1.0E-50, 1.0E-51, 1.0E-52, 1.0E-53, 1.0E-54, 1.0E-55, 1.0E-56, 1.0E-57, 1.0E-58, 1.0E-59, 1.0E-60, 1.0E-61, 1.0E-62, 1.0E-63, 1.0E-64, 1.0E-65, 1.0E-66, 1.0E-67, 1.0E-68, 1.0E-69, 1.0E-70, 1.0E-71, 1.0E-72, 1.0E-73, 1.0E-74, 1.0E-75, 1.0E-76, 1.0E-77, 1.0E-78, 1.0E-79, 1.0E-80, 1.0E-81, 1.0E-82, 1.0E-83, 1.0E-84, 1.0E-85, 1.0E-86, 1.0E-87, 1.0E-88, 1.0E-89, 1.0E-90, 1.0E-91, 1.0E-92, 1.0E-93, 1.0E-94, 1.0E-95, 1.0E-96, 1.0E-97, 1.0E-98, 1.0E-99, 1.0E-100, 1.0E-101, 1.0E-102, 1.0E-103, 1.0E-104, 1.0E-105, 1.0E-106, 1.0E-107, 1.0E-108, 1.0E-109, 1.0E-110, 1.0E-111, 1.0E-112, 1.0E-113, 1.0E-114, 1.0E-115, 1.0E-116, 1.0E-117, 1.0E-118, 1.0E-119, 1.0E-120, 1.0E-121, 1.0E-122, 1.0E-123, 1.0E-124, 1.0E-125, 1.0E-126, 1.0E-127, 1.0E-128, 1.0E-129, 1.0E-130, 1.0E-131, 1.0E-132, 1.0E-133, 1.0E-134, 1.0E-135, 1.0E-136, 1.0E-137, 1.0E-138, 1.0E-139, 1.0E-140, 1.0E-141, 1.0E-142, 1.0E-143, 1.0E-144, 1.0E-145, 1.0E-146, 1.0E-147, 1.0E-148, 1.0E-149, 1.0E-150, 1.0E-151, 1.0E-152, 1.0E-153, 1.0E-154, 1.0E-155, 1.0E-156, 1.0E-157, 1.0E-158, 1.0E-159, 1.0E-160, 1.0E-161, 1.0E-162, 1.0E-163, 1.0E-164, 1.0E-165, 1.0E-166, 1.0E-167, 1.0E-168, 1.0E-169, 1.0E-170, 1.0E-171, 1.0E-172, 1.0E-173, 1.0E-174, 1.0E-175, 1.0E-176, 1.0E-177, 1.0E-178, 1.0E-179, 1.0E-180, 1.0E-181, 1.0E-182, 1.0E-183, 1.0E-184, 1.0E-185, 1.0E-186, 1.0E-187, 1.0E-188, 1.0E-189, 1.0E-190, 1.0E-191, 1.0E-192, 1.0E-193, 1.0E-194, 1.0E-195, 1.0E-196, 1.0E-197, 1.0E-198, 1.0E-199, 1.0E-200, 1.0E-201, 1.0E-202, 1.0E-203, 1.0E-204, 1.0E-205, 1.0E-206, 1.0E-207, 1.0E-208, 1.0E-209, 1.0E-210, 1.0E-211, 1.0E-212, 1.0E-213, 1.0E-214, 1.0E-215, 1.0E-216, 1.0E-217, 1.0E-218, 1.0E-219, 1.0E-220, 1.0E-221, 1.0E-222, 1.0E-223, 1.0E-224, 1.0E-225, 1.0E-226, 1.0E-227, 1.0E-228, 1.0E-229, 1.0E-230, 1.0E-231, 1.0E-232, 1.0E-233, 1.0E-234, 1.0E-235, 1.0E-236, 1.0E-237, 1.0E-238, 1.0E-239, 1.0E-240, 1.0E-241, 1.0E-242, 1.0E-243, 1.0E-244, 1.0E-245, 1.0E-246, 1.0E-247, 1.0E-248, 1.0E-249, 1.0E-250, 1.0E-251, 1.0E-252, 1.0E-253, 1.0E-254, 1.0E-255, 1.0E-256, 1.0E-257, 1.0E-258, 1.0E-259, 1.0E-260, 1.0E-261, 1.0E-262, 1.0E-263, 1.0E-264, 1.0E-265, 1.0E-266, 1.0E-267, 1.0E-268, 1.0E-269, 1.0E-270, 1.0E-271, 1.0E-272, 1.0E-273, 1.0E-274, 1.0E-275, 1.0E-276, 1.0E-277, 1.0E-278, 1.0E-279, 1.0E-280, 1.0E-281, 1.0E-282, 1.0E-283, 1.0E-284, 1.0E-285, 1.0E-286, 1.0E-287, 1.0E-288, 1.0E-289, 1.0E-290, 1.0E-291, 1.0E-292, 1.0E-293, 1.0E-294, 1.0E-295, 1.0E-296, 1.0E-297, 1.0E-298, 1.0E-299, 1.0E-300, 1.0E-301, 1.0E-302, 1.0E-303, 1.0E-304, 1.0E-305, 1.0E-306, 1.0E-307, 1.0E-308, 1.0E-309, 1.0E-310, 1.0E-311, 1.0E-312, 1.0E-313, 1.0E-314, 1.0E-315, 1.0E-316, 1.0E-317, 1.0E-318, 1.0E-319, 1.0E-320, 1.0E-321, 9.9E-323, 9.9E-324};
    static final double[] atanhi = new double[]{0.4636476090008061, 0.7853981633974483, 0.982793723247329, 1.5707963267948966};
    static final double[] atanlo = new double[]{2.2698777452961687E-17, 3.061616997868383E-17, 1.3903311031230998E-17, 6.123233995736766E-17};
    static final double[] aT = new double[]{0.3333333333333293, -0.19999999999876483, 0.14285714272503466, -0.11111110405462356, 0.09090887133436507, -0.0769187620504483, 0.06661073137387531, -0.058335701337905735, 0.049768779946159324, -0.036531572744216916, 0.016285820115365782};
    static final double one = 1.0;
    static final double huge = 1.0E300;
    static final double ln2_hi = 0.6931471803691238;
    static final double ln2_lo = 1.9082149292705877E-10;
    static final double two54 = 1.8014398509481984E16;
    static final double Lg1 = 0.6666666666666735;
    static final double Lg2 = 0.3999999999940942;
    static final double Lg3 = 0.2857142874366239;
    static final double Lg4 = 0.22222198432149784;
    static final double Lg5 = 0.1818357216161805;
    static final double Lg6 = 0.15313837699209373;
    static final double Lg7 = 0.14798198605116586;
    static final double zero = 0.0;
    static final double[] halF = new double[]{0.5, -0.5};
    static final double twom1000 = 9.332636185032189E-302;
    static final double o_threshold = 709.782712893384;
    static final double u_threshold = -745.1332191019411;
    static final double[] ln2HI = new double[]{0.6931471803691238, -0.6931471803691238};
    static final double[] ln2LO = new double[]{1.9082149292705877E-10, -1.9082149292705877E-10};
    static final double invln2 = 1.4426950408889634;
    static final double P1 = 0.16666666666666602;
    static final double P2 = -0.0027777777777015593;
    static final double P3 = 6.613756321437934E-5;
    static final double P4 = -1.6533902205465252E-6;
    static final double P5 = 4.1381367970572385E-8;

    private MathLib() {
    }

    public static synchronized int randomInt(int min, int max) {
        int i = (int)((Seed = Seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) >>> 16);
        return i < 0 ? min - i % (max - min + 1) : min + i % (max - min + 1);
    }

    public static double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double toDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double rem(double x, double y) {
        double tmp = x / y;
        if (MathLib.abs(tmp) <= 9.223372036854776E18) {
            return x - (double)MathLib.round(tmp) * y;
        }
        return Double.NaN;
    }

    public static double ceil(double x) {
        return Math.ceil(x);
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static double sin(double radians) {
        return Math.sin(radians);
    }

    public static double cos(double radians) {
        return Math.cos(radians);
    }

    public static double tan(double radians) {
        return Math.tan(radians);
    }

    public static double asin(double x) {
        if (x < -1.0 || x > 1.0) {
            return Double.NaN;
        }
        if (x == -1.0) {
            return -1.5707963267948966;
        }
        if (x == 1.0) {
            return 1.5707963267948966;
        }
        return MathLib.atan(x / MathLib.sqrt(1.0 - x * x));
    }

    public static double acos(double x) {
        return 1.5707963267948966 - MathLib.asin(x);
    }

    public static double atan(double x) {
        return MathLib._atan(x);
    }

    public static double atan2(double y, double x) {
        double epsilon = 1.0E-128;
        if (MathLib.abs(x) > 1.0E-128) {
            double temp = MathLib.atan(MathLib.abs(y) / MathLib.abs(x));
            if (x < 0.0) {
                temp = Math.PI - temp;
            }
            if (y < 0.0) {
                temp = Math.PI * 2 - temp;
            }
            return temp;
        }
        if (y > 1.0E-128) {
            return 1.5707963267948966;
        }
        if (y < -1.0E-128) {
            return 4.71238898038469;
        }
        return 0.0;
    }

    public static double sinh(double x) {
        return (MathLib.exp(x) - MathLib.exp(-x)) * 0.5;
    }

    public static double cosh(double x) {
        return (MathLib.exp(x) + MathLib.exp(-x)) * 0.5;
    }

    public static double tanh(double x) {
        return (MathLib.exp(2.0 * x) - 1.0) / (MathLib.exp(2.0 * x) + 1.0);
    }

    public static double exp(double x) {
        return MathLib._ieee754_exp(x);
    }

    public static double log(double x) {
        return MathLib._ieee754_log(x);
    }

    public static double log10(double x) {
        return MathLib.log(x) * INV_LOG10;
    }

    public static double pow(double x, double y) {
        return MathLib.exp(y * MathLib.log(x));
    }

    public static int round(float f) {
        return (int)MathLib.floor(f + 0.5f);
    }

    public static long round(double d) {
        return (long)MathLib.floor(d + 0.5);
    }

    public static double random() {
        return (double)MathLib.randomInt(0, Integer.MAX_VALUE) * 4.656612875245797E-10;
    }

    public static int abs(int i) {
        return i < 0 ? -i : i;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static double abs(double d) {
        return d < 0.0 ? -d : d;
    }

    public static int max(int x, int y) {
        return x >= y ? x : y;
    }

    public static long max(long x, long y) {
        return x >= y ? x : y;
    }

    public static float max(float x, float y) {
        return x >= y ? x : y;
    }

    public static double max(double x, double y) {
        return x >= y ? x : y;
    }

    public static int min(int x, int y) {
        return x < y ? x : y;
    }

    public static long min(long x, long y) {
        return x < y ? x : y;
    }

    public static float min(float x, float y) {
        return x < y ? x : y;
    }

    public static double min(double x, double y) {
        return x < y ? x : y;
    }

    public static double toDouble(long mantissa, int n) {
        return n < 0 ? (n >= -323 ? (double)mantissa * POW_10_NEG[-n] : (double)mantissa * 0.0) : (n <= 308 ? (double)mantissa * POW_10_POS[n] : (double)mantissa * Double.POSITIVE_INFINITY);
    }

    static double _atan(double x) {
        int id;
        long xBits = Double.doubleToLongBits(x);
        int __HIx = (int)(xBits >> 32);
        int __LOx = (int)xBits;
        int hx = __HIx;
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x44100000) {
            if (ix > 0x7FF00000 || ix == 0x7FF00000 && __LOx != 0) {
                return x + x;
            }
            if (hx > 0) {
                return atanhi[3] + atanlo[3];
            }
            return -atanhi[3] - atanlo[3];
        }
        if (ix < 1071382528) {
            if (ix < 1042284544 && 1.0E300 + x > 1.0) {
                return x;
            }
            id = -1;
        } else {
            x = MathLib.abs(x);
            if (ix < 0x3FF30000) {
                if (ix < 1072037888) {
                    id = 0;
                    x = (2.0 * x - 1.0) / (2.0 + x);
                } else {
                    id = 1;
                    x = (x - 1.0) / (x + 1.0);
                }
            } else if (ix < 1073971200) {
                id = 2;
                x = (x - 1.5) / (1.0 + 1.5 * x);
            } else {
                id = 3;
                x = -1.0 / x;
            }
        }
        double z = x * x;
        double w = z * z;
        double s1 = z * (aT[0] + w * (aT[2] + w * (aT[4] + w * (aT[6] + w * (aT[8] + w * aT[10])))));
        double s2 = w * (aT[1] + w * (aT[3] + w * (aT[5] + w * (aT[7] + w * aT[9]))));
        if (id < 0) {
            return x - x * (s1 + s2);
        }
        z = atanhi[id] - (x * (s1 + s2) - atanlo[id] - x);
        return hx < 0 ? -z : z;
    }

    static double _ieee754_log(double x) {
        long xBits = Double.doubleToLongBits(x);
        int hx = (int)(xBits >> 32);
        int lx = (int)xBits;
        int k = 0;
        if (hx < 0x100000) {
            if ((hx & Integer.MAX_VALUE | lx) == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (hx < 0) {
                return (x - x) / 0.0;
            }
            k -= 54;
            xBits = Double.doubleToLongBits(x *= 1.8014398509481984E16);
            hx = (int)(xBits >> 32);
        }
        if (hx >= 0x7FF00000) {
            return x + x;
        }
        k += (hx >> 20) - 1023;
        int i = (hx &= 0xFFFFF) + 614244 & 0x100000;
        xBits = Double.doubleToLongBits(x);
        int HIx = hx | i ^ 0x3FF00000;
        xBits = ((long)HIx & 0xFFFFFFFFL) << 32 | xBits & 0xFFFFFFFFL;
        x = Double.longBitsToDouble(xBits);
        k += i >> 20;
        double f = x - 1.0;
        if ((0xFFFFF & 2 + hx) < 3) {
            if (f == 0.0) {
                if (k == 0) {
                    return 0.0;
                }
                double dk = k;
                return dk * 0.6931471803691238 + dk * 1.9082149292705877E-10;
            }
            double R = f * f * (0.5 - 0.3333333333333333 * f);
            if (k == 0) {
                return f - R;
            }
            double dk = k;
            return dk * 0.6931471803691238 - (R - dk * 1.9082149292705877E-10 - f);
        }
        double s = f / (2.0 + f);
        double dk = k;
        double z = s * s;
        i = hx - 398458;
        double w = z * z;
        int j = 440401 - hx;
        double t1 = w * (0.3999999999940942 + w * (0.22222198432149784 + w * 0.15313837699209373));
        double t2 = z * (0.6666666666666735 + w * (0.2857142874366239 + w * (0.1818357216161805 + w * 0.14798198605116586)));
        double R = t2 + t1;
        if ((i |= j) > 0) {
            double hfsq = 0.5 * f * f;
            if (k == 0) {
                return f - (hfsq - s * (hfsq + R));
            }
            return dk * 0.6931471803691238 - (hfsq - (s * (hfsq + R) + dk * 1.9082149292705877E-10) - f);
        }
        if (k == 0) {
            return f - s * (f - R);
        }
        return dk * 0.6931471803691238 - (s * (f - R) - dk * 1.9082149292705877E-10 - f);
    }

    static double _ieee754_exp(double x) {
        double t;
        double hi = 0.0;
        double lo = 0.0;
        int k = 0;
        long xBits = Double.doubleToLongBits(x);
        int __HIx = (int)(xBits >> 32);
        int __LOx = (int)xBits;
        int hx = __HIx;
        int xsb = hx >> 31 & 1;
        if ((hx &= Integer.MAX_VALUE) >= 1082535490) {
            if (hx >= 0x7FF00000) {
                if ((hx & 0xFFFFF | __LOx) != 0) {
                    return x + x;
                }
                return xsb == 0 ? x : 0.0;
            }
            if (x > 709.782712893384) {
                return Double.POSITIVE_INFINITY;
            }
            if (x < -745.1332191019411) {
                return 0.0;
            }
        }
        if (hx > 1071001154) {
            if (hx < 1072734898) {
                hi = x - ln2HI[xsb];
                lo = ln2LO[xsb];
                k = 1 - xsb - xsb;
            } else {
                k = (int)(1.4426950408889634 * x + halF[xsb]);
                t = k;
                hi = x - t * ln2HI[0];
                lo = t * ln2LO[0];
            }
            x = hi - lo;
        } else if (hx < 0x3E300000) {
            if (1.0E300 + x > 1.0) {
                return 1.0 + x;
            }
        } else {
            k = 0;
        }
        t = x * x;
        double c = x - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        if (k == 0) {
            return 1.0 - (x * c / (c - 2.0) - x);
        }
        double y = 1.0 - (lo - x * c / (2.0 - c) - hi);
        long yBits = Double.doubleToLongBits(y);
        int __HIy = (int)(yBits >> 32);
        if (k >= -1021) {
            yBits = ((long)(__HIy += k << 20) & 0xFFFFFFFFL) << 32 | yBits & 0xFFFFFFFFL;
            y = Double.longBitsToDouble(yBits);
            return y;
        }
        yBits = ((long)(__HIy += k + 1000 << 20) & 0xFFFFFFFFL) << 32 | yBits & 0xFFFFFFFFL;
        y = Double.longBitsToDouble(yBits);
        return y * 9.332636185032189E-302;
    }
}

