/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution;

import javolution37.javolution.Javolution;
import javolution37.javolution.lang.MathLib;
import javolution37.javolution.lang.Text;
import javolution37.javolution.realtime.PoolContext;

final class Perf_Lang
extends Javolution
implements Runnable {
    static volatile int COUNT = 1000;
    private final String STRING = "Concatenates this line 1000 times (resulting in a text of about 80,000 characters)";
    private final Text TEXT = Text.valueOf("Concatenates this line 1000 times (resulting in a text of about 80,000 characters)");
    private final Text ONE_CHAR = Text.valueOf('X');

    Perf_Lang() {
    }

    @Override
    public void run() {
        int index;
        Text txt;
        int j;
        StringBuffer sb;
        int i;
        Perf_Lang.println("//////////////////////////////");
        Perf_Lang.println("// Package: javolution.lang //");
        Perf_Lang.println("//////////////////////////////");
        Perf_Lang.println("");
        Perf_Lang.println("-- String/StringBuffer versus Text --");
        Perf_Lang.println("");
        Perf_Lang.println("\"Concatenates this line 1000 times (resulting in a text of about 80,000 characters)\"");
        Perf_Lang.print("String \"+\" operator: ");
        Perf_Lang.startTime();
        String str = "";
        int j2 = COUNT;
        while (--j2 >= 0) {
            str = str + "Concatenates this line 1000 times (resulting in a text of about 80,000 characters)";
        }
        Perf_Lang.println(Perf_Lang.endTime(1));
        Perf_Lang.print("StringBuffer \"append\" : ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            sb = new StringBuffer();
            j = COUNT;
            while (--j >= 0) {
                sb.append("Concatenates this line 1000 times (resulting in a text of about 80,000 characters)");
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text \"concat\" (heap): ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            txt = Text.EMPTY;
            j = COUNT;
            while (--j >= 0) {
                txt = txt.concat(this.TEXT);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text \"concat\" (stack): ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            PoolContext.enter();
            txt = Text.EMPTY;
            j = COUNT;
            while (--j >= 0) {
                txt = txt.concat(this.TEXT);
            }
            PoolContext.exit();
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.println("");
        Perf_Lang.println("Inserts one character at random locations 1,000 times to the 80,000 characters text.");
        Perf_Lang.print("StringBuffer insert: ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            sb = new StringBuffer(str);
            j = COUNT;
            while (--j >= 0) {
                index = MathLib.randomInt(0, sb.length());
                sb.insert(index, 'X');
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text insert (heap): ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            txt = Text.valueOf(str);
            j = COUNT;
            while (--j >= 0) {
                index = MathLib.randomInt(0, txt.length());
                txt = txt.insert(index, this.ONE_CHAR);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text insert (stack): ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            PoolContext.enter();
            txt = Text.valueOf(str);
            j = COUNT;
            while (--j >= 0) {
                index = MathLib.randomInt(0, txt.length());
                txt = txt.insert(index, this.ONE_CHAR);
            }
            PoolContext.exit();
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.println("");
        Perf_Lang.println("Delete 1,000 times one character at random location from the 80,000 characters text.");
        Perf_Lang.print("StringBuffer delete: ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            sb = new StringBuffer(str);
            j = COUNT;
            while (--j >= 0) {
                index = MathLib.randomInt(0, sb.length() - 1);
                sb.deleteCharAt(index);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text delete (heap): ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            txt = Text.valueOf(str);
            j = COUNT;
            while (--j >= 0) {
                index = MathLib.randomInt(0, txt.length() - 1);
                txt = txt.delete(index, index + 1);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text delete (stack): ");
        Perf_Lang.startTime();
        for (i = 0; i < 100; ++i) {
            PoolContext.enter();
            txt = Text.valueOf(str);
            j = COUNT;
            while (--j >= 0) {
                index = MathLib.randomInt(0, txt.length() - 1);
                txt = txt.delete(index, index + 1);
            }
            PoolContext.exit();
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.println("");
    }
}

