/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution;

import java.io.PrintStream;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.Perf_Lang;
import javolution37.javolution.Perf_Realtime;
import javolution37.javolution.Perf_Util;
import javolution37.javolution.Perf_Xml;
import javolution37.javolution.lang.Reflection;
import javolution37.javolution.lang.TextBuilder;

public class Javolution {
    public static final String VERSION = "3.7.10 (J2SE 1.5+) June 18 2008";
    private static PrintStream Out = System.out;
    private static long _time;
    private static final Reflection.Method NANO_TIME_METHOD;

    protected Javolution() {
    }

    public static void main(String[] args) throws Exception {
        Javolution.println("Javolution - Java(TM) Solution for Real-Time and Embedded Systems");
        Javolution.println("Version 3.7.10 (J2SE 1.5+) June 18 2008 (http://javolution.org)");
        Javolution.println("");
        if (args.length > 0) {
            if (args[0].equals("version")) {
                return;
            }
            if (args[0].equals("test")) {
                Javolution.testing();
                return;
            }
            if (args[0].equals("perf")) {
                Javolution.benchmark();
                return;
            }
        }
        Javolution.println("Usage: java -jar javolution.jar [arg]");
        Javolution.println("where arg is one of:");
        Javolution.println("    version (to show version information only)");
        Javolution.println("    test    (to perform self-tests)");
        Javolution.println("    perf    (to run benchmark)");
    }

    private static void testing() throws Exception {
        Javolution.print("Testing...");
        Javolution.println("");
        Javolution.println("Success");
    }

    private static void benchmark() throws Exception {
        Javolution.println("Benchmark...");
        Javolution.println("");
        Thread.currentThread().setPriority(10);
        new Perf_Lang().run();
        new Perf_Realtime().run();
        new Perf_Util().run();
        new Perf_Xml().run();
        Javolution.println("");
        Javolution.println("More performance analysis in future versions...");
    }

    public static void println(Object obj) {
        if (Out == null) {
            return;
        }
        Out.println(obj);
    }

    public static void print(Object obj) {
        if (Out == null) {
            return;
        }
        Out.print(obj);
    }

    public static void startTime() {
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new JavolutionError(e);
        }
        _time = Javolution.nanoTime();
    }

    public static void setOutputStream(PrintStream out) {
        Out = out;
    }

    public static String endTime(int iterations) {
        long divisor;
        String unit;
        long nanoSeconds = Javolution.nanoTime() - _time;
        long picoDuration = nanoSeconds * 1000L / (long)iterations;
        if (picoDuration > 1000000000000L) {
            unit = " s";
            divisor = 1000000000000L;
        } else if (picoDuration > 1000000000L) {
            unit = " ms";
            divisor = 1000000000L;
        } else if (picoDuration > 1000000L) {
            unit = " us";
            divisor = 1000000L;
        } else {
            unit = " ns";
            divisor = 1000L;
        }
        TextBuilder tb = TextBuilder.newInstance();
        tb.append(picoDuration / divisor);
        int fracDigits = 4 - tb.length();
        tb.append(".");
        int i = 0;
        int j = 10;
        while (i < fracDigits) {
            tb.append(picoDuration * (long)j / divisor % 10L);
            ++i;
            j *= 10;
        }
        return tb.append(unit).toString();
    }

    private static long nanoTime() {
        if (NANO_TIME_METHOD != null) {
            Long time = (Long)NANO_TIME_METHOD.invoke(null);
            return time;
        }
        return System.currentTimeMillis() * 1000000L;
    }

    static {
        NANO_TIME_METHOD = Reflection.getMethod("java.lang.System.nanoTime()");
    }
}

