/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

import com.jstatcom.util.UMatrix;
import java.util.ArrayList;

public final class UStringArray {
    private UStringArray() {
    }

    public static String[][] appendStringCols(String[][] orig, String[][] toAppend) {
        if (orig == null || toAppend == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UStringArray.checkRowLengths(orig);
        UStringArray.checkRowLengths(toAppend);
        if (orig.length != toAppend.length) {
            throw new IllegalArgumentException("Different number of rows (orig:" + orig.length + ", toAppend:" + toAppend.length + ").");
        }
        int origCols = orig[0].length;
        int toAppendCols = toAppend[0].length;
        String[][] newMat = new String[orig.length][origCols + toAppendCols];
        for (int i = 0; i < newMat.length; ++i) {
            System.arraycopy(orig[i], 0, newMat[i], 0, origCols);
            System.arraycopy(toAppend[i], 0, newMat[i], origCols, toAppendCols);
        }
        return newMat;
    }

    public static String[][] appendStringRows(String[][] orig, String[][] toAppend) {
        int i;
        if (orig == null || toAppend == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UStringArray.checkRowLengths(orig);
        UStringArray.checkRowLengths(toAppend);
        if (orig.length == 0) {
            return UStringArray.cloneStringArray(toAppend);
        }
        if (toAppend.length == 0) {
            return UStringArray.cloneStringArray(orig);
        }
        if (orig[0].length != toAppend[0].length) {
            throw new IllegalArgumentException("Different number of columns for appendStringRows (orig:" + orig[0].length + ", toAppend:" + toAppend[0].length + ").");
        }
        int origRows = orig.length;
        int toAppendRows = toAppend.length;
        String[][] newMat = new String[origRows + toAppendRows][];
        for (i = 0; i < origRows; ++i) {
            newMat[i] = (String[])orig[i].clone();
        }
        for (i = 0; i < toAppendRows; ++i) {
            newMat[origRows + i] = (String[])toAppend[i].clone();
        }
        return newMat;
    }

    public static String[][] appendSuffix(String[][] orig, String suffix) {
        if (orig == null || suffix == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UStringArray.checkRowLengths(orig);
        String[][] newMat = UStringArray.cloneStringArray(orig);
        for (int i = 0; i < newMat.length; ++i) {
            for (int j = 0; j < newMat[0].length; ++j) {
                newMat[i][j] = newMat[i][j] + suffix;
            }
        }
        return newMat;
    }

    public static String[] appendSuffix(String[] orig, String suffix) {
        if (orig == null || suffix == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        String[][] newMat = UStringArray.appendSuffix(UStringArray.toStringMatrix(orig), suffix);
        return UStringArray.getStringCol(newMat, 0);
    }

    public static void checkRowLengths(String[][] arg) {
        if (arg != null && arg.length > 0) {
            int n = arg[0].length;
            for (int i = 0; i < arg.length; ++i) {
                if (arg[i].length == n) continue;
                throw new IllegalArgumentException("Rows have different lengths.");
            }
        }
    }

    public static String[][] cloneStringArray(String[][] x) {
        if (x == null) {
            return null;
        }
        UStringArray.checkRowLengths(x);
        if (x.length == 0 || x[0].length == 0) {
            return new String[0][0];
        }
        String[][] y = (String[][])x.clone();
        for (int i = 0; i < x.length; ++i) {
            y[i] = (String[])x[i].clone();
        }
        return y;
    }

    public static boolean compareStringArrays(String[][] arg1, String[][] arg2) {
        if (arg1 == null || arg2 == null) {
            return false;
        }
        UStringArray.checkRowLengths(arg1);
        UStringArray.checkRowLengths(arg2);
        if (!(arg1.length != 0 && arg1[0].length != 0 || arg2.length != 0 && arg2[0].length != 0)) {
            return true;
        }
        if (arg1.length != arg2.length || arg1[0].length != arg2[0].length) {
            return false;
        }
        for (int i = 0; i < arg1.length; ++i) {
            for (int j = 0; j < arg1[0].length; ++j) {
                if (arg1[i][j] == null && arg2[i][j] == null || arg1[i][j] == null || arg1[i][j].equals(arg2[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public static String[] createNamedIndex(String name, double[] idx) {
        if (name == null || idx == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        String[] s = new String[idx.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = name + (int)idx[i];
        }
        return s;
    }

    public static String[][] delCol(String[][] arg, int colIndex) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UStringArray.checkRowLengths(arg);
        if (colIndex < 0 || arg[0].length <= colIndex) {
            throw new IllegalArgumentException("Bad column index: " + colIndex + ".");
        }
        if (arg[0].length - 1 == 0) {
            return new String[0][0];
        }
        String[][] newArray = new String[arg.length][arg[0].length - 1];
        for (int i = 0; i < arg.length; ++i) {
            int k = 0;
            for (int j = 0; j < arg[0].length; ++j) {
                if (j == colIndex) continue;
                newArray[i][k++] = arg[i][j];
            }
        }
        return newArray;
    }

    public static String[][] delif(String[][] arg, int[] index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new String[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UStringArray.checkRowLengths(arg);
        return UStringArray.selif(arg, UMatrix.flipIndex(index));
    }

    public static String[][] delRow(String[][] arg, int rowIndex) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UStringArray.checkRowLengths(arg);
        if (rowIndex < 0 || arg.length <= rowIndex) {
            throw new IllegalArgumentException("Bad row index: " + rowIndex + ".");
        }
        String[][] newSA = new String[arg.length - 1][];
        int j = 0;
        for (int i = 0; i < arg.length; ++i) {
            if (rowIndex == i) continue;
            newSA[j++] = (String[])arg[i].clone();
        }
        return newSA;
    }

    public static String[][] delRowsIf(String[][] arg, int[] index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new String[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UStringArray.checkRowLengths(arg);
        return UStringArray.selRowsIf(arg, UMatrix.flipIndex(index));
    }

    public static String[] delRowsIf(String[] arg, int[] rowIndex) {
        if (arg == null || rowIndex == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return UStringArray.selRowsIf(arg, UMatrix.flipIndex(rowIndex));
    }

    public static String[] getStringCol(String[][] arg, int colIndex) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UStringArray.checkRowLengths(arg);
        if (arg.length == 0) {
            throw new IllegalArgumentException("Argument has zero rows.");
        }
        if (colIndex < 0 || colIndex >= arg[0].length) {
            throw new IllegalArgumentException("Invalid index: " + colIndex + ".");
        }
        String[] result = new String[arg.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = arg[i][colIndex];
        }
        return result;
    }

    public static String[] getStringDiff(String[] arg1, String[] arg2) {
        if (arg1 == null || arg2 == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (arg1.length == 0 || arg2.length == 0) {
            return (String[])arg1.clone();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arg2.length; ++i) {
            list.add(arg2[i]);
        }
        String[][] ret = UStringArray.toStringMatrix(arg1);
        for (int i = 0; i < ret.length; ++i) {
            if (!list.contains(ret[i][0])) continue;
            ret = UStringArray.delRow(ret, i--);
        }
        if (ret.length == 0) {
            return new String[0];
        }
        return UStringArray.getStringCol(ret, 0);
    }

    public static String[][] getStringRows(String[][] arg, int startRow, int endRow) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UStringArray.checkRowLengths(arg);
        if (arg.length == 0) {
            throw new IllegalArgumentException("Argument has zero rows.");
        }
        if (startRow < 0 || startRow >= arg.length) {
            throw new IllegalArgumentException("Invalid start index: " + startRow + ".");
        }
        if (endRow < 0 || endRow >= arg.length) {
            throw new IllegalArgumentException("Invalid end index: " + endRow + ".");
        }
        if (endRow < startRow) {
            throw new IllegalArgumentException("Invalid indices [start:" + startRow + " > end:" + endRow + "].");
        }
        int r = endRow - startRow + 1;
        String[][] newMat = new String[r][];
        System.arraycopy(arg, startRow, newMat, 0, r);
        return newMat;
    }

    public static String[][] selif(String[][] arg, int[] index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new String[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UStringArray.checkRowLengths(arg);
        if (arg[0].length != index.length) {
            throw new IllegalArgumentException("Columns of array do not match with dimension of index (array: " + arg[0].length + ", index: " + index.length + ").");
        }
        int num = UMatrix.getNonzeroIntCount(index);
        if (num == 0) {
            return new String[0][0];
        }
        if (num == arg[0].length) {
            return UStringArray.cloneStringArray(arg);
        }
        String[][] ret = new String[arg.length][num];
        int k = 0;
        for (int i = 0; i < index.length; ++i) {
            if ((double)index[i] == 0.0) continue;
            for (int j = 0; j < ret.length; ++j) {
                ret[j][k] = arg[j][i];
            }
            ++k;
        }
        return ret;
    }

    public static String[][] selRowsIf(String[][] arg, int[] index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new String[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UStringArray.checkRowLengths(arg);
        if (arg.length != index.length) {
            throw new IllegalArgumentException("Rows of array do not match with dimension of index (array: " + arg.length + ", index: " + index.length + ").");
        }
        int num = UMatrix.getNonzeroIntCount(index);
        if (num == 0) {
            return new String[0][0];
        }
        if (num == arg.length) {
            return UStringArray.cloneStringArray(arg);
        }
        String[][] ret = new String[num][arg[0].length];
        int k = 0;
        for (int i = 0; i < index.length; ++i) {
            if ((double)index[i] == 0.0) continue;
            ret[k++] = (String[])arg[i].clone();
        }
        return ret;
    }

    public static String[] selRowsIf(String[] arg, int[] rowIndex) {
        if (arg == null || rowIndex == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (arg.length != rowIndex.length) {
            throw new IllegalArgumentException("Rows of array do not match with dimension of index (array: " + arg.length + ", index: " + rowIndex.length + ").");
        }
        int count = 0;
        for (int i = 0; i < rowIndex.length; ++i) {
            if (rowIndex[i] <= 0) continue;
            ++count;
        }
        if (count == 0) {
            return new String[0];
        }
        if (count == arg.length) {
            return (String[])arg.clone();
        }
        String[] ret = new String[count];
        int j = 0;
        for (int i = 0; i < arg.length; ++i) {
            if (rowIndex[i] == 0) continue;
            ret[j++] = arg[i];
        }
        return ret;
    }

    public static String[][] toStringMatrix(String[] arg) {
        if (arg == null) {
            return null;
        }
        if (arg.length == 0) {
            return new String[0][0];
        }
        String[][] m = new String[arg.length][1];
        for (int i = 0; i < arg.length; ++i) {
            m[i][0] = arg[i];
        }
        return m;
    }
}

