/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

import Jama.Matrix;
import com.jstatcom.util.PrintfFormat;
import java.util.Arrays;

public final class UMatrix {
    private UMatrix() {
    }

    public static double[][] add(double[][] arg, double toAdd) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        double[][] m = UMatrix.cloneDoubleArray(arg);
        for (int i = 0; i < m.length; ++i) {
            int j = 0;
            while (j < m[0].length) {
                double[] dArray = m[i];
                int n = j++;
                dArray[n] = dArray[n] + toAdd;
            }
        }
        return m;
    }

    public static double[][] appendDoubleCols(double[][] orig, double[][] toAppend) {
        if (orig == null || toAppend == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UMatrix.checkRowLengths(orig);
        UMatrix.checkRowLengths(toAppend);
        if (orig.length != toAppend.length) {
            throw new IllegalArgumentException("Different number of rows (orig:" + orig.length + ", toAppend:" + toAppend.length + ").");
        }
        int origCols = orig[0].length;
        int toAppendCols = toAppend[0].length;
        double[][] newMat = new double[orig.length][origCols + toAppendCols];
        for (int i = 0; i < newMat.length; ++i) {
            System.arraycopy(orig[i], 0, newMat[i], 0, origCols);
            System.arraycopy(toAppend[i], 0, newMat[i], origCols, toAppendCols);
        }
        return newMat;
    }

    public static double[][] appendDoubleRows(double[][] orig, double[][] toAppend) {
        double[] arr;
        int l;
        int i;
        if (orig == null || toAppend == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UMatrix.checkRowLengths(orig);
        UMatrix.checkRowLengths(toAppend);
        if (orig.length == 0) {
            return UMatrix.cloneDoubleArray(toAppend);
        }
        if (toAppend.length == 0) {
            return UMatrix.cloneDoubleArray(orig);
        }
        if (orig[0].length != toAppend[0].length) {
            throw new IllegalArgumentException("Different number of columns for appendDoubleRows (orig:" + orig[0].length + ", toAppend:" + toAppend[0].length + ").");
        }
        int origRows = orig.length;
        int toAppendRows = toAppend.length;
        double[][] newMat = new double[origRows + toAppendRows][];
        for (i = 0; i < origRows; ++i) {
            l = orig[i].length;
            arr = new double[l];
            System.arraycopy(orig[i], 0, arr, 0, l);
            newMat[i] = arr;
        }
        for (i = 0; i < toAppendRows; ++i) {
            l = toAppend[i].length;
            arr = new double[l];
            System.arraycopy(toAppend[i], 0, arr, 0, l);
            newMat[origRows + i] = arr;
        }
        return newMat;
    }

    public static void checkRowLengths(double[][] arg) {
        if (arg != null && arg.length > 0) {
            int n = arg[0].length;
            for (int i = 0; i < arg.length; ++i) {
                if (arg[i].length == n) continue;
                throw new IllegalArgumentException("Rows have different lengths.");
            }
        }
    }

    public static void checkRowLengths(int[][] arg) {
        if (arg != null && arg.length > 0) {
            int n = arg[0].length;
            for (int i = 0; i < arg.length; ++i) {
                if (arg[i].length == n) continue;
                throw new IllegalArgumentException("Rows have different lengths.");
            }
        }
    }

    public static double[][] cloneDoubleArray(double[][] x) {
        if (x == null) {
            return null;
        }
        if (x.length == 0 || x[0].length == 0) {
            return new double[0][0];
        }
        double[][] y = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            double[] x_i = x[i];
            int l = x_i.length;
            double[] arr = new double[x[i].length];
            System.arraycopy(x_i, 0, arr, 0, l);
            y[i] = arr;
        }
        return y;
    }

    public static int[][] cloneIntArray(int[][] x) {
        if (x == null) {
            return null;
        }
        if (x.length == 0 || x[0].length == 0) {
            return new int[0][0];
        }
        int[][] y = new int[x.length][];
        for (int i = 0; i < x.length; ++i) {
            int[] x_i = x[i];
            int l = x_i.length;
            int[] arr = new int[x[i].length];
            System.arraycopy(x_i, 0, arr, 0, l);
            y[i] = arr;
        }
        return y;
    }

    public static boolean compareDoubleArrays(double[][] arg1, double[][] arg2) {
        if (arg1 == null || arg2 == null) {
            return false;
        }
        UMatrix.checkRowLengths(arg1);
        UMatrix.checkRowLengths(arg2);
        if (!(arg1.length != 0 && arg1[0].length != 0 || arg2.length != 0 && arg2[0].length != 0)) {
            return true;
        }
        if (arg1.length != arg2.length || arg1[0].length != arg2[0].length) {
            return false;
        }
        for (int i = 0; i < arg1.length; ++i) {
            for (int j = 0; j < arg1[0].length; ++j) {
                if (Double.doubleToLongBits(arg1[i][j]) == Double.doubleToLongBits(arg2[i][j]) || arg1[i][j] == 0.0 && arg2[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean compareIntArrays(int[][] arg1, int[][] arg2) {
        if (arg1 == null || arg2 == null) {
            return false;
        }
        UMatrix.checkRowLengths(arg1);
        UMatrix.checkRowLengths(arg2);
        if (!(arg1.length != 0 && arg1[0].length != 0 || arg2.length != 0 && arg2[0].length != 0)) {
            return true;
        }
        if (arg1.length != arg2.length || arg1[0].length != arg2[0].length) {
            return false;
        }
        for (int i = 0; i < arg1.length; ++i) {
            for (int j = 0; j < arg1[0].length; ++j) {
                if (arg1[i][j] == arg2[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static double[][] delCol(double[][] arg, int colIndex) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UMatrix.checkRowLengths(arg);
        if (colIndex < 0 || arg[0].length <= colIndex) {
            throw new IllegalArgumentException("Bad column index: " + colIndex + ".");
        }
        if (arg[0].length - 1 == 0) {
            return new double[0][0];
        }
        double[][] newArray = new double[arg.length][arg[0].length - 1];
        for (int i = 0; i < arg.length; ++i) {
            int k = 0;
            for (int j = 0; j < arg[0].length; ++j) {
                if (j == colIndex) continue;
                newArray[i][k++] = arg[i][j];
            }
        }
        return newArray;
    }

    public static double[][] delColsIf(double[][] arg, int ... index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new double[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty but not index.");
        }
        UMatrix.checkRowLengths(arg);
        return UMatrix.selColsIf(arg, UMatrix.flipIndex(index));
    }

    public static double[][] delRow(double[][] arg, int rowIndex) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UMatrix.checkRowLengths(arg);
        if (rowIndex < 0 || arg.length <= rowIndex) {
            throw new IllegalArgumentException("Bad row index: " + rowIndex + ".");
        }
        if (arg.length - 1 == 0 || arg[0].length == 0) {
            return new double[0][0];
        }
        double[][] newArray = new double[arg.length - 1][];
        int k = 0;
        for (int i = 0; i < arg.length; ++i) {
            if (i == rowIndex) continue;
            double[] arg_i = arg[i];
            int l = arg_i.length;
            double[] arr = new double[l];
            System.arraycopy(arg_i, 0, arr, 0, l);
            newArray[k++] = arr;
        }
        return newArray;
    }

    public static double[][] delRowsIf(double[][] arg, int ... index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new double[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        UMatrix.checkRowLengths(arg);
        return UMatrix.selRowsIf(arg, UMatrix.flipIndex(index));
    }

    public static double[][] eye(int dim) {
        if (dim < 0) {
            throw new IllegalArgumentException("Dimension argument " + dim + " < 0.");
        }
        double[][] d = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            d[i][i] = 1.0;
        }
        return d;
    }

    public static int[] flipIndex(int ... arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        int[] reversed = new int[arg.length];
        for (int i = 0; i < arg.length; ++i) {
            if ((double)arg[i] != 0.0) continue;
            reversed[i] = 1;
        }
        return reversed;
    }

    public static String format(double[][] arg) {
        UMatrix.checkRowLengths(arg);
        StringBuffer buffer = new StringBuffer();
        buffer.append("rows: " + arg.length + "\n");
        if (arg.length > 0) {
            buffer.append("cols: " + arg[0].length + "\n");
        }
        for (int i = 0; i < arg.length; ++i) {
            for (int j = 0; j < arg[0].length; ++j) {
                buffer.append(new PrintfFormat("%- 13.4f").sprintf(arg[i][j]));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static double[] getDoubleCol(double[][] arg, int colIndex) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            throw new IllegalArgumentException("Argument has zero rows.");
        }
        if (colIndex < 0 || colIndex >= arg[0].length) {
            throw new IllegalArgumentException("Invalid index: " + colIndex + ".");
        }
        double[] result = new double[arg.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = arg[i][colIndex];
        }
        return result;
    }

    public static double[] getDoubleRow(double[][] arg, int rowIndex) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            throw new IllegalArgumentException("Argument has zero rows.");
        }
        if (rowIndex < 0 || rowIndex >= arg.length) {
            throw new IllegalArgumentException("Invalid index: " + rowIndex + ".");
        }
        double[] arg_i = arg[rowIndex];
        double[] result = new double[arg_i.length];
        System.arraycopy(arg_i, 0, result, 0, arg_i.length);
        return result;
    }

    public static double[][] getDoubleCols(double[][] arg, int startCol, int endCol) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            throw new IllegalArgumentException("Argument has zero rows.");
        }
        if (startCol < 0 || startCol >= arg[0].length) {
            throw new IllegalArgumentException("Invalid start index: " + startCol + ".");
        }
        if (endCol < 0 || endCol >= arg[0].length) {
            throw new IllegalArgumentException("Invalid end index: " + endCol + ".");
        }
        if (endCol < startCol) {
            throw new IllegalArgumentException("Invalid indices [start:" + startCol + " > end:" + endCol + "].");
        }
        int c = endCol - startCol + 1;
        double[][] newMat = new double[arg.length][c];
        for (int i = 0; i < newMat.length; ++i) {
            System.arraycopy(arg[i], startCol, newMat[i], 0, c);
        }
        return newMat;
    }

    public static double[][] getDoubleRows(double[][] arg, int startRow, int endRow) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            throw new IllegalArgumentException("Argument has zero rows.");
        }
        if (startRow < 0 || startRow >= arg.length) {
            throw new IllegalArgumentException("Invalid start index: " + startRow + ".");
        }
        if (endRow < 0 || endRow >= arg.length) {
            throw new IllegalArgumentException("Invalid end index: " + endRow + ".");
        }
        if (endRow < startRow) {
            throw new IllegalArgumentException("Invalid indices [start:" + startRow + " > end:" + endRow + "].");
        }
        int r = endRow - startRow + 1;
        double[][] newMat = new double[r][];
        System.arraycopy(arg, startRow, newMat, 0, r);
        return newMat;
    }

    public static int getFirstNonzeroIndex(double[] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] == 0.0) continue;
            return i;
        }
        return -1;
    }

    public static int getLastNonzeroIndex(double[] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        for (int i = arg.length - 1; i >= 0; --i) {
            if (arg[i] == 0.0) continue;
            return i;
        }
        return -1;
    }

    public static int getNonzeroDoubleCount(double[] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        int count = 0;
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] == 0.0) continue;
            ++count;
        }
        return count;
    }

    public static int getNonzeroIntCount(int[] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        int count = 0;
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] == 0) continue;
            ++count;
        }
        return count;
    }

    public static double[][] lowerTringular(double value, int dim) {
        if (dim < 0) {
            throw new IllegalArgumentException("Dimension argument " + dim + " < 0.");
        }
        double[][] triang = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j <= i; ++j) {
                triang[i][j] = value;
            }
        }
        return triang;
    }

    public static double[] maxc(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            return new double[0];
        }
        double[] m = new double[arg[0].length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = arg[0][i];
            for (int j = 0; j < arg.length; ++j) {
                if (!(arg[j][i] > m[i]) && !Double.isNaN(m[i])) continue;
                m[i] = arg[j][i];
            }
        }
        return m;
    }

    public static double[] meanc(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            return new double[0];
        }
        double[] m = UMatrix.sumc(arg);
        for (int i = 0; i < m.length; ++i) {
            m[i] = m[i] / (double)arg.length;
        }
        return m;
    }

    public static double[] minc(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            return new double[0];
        }
        double[] m = new double[arg[0].length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = arg[0][i];
            for (int j = 0; j < arg.length; ++j) {
                if (!(arg[j][i] < m[i]) && !Double.isNaN(m[i])) continue;
                m[i] = arg[j][i];
            }
        }
        return m;
    }

    public static double[][] multiply(double[][] arg, double toMult) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        double[][] m = UMatrix.cloneDoubleArray(arg);
        for (int i = 0; i < m.length; ++i) {
            int j = 0;
            while (j < m[0].length) {
                double[] dArray = m[i];
                int n = j++;
                dArray[n] = dArray[n] * toMult;
            }
        }
        return m;
    }

    public static double[][] missings(int r, int c) {
        if (r < 0 || c < 0) {
            throw new IllegalArgumentException("Invalid dimension " + r + ":" + c + " specified.");
        }
        if (r == 0 || c == 0) {
            return new double[0][0];
        }
        double[][] d = new double[r][c];
        for (int i = 0; i < r; ++i) {
            Arrays.fill(d[i], Double.NaN);
        }
        return d;
    }

    public static double[][] ones(int r, int c) {
        if (r < 0 || c < 0) {
            throw new IllegalArgumentException("Invalid dimension " + r + ":" + c + " specified.");
        }
        if (r == 0 || c == 0) {
            return new double[0][0];
        }
        double[][] d = new double[r][c];
        for (int i = 0; i < r; ++i) {
            Arrays.fill(d[i], 1.0);
        }
        return d;
    }

    public static double[][] pow(double[][] arg, double power) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        double[][] m = UMatrix.cloneDoubleArray(arg);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = Math.pow(m[i][j], power);
            }
        }
        return m;
    }

    public static int rank(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0 || arg[0].length == 0) {
            return 0;
        }
        return new Matrix(arg).rank();
    }

    public static double[][] rndu(int r, int c) {
        if (r < 0 || c < 0) {
            throw new IllegalArgumentException("Invalid dimension " + r + ":" + c + " specified.");
        }
        if (r == 0 || c == 0) {
            return new double[0][0];
        }
        double[][] d = new double[r][c];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[0].length; ++j) {
                d[i][j] = Math.random();
            }
        }
        return d;
    }

    public static double[][] selColsIf(double[][] arg, int ... index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new double[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty but index not.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg[0].length != index.length) {
            throw new IllegalArgumentException("Columns of array do not match with dimension of index (array: " + arg[0].length + ", index: " + index.length + ").");
        }
        int num = UMatrix.getNonzeroIntCount(index);
        if (num == 0) {
            return new double[0][0];
        }
        if (num == arg[0].length) {
            return UMatrix.cloneDoubleArray(arg);
        }
        double[][] ret = new double[arg.length][num];
        int k = 0;
        for (int i = 0; i < index.length; ++i) {
            if ((double)index[i] == 0.0) continue;
            for (int j = 0; j < ret.length; ++j) {
                ret[j][k] = arg[j][i];
            }
            ++k;
        }
        return ret;
    }

    public static double[][] selRowsIf(double[][] arg, int ... index) {
        if (arg == null || index == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (index.length == 0 && (arg.length == 0 || arg[0].length == 0)) {
            return new double[0][0];
        }
        if (arg.length == 0 || arg[0].length == 0) {
            throw new IllegalArgumentException("Argument was empty but index not.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length != index.length) {
            throw new IllegalArgumentException("Rows of array do not match with dimension of index (array: " + arg.length + ", index: " + index.length + ").");
        }
        int num = UMatrix.getNonzeroIntCount(index);
        if (num == 0) {
            return new double[0][0];
        }
        if (num == arg.length) {
            return UMatrix.cloneDoubleArray(arg);
        }
        double[][] ret = new double[num][arg[0].length];
        int k = 0;
        for (int i = 0; i < index.length; ++i) {
            if ((double)index[i] == 0.0) continue;
            double[] arg_i = arg[i];
            double[] arr = new double[arg_i.length];
            System.arraycopy(arg_i, 0, arr, 0, arg_i.length);
            ret[k++] = arr;
        }
        return ret;
    }

    public static double[] seqa(double start, double increment, int n) {
        if (start == Double.NEGATIVE_INFINITY || start == Double.POSITIVE_INFINITY || Double.isNaN(start)) {
            throw new IllegalArgumentException("Start argument: " + start + " invalid.");
        }
        if (increment == Double.NEGATIVE_INFINITY || increment == Double.POSITIVE_INFINITY || Double.isNaN(increment)) {
            throw new IllegalArgumentException("Increment argument: " + increment + " invalid.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Number argument " + n + " < 0.");
        }
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = start + (double)i * increment;
        }
        return d;
    }

    public static double[][] standardize(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            return new double[0][0];
        }
        double[] m = UMatrix.stdc(arg);
        double[][] std = UMatrix.cloneDoubleArray(arg);
        for (int i = 0; i < std.length; ++i) {
            for (int j = 0; j < std[0].length; ++j) {
                std[i][j] = std[i][j] / m[j];
            }
        }
        return std;
    }

    public static double[] stdc(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            return new double[0];
        }
        double[] m = UMatrix.meanc(arg);
        double[] std = new double[m.length];
        for (int i = 0; i < std.length; ++i) {
            for (int j = 0; j < arg.length; ++j) {
                int n = i;
                std[n] = std[n] + Math.pow(arg[j][i] - m[i], 2.0);
            }
            int n = i;
            std[n] = std[n] / (double)arg.length;
            std[i] = Math.pow(std[i], 0.5);
        }
        return std;
    }

    public static double[] sumc(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0) {
            return new double[0];
        }
        double[] m = new double[arg[0].length];
        for (int i = 0; i < arg[0].length; ++i) {
            for (int j = 0; j < arg.length; ++j) {
                int n = i;
                m[n] = m[n] + arg[j][i];
            }
        }
        return m;
    }

    public static double[][] toDoubleMatrix(int[][] arg) {
        if (arg == null) {
            return null;
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0 || arg[0].length == 0) {
            return new double[0][0];
        }
        double[][] m = new double[arg.length][arg[0].length];
        for (int i = 0; i < arg.length; ++i) {
            for (int j = 0; j < arg[0].length; ++j) {
                m[i][j] = arg[i][j];
            }
        }
        return m;
    }

    public static double[][] toDoubleMatrix(double[] arg) {
        if (arg == null) {
            return null;
        }
        if (arg.length == 0) {
            return new double[0][0];
        }
        double[][] m = new double[arg.length][1];
        for (int i = 0; i < arg.length; ++i) {
            m[i][0] = arg[i];
        }
        return m;
    }

    public static double[][] toDoubleMatrix(int[] arg) {
        if (arg == null) {
            return null;
        }
        if (arg.length == 0) {
            return new double[0][0];
        }
        double[][] m = new double[arg.length][1];
        for (int i = 0; i < arg.length; ++i) {
            m[i][0] = arg[i];
        }
        return m;
    }

    public static int[][] toIntMatrix(double[][] arg) {
        if (arg == null) {
            return null;
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0 || arg[0].length == 0) {
            return new int[0][0];
        }
        int[][] m = new int[arg.length][arg[0].length];
        for (int i = 0; i < arg.length; ++i) {
            for (int j = 0; j < arg[0].length; ++j) {
                m[i][j] = (int)arg[i][j];
            }
        }
        return m;
    }

    public static double[][] transpose(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0 || arg[0].length == 0) {
            return new double[0][0];
        }
        double[][] ret = new double[arg[0].length][arg.length];
        for (int i = 0; i < arg.length; ++i) {
            for (int j = 0; j < arg[0].length; ++j) {
                ret[j][i] = arg[i][j];
            }
        }
        return ret;
    }

    public static double[] vec(double[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0 || arg[0].length == 0) {
            return new double[0];
        }
        double[] res = new double[arg.length * arg[0].length];
        int k = 0;
        for (int j = 0; j < arg[0].length; ++j) {
            for (int i = 0; i < arg.length; ++i) {
                res[k++] = arg[i][j];
            }
        }
        return res;
    }

    public static int[] vec(int[][] arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        UMatrix.checkRowLengths(arg);
        if (arg.length == 0 || arg[0].length == 0) {
            return new int[0];
        }
        int[] res = new int[arg.length * arg[0].length];
        int k = 0;
        for (int j = 0; j < arg[0].length; ++j) {
            for (int i = 0; i < arg.length; ++i) {
                res[k++] = arg[i][j];
            }
        }
        return res;
    }

    public static double[] conv(double[] x, double[] z, int start, int end) {
        if (x == null || z == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        if (x.length == 0 || z.length == 0) {
            throw new IllegalArgumentException("Array argument contained zero elements.");
        }
        if (start < 0) {
            throw new IllegalArgumentException("Start index was < 0.");
        }
        if (start > end && end >= 0) {
            throw new IllegalArgumentException("Wrong index order: start > end.");
        }
        if (end > x.length + z.length - 2) {
            throw new IllegalArgumentException("End index [" + end + "] exceeds maximum [" + (x.length + z.length - 2) + "].");
        }
        end = end < 0 ? x.length + z.length - 2 : end;
        double[] conv = new double[end - start + 1];
        for (int i = start; i <= end; ++i) {
            for (int j = 0; j <= i; ++j) {
                double xx;
                xx = j < x.length ? (xx = x[j]) : 0.0;
                double zz = i - j < z.length ? z[i - j] : 0.0;
                int n = i - start;
                conv[n] = conv[n] + xx * zz;
            }
        }
        return conv;
    }

    public static double[] fracdiff(double[] y, double d) {
        int i;
        if (y == null) {
            throw new IllegalArgumentException("Array argument was null.");
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Differencing argument was NaN.");
        }
        int T = y.length;
        if (T == 0) {
            return new double[0];
        }
        double[] res = new double[T + 1];
        res[0] = 1.0;
        double[] trend = UMatrix.seqa(1.0, 1.0, T - 1);
        double[] mat1 = new double[trend.length];
        for (i = 0; i < mat1.length; ++i) {
            mat1[i] = (trend[i] - 1.0 - d) / trend[i];
        }
        res[1] = mat1[0];
        for (i = 1; i < T - 1; ++i) {
            res[i + 1] = res[i] * mat1[i];
        }
        double[] fDiff = UMatrix.conv(y, res, 0, T - 1);
        return fDiff;
    }
}

