/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

import com.jstatcom.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class SerializationHelper {
    public static byte[] getByteFromObject(Object o) {
        if (!(o instanceof Serializable)) {
            throw new IllegalArgumentException("Argument was not Serializable.");
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(o);
            out.close();
            return byteOut.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error setting  Object " + o + " to byte[].", e);
        }
    }

    public static <T> T getObjectFromByteArray(byte[] byteArray) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteArray);
        try {
            ObjectInputStream in = new ObjectInputStream(byteIn);
            Object rtn = in.readObject();
            in.close();
            return (T)rtn;
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving Object from byte[].", e);
        }
    }

    public static String encode(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Serializable)) {
            throw new IllegalArgumentException("Argument was not Serializable.");
        }
        String encGZDontBreakLines = Base64.encodeObject((Serializable)o, 10);
        return encGZDontBreakLines;
    }

    public static <T> T decode(String encodedString) {
        if (encodedString == null) {
            return null;
        }
        return (T)Base64.decodeToObject(encodedString);
    }
}

