/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

import com.jstatcom.parser.MaturityParser;
import com.jstatcom.util.MaturityUnits;
import java.io.Serializable;

public final class Maturity
implements Serializable {
    private static final MaturityParser maturityParser = new MaturityParser();
    public final int COUNT;
    public final MaturityUnits UNIT;
    private final int hashCode;

    public Maturity(int count, MaturityUnits unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Count < 0.");
        }
        this.COUNT = count;
        this.UNIT = unit;
        int result = 17;
        result = 37 * result + this.COUNT;
        this.hashCode = result = 37 * result + this.UNIT.hashCode();
    }

    public static Maturity valueOf(String toParse) {
        try {
            return maturityParser.parseString(toParse);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Could not parse \"" + toParse + "\" to maturity.");
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Maturity)) {
            return false;
        }
        Maturity otherMat = (Maturity)o;
        boolean ret = this.COUNT == otherMat.COUNT && this.UNIT == otherMat.UNIT;
        return ret;
    }

    public String toString() {
        return this.COUNT + " " + (Object)((Object)this.UNIT);
    }
}

