/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSHolder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public final class TSProject
implements PropertyChangeListener {
    private final List<String> tsList = new ArrayList<String>();
    private String projectDescription = "";
    private String name = "Default project";
    public static final TSProject DEFAULT_PROJECT = new TSProject("DEFAULT_PROJECT", "");

    public TSProject(String projectName) {
        this(projectName, null);
    }

    public TSProject(String projectName, String description) {
        this.name = projectName;
        this.setDescription(description);
    }

    public void addTS(TS ts) {
        if (!this.tsList.contains(ts.name())) {
            this.tsList.add(ts.name());
        }
    }

    public String getDescription() {
        return this.projectDescription;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof TSHolder && evt.getPropertyName() == "TS_REMOVED") {
            String tsName = evt.getNewValue().toString();
            this.removeTS(tsName);
        }
    }

    public void removeTS(String name) {
        if (this.tsList.contains(name)) {
            this.tsList.remove(name);
        }
    }

    public void setDescription(String newProjectDescription) {
        if (newProjectDescription == null || newProjectDescription.trim().length() == 0) {
            newProjectDescription = "";
        }
        this.projectDescription = newProjectDescription;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + "[name=" + this.name);
        for (int i = 0; i < this.tsList.size(); ++i) {
            buffer.append("," + this.tsList.get(i));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }
}

