/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSList;
import com.jstatcom.ts.TSTable;
import com.jstatcom.ts.TSTableModel;
import com.jstatcom.ts.TSTableScrollPane;
import com.jstatcom.util.UString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;

public final class TSEditDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(TSEditDialog.class);
    private int searchIndex = 0;
    private TSList tSList;
    private JPanel ivjJDialogContentPane = null;
    private JButton ivjCancel = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JPanel ivjJPanel1 = null;
    private JButton ivjOK = null;
    private TSTable ivjTSTable = null;
    private TSTableScrollPane ivjJScrollPane1 = null;
    private JPanel ivjJPanel2 = null;
    private JButton ivjSearchButton = null;
    private JTextField ivjSearchField = null;

    public TSEditDialog() {
        this.initialize();
    }

    public TSEditDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    private void cancel_ActionEvents() {
        this.setVisible(false);
    }

    private void connEtoC1() {
        try {
            this.oK_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.cancel_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.searchButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4() {
        try {
            this.searchButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCancel() {
        if (this.ivjCancel == null) {
            try {
                this.ivjCancel = new JButton();
                this.ivjCancel.setName("Cancel");
                this.ivjCancel.setPreferredSize(new Dimension(85, 27));
                this.ivjCancel.setText("Cancel");
                this.ivjCancel.setMinimumSize(new Dimension(80, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancel;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "South");
                this.getJDialogContentPane().add((Component)this.getJPanel2(), "North");
                this.getJDialogContentPane().add((Component)this.getTSTableScrollPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setPreferredSize(new Dimension(520, 50));
                this.ivjJPanel1.setLayout(this.getJPanel1FlowLayout());
                this.ivjJPanel1.setMinimumSize(new Dimension(520, 50));
                this.ivjJPanel1.setMaximumSize(new Dimension(520, 50));
                this.getJPanel1().add((Component)this.getOK(), this.getOK().getName());
                this.getJPanel1().add((Component)this.getCancel(), this.getCancel().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private FlowLayout getJPanel1FlowLayout() {
        FlowLayout ivjJPanel1FlowLayout = null;
        try {
            ivjJPanel1FlowLayout = new FlowLayout();
            ivjJPanel1FlowLayout.setVgap(10);
            ivjJPanel1FlowLayout.setHgap(50);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1FlowLayout;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setPreferredSize(new Dimension(200, 30));
                this.ivjJPanel2.setLayout(new GridBagLayout());
                GridBagConstraints constraintsSearchField = new GridBagConstraints();
                constraintsSearchField.gridx = 1;
                constraintsSearchField.gridy = 1;
                constraintsSearchField.fill = 2;
                constraintsSearchField.insets = new Insets(0, 5, 0, 0);
                this.getJPanel2().add((Component)this.getSearchField(), constraintsSearchField);
                GridBagConstraints constraintsSearchButton = new GridBagConstraints();
                constraintsSearchButton.gridx = 2;
                constraintsSearchButton.gridy = 1;
                constraintsSearchButton.anchor = 17;
                constraintsSearchButton.weightx = 1.0;
                constraintsSearchButton.insets = new Insets(0, 10, 0, 0);
                this.getJPanel2().add((Component)this.getSearchButton(), constraintsSearchButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private TSTableScrollPane getTSTableScrollPane() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new TSTableScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getTSTableScrollPane().setViewportView(this.getTSTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JButton getOK() {
        if (this.ivjOK == null) {
            try {
                this.ivjOK = new JButton();
                this.ivjOK.setName("OK");
                this.ivjOK.setPreferredSize(new Dimension(85, 27));
                this.ivjOK.setText("OK");
                this.ivjOK.setMaximumSize(new Dimension(80, 27));
                this.ivjOK.setMinimumSize(new Dimension(80, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOK;
    }

    private JButton getSearchButton() {
        if (this.ivjSearchButton == null) {
            try {
                this.ivjSearchButton = new JButton();
                this.ivjSearchButton.setName("SearchButton");
                this.ivjSearchButton.setToolTipText("Search for given number.");
                this.ivjSearchButton.setPreferredSize(new Dimension(100, 25));
                this.ivjSearchButton.setText("Find");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSearchButton;
    }

    private JTextField getSearchField() {
        if (this.ivjSearchField == null) {
            try {
                this.ivjSearchField = new JTextField();
                this.ivjSearchField.setName("SearchField");
                this.ivjSearchField.setPreferredSize(new Dimension(150, 20));
                this.ivjSearchField.setMinimumSize(new Dimension(100, 20));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSearchField;
    }

    private TSTable getTSTable() {
        if (this.ivjTSTable == null) {
            try {
                this.ivjTSTable = new TSTable();
                this.ivjTSTable.setName("TSTable");
                this.getTSTableScrollPane().setColumnHeaderView(this.ivjTSTable.getTableHeader());
                this.ivjTSTable.setBounds(0, 0, 472, 325);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTSTable;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getOK().addActionListener(this.ivjEventHandler);
        this.getCancel().addActionListener(this.ivjEventHandler);
        this.getSearchButton().addActionListener(this.ivjEventHandler);
        this.getSearchField().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("TSEditor");
            this.setDefaultCloseOperation(2);
            this.setSize(472, 425);
            this.setTitle("Edit Time Series");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void oK_ActionEvents() {
        TableCellEditor ed = this.getTSTable().getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        if (!this.getTSTable().isModelChanged()) {
            this.setVisible(false);
            return;
        }
        TS[] sel = this.getTSTable().getTS();
        int accept = JOptionPane.showConfirmDialog(TopFrameReference.getTopFrameRef(), "Do you want to save your changes?", "Question", 0);
        if (accept == 0) {
            for (int i = 0; i < sel.length; ++i) {
                TSHolder.getInstance().removeTS(sel[i].name());
                TSHolder.getInstance().addTS(sel[i]);
            }
        }
        this.setVisible(false);
    }

    private void searchButton_ActionEvents() {
        String text = this.getSearchField().getText().trim();
        if (text.length() == 0) {
            return;
        }
        Double searchVal = UString.parseToNumber(text);
        int start = this.searchIndex;
        TSTableModel tableModel = this.getTSTable().getModel();
        int[] matches = tableModel.findRowIndexOf(searchVal, this.searchIndex);
        if (start > 0 && matches[0] == -1) {
            matches = this.getTSTable().getModel().findRowIndexOf(searchVal, 0);
        }
        if (matches[0] == -1) {
            String msg = "Could not find \"" + text + "\".";
            msg = matches[1] > -1 ? msg + "\nThe closest match appeared at " + tableModel.getStartTSDate().addPeriods(matches[1]) + "." : msg;
            StdMessages.info(msg, "Not Found");
            this.searchIndex = 0;
        }
        if (matches[1] < 0) {
            return;
        }
        final int set = matches[1];
        this.getTSTableScrollPane().getVerticalScrollBar().setValue(new Double(this.getTSTable().getCellRect(set, 0, true).getY()).intValue());
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                TSEditDialog.this.getTSTable().setRowSelectionInterval(set, set);
            }
        };
        CompSettings.syncWithSwing(runner);
        this.getTSTable().repaint();
        this.searchIndex = matches[0] + 1;
    }

    public void setTSList(TSList newTimeSeriesList) {
        this.tSList = newTimeSeriesList;
        TS[] sel = this.tSList.getSelectedTS();
        this.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
        this.getTSTable().setTS(sel);
        this.searchIndex = 0;
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSEditDialog.this.getOK()) {
                TSEditDialog.this.connEtoC1();
            }
            if (e.getSource() == TSEditDialog.this.getCancel()) {
                TSEditDialog.this.connEtoC2();
            }
            if (e.getSource() == TSEditDialog.this.getSearchButton()) {
                TSEditDialog.this.connEtoC3();
            }
            if (e.getSource() == TSEditDialog.this.getSearchField()) {
                TSEditDialog.this.connEtoC4();
            }
        }
    }
}

