/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.IValTextField;
import com.jstatcom.component.MatrixBorder;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import org.apache.log4j.Logger;

public final class TSDateRangeSelector
extends IValTextField {
    private static final Logger log = Logger.getLogger(TSDateRangeSelector.class);
    private TSDateRange enclosingRange = null;
    private TSDateRange tSDateRange = null;
    private int minNumberOfObs = 1;

    public TSDateRangeSelector() {
        TSDate t1 = TSDate.valueOf("1960 q1");
        TSDate t2 = TSDate.valueOf("1982 q4");
        this.enclosingRange = new TSDateRange(t1, t2);
        this.setTSDateRange(this.enclosingRange);
        this.setBorder(MatrixBorder.getInstanceSmall());
        this.setSize(44, this.getHeight());
    }

    public TSDateRange getEnclosingRange() {
        return this.enclosingRange;
    }

    public int getMinNumberOfObs() {
        return this.minNumberOfObs;
    }

    public TSDateRange getTSDateRange() {
        return this.tSDateRange;
    }

    public int[] getTSDateRangeAsIndices() {
        return this.enclosingRange.indicesForRange(this.tSDateRange);
    }

    @Override
    public void handleError(String msg) {
        super.handleError(msg + "\nThe previous value " + this.tSDateRange + " is restored.");
        this.setTSDateRange(this.tSDateRange);
    }

    public void maxRange() {
        this.setTSDateRange(this.enclosingRange);
    }

    public void setEnclosingRange(TSDate newStart, int numberOfPeriods) {
        this.setEnclosingRange(new TSDateRange(newStart, newStart.addPeriods(numberOfPeriods - 1)));
    }

    public void setEnclosingRange(TSDateRange newOverallRange) {
        if (newOverallRange == null) {
            throw new IllegalArgumentException("Range cannot be null.");
        }
        this.enclosingRange = newOverallRange;
        if (this.enclosingRange.encloses(this.tSDateRange) != null) {
            TSDateRange newRange = this.enclosingRange.commonRange(this.tSDateRange);
            if (newRange != null) {
                this.setTSDateRange(newRange);
            } else {
                this.setTSDateRange(this.enclosingRange);
            }
        }
    }

    public void setMinNumberOfObs(int newMinNumberOfObs) {
        this.minNumberOfObs = newMinNumberOfObs;
        this.setTSDateRange(this.enclosingRange);
    }

    public void setTSDateRange(TSDateRange newTSDateRange) {
        if (newTSDateRange == null) {
            throw new IllegalArgumentException("Range is null.");
        }
        String msg = this.enclosingRange.encloses(newTSDateRange);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        TSDateRange oldDateRange = this.tSDateRange;
        this.tSDateRange = newTSDateRange;
        String formattedRange = this.tSDateRange.lowerBound() + ", " + this.tSDateRange.upperBound();
        this.setTextCarefully(formattedRange);
        if (oldDateRange != null && !oldDateRange.equals(this.tSDateRange)) {
            this.firePropertyChange("TSDateRange", oldDateRange, this.tSDateRange);
        }
    }

    @Override
    public String validateInput() {
        TSDateRange tmpRange = null;
        String inputString = this.getText().trim();
        int kommaIndex = inputString.indexOf(",");
        if (kommaIndex < 1 || kommaIndex > inputString.length() - 2) {
            return "Input \"" + inputString + "\" is not a valid date range.";
        }
        String t1String = inputString.substring(0, kommaIndex);
        String t2String = inputString.substring(kommaIndex + 1, inputString.length());
        try {
            TSDate t1 = TSDate.valueOf(t1String);
            TSDate t2 = TSDate.valueOf(t2String);
            tmpRange = new TSDateRange(t1, t2);
        }
        catch (Throwable ex) {
            String msg = "Input \"" + inputString + "\" is not a valid date range.";
            log.warn((Object)msg, ex);
            return msg;
        }
        String error = this.enclosingRange.encloses(tmpRange);
        if (error == null && this.minNumberOfObs > 0) {
            int maxMin = this.enclosingRange.numOfObs();
            int currentMin = this.minNumberOfObs > maxMin ? maxMin : this.minNumberOfObs;
            int num = tmpRange.numOfObs();
            if (num < currentMin) {
                String plural = num == 1 ? "observation" : "observations";
                return tmpRange + " contains only " + num + " " + plural + ".\nThis is less than the required minimum of " + currentMin + ".";
            }
        }
        if (error == null) {
            this.setTSDateRange(tmpRange);
        }
        return error;
    }
}

