/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.parser.TSDateParser;
import com.jstatcom.util.DateDiff;
import com.jstatcom.util.UMath;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public final class TSDate
implements Comparable {
    private static final DateFormat dateFormatUS = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
    private static final DateFormat dailyFormat = new SimpleDateFormat("MM/dd/yyyy, EEE", Locale.US);
    private static final DateFormat dailyFormatShort = new SimpleDateFormat("M/d/yy", Locale.US);
    private static final Date START = new Date(342000000L);
    private static final long WEEK_MILLIS = 604800000L;
    private static final long DAY_MILLIS = 86400000L;
    private Date date = null;
    private static final Calendar calendar = new GregorianCalendar();
    private final int mainPeriod;
    private final int subPeriod;
    private final int subPeriodicity;
    private final int subPeriodFormat;

    public TSDate() {
        this(1, 1, 1);
    }

    public TSDate(double newDate, int newSubPeriodicity) {
        int newSubPeriodFormat = this.parseSubPeriodFormat(newSubPeriodicity);
        int[] i = this.parseDate(newDate, newSubPeriodFormat);
        int newMainPeriod = i[0];
        int newSubPeriod = new Long(i[1]).intValue();
        if (newSubPeriodicity < 1) {
            throw new IllegalArgumentException("Illegal sub periodicity (" + newSubPeriodicity + " < 1).");
        }
        if (newSubPeriod < 1) {
            throw new IllegalArgumentException("Illegal sub period (" + newSubPeriod + " < 1).");
        }
        if (newSubPeriodicity < newSubPeriod) {
            throw new IllegalArgumentException("Sub period > sub periodicity (" + newSubPeriod + " > " + newSubPeriodicity + ").");
        }
        this.mainPeriod = newMainPeriod;
        this.subPeriod = newSubPeriod;
        this.subPeriodicity = newSubPeriodicity;
        this.subPeriodFormat = newSubPeriodFormat;
    }

    public TSDate(int mainPeriod, int subPeriod, int subPeriodicity) {
        if (subPeriodicity < 1) {
            throw new IllegalArgumentException("Illegal sub periodicity (" + subPeriodicity + " < 1).");
        }
        if (subPeriod < 1) {
            throw new IllegalArgumentException("Illegal sub period (" + subPeriod + " < 1).");
        }
        if (subPeriodicity < subPeriod) {
            throw new IllegalArgumentException("Sub period > sub periodicity (" + subPeriod + " > " + subPeriodicity + ").");
        }
        this.mainPeriod = mainPeriod;
        this.subPeriod = subPeriod;
        this.subPeriodicity = subPeriodicity;
        this.subPeriodFormat = this.parseSubPeriodFormat(subPeriodicity);
    }

    public TSDate addPeriods(int n) {
        if (n == 0) {
            return this;
        }
        int newSubPeriod = this.subPeriodFor(n);
        int newMainPeriod = 0;
        if (n > 0) {
            newMainPeriod = this.mainPeriod + n / this.subPeriodicity;
            if (newSubPeriod < this.subPeriod) {
                ++newMainPeriod;
            }
        } else {
            n = Math.abs(n);
            newMainPeriod = this.mainPeriod - n / this.subPeriodicity;
            if (newSubPeriod > this.subPeriod) {
                --newMainPeriod;
            }
        }
        return new TSDate(newMainPeriod, newSubPeriod, this.subPeriodicity);
    }

    public int compareTo(Object o) {
        TSDate otherDate = (TSDate)o;
        if (this.subPeriodicity != otherDate.subPeriodicity()) {
            throw new IllegalArgumentException("Sub periodicities do not match between " + this + " and " + o + ".");
        }
        if (this.equals(otherDate)) {
            return 0;
        }
        long result = (otherDate.mainPeriod() - this.mainPeriod) * this.subPeriodicity + otherDate.subPeriod() - this.subPeriod;
        if (result > Integer.MAX_VALUE) {
            throw new IllegalStateException("Integer.MAX_VALUE overflow.");
        }
        if (result < Integer.MIN_VALUE) {
            throw new IllegalStateException("Integer.MIN_VALUE overflow.");
        }
        return (int)result;
    }

    public double doubleValue() {
        if (this.subPeriodicity > 1) {
            return (double)this.mainPeriod + (double)(this.mainPeriod >= 0 ? 1 : -1) * (double)this.subPeriod / (double)this.parseSubPeriodFormat(this.subPeriodicity);
        }
        return this.mainPeriod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSDate)) {
            return false;
        }
        TSDate otherDate = (TSDate)o;
        boolean ret = this.mainPeriod == otherDate.mainPeriod() && this.subPeriod == otherDate.subPeriod() && this.subPeriodicity == otherDate.subPeriodicity();
        return ret;
    }

    public int mainPeriod() {
        return this.mainPeriod;
    }

    public int subPeriod() {
        return this.subPeriod;
    }

    public int subPeriodFor(int n) {
        if (n == 0) {
            return this.subPeriod;
        }
        int newSubPeriod = 1;
        if (n > 0) {
            int allSubPeriods = this.subPeriod + n;
            newSubPeriod = allSubPeriods % this.subPeriodicity;
            if (newSubPeriod == 0) {
                newSubPeriod = this.subPeriodicity;
            }
        } else {
            int diff = this.subPeriod - (n = Math.abs(n)) % this.subPeriodicity;
            newSubPeriod = diff >= 0 ? diff : this.subPeriodicity - Math.abs(diff);
            if (newSubPeriod == 0) {
                newSubPeriod = this.subPeriodicity;
            }
        }
        return newSubPeriod;
    }

    public int subPeriodFormat() {
        return this.subPeriodFormat;
    }

    public int subPeriodicity() {
        return this.subPeriodicity;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.mainPeriod;
        result = 37 * result + this.subPeriod;
        result = 37 * result + this.subPeriodicity;
        return result;
    }

    private int[] parseDate(double arg, int subPeriodFormat) {
        int[] i;
        i = new int[]{(int)arg, Math.rint(arg) - arg == 0.0 ? 1 : (int)Math.abs(Math.rint((arg - (double)i[0]) * (double)subPeriodFormat))};
        return i;
    }

    private int parseSubPeriodFormat(int subPeriodicity) {
        double[] d = UMath.base10(subPeriodicity);
        return (int)Math.pow(10.0, d[1] + 1.0);
    }

    public String printNice() {
        if (this.subPeriodicity == 5 || this.subPeriodicity == 7) {
            return dailyFormat.format(this.getDate());
        }
        return this.toString();
    }

    public String printShort() {
        StringBuffer s = new StringBuffer();
        if (this.subPeriodicity == 5 || this.subPeriodicity == 7) {
            s.append(dailyFormatShort.format(this.getDate()));
        } else {
            s.append(this.mainPeriod);
            switch (this.subPeriodicity) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.subPeriod == 1) {
                        s.append("I");
                        break;
                    }
                    s.append("II");
                    break;
                }
                case 4: {
                    s.append("Q");
                    s.append(this.subPeriod);
                    break;
                }
                case 12: {
                    s.append("M");
                    s.append(this.subPeriod);
                    break;
                }
                default: {
                    s.append(" ");
                    s.append(this.subPeriod);
                    s.append("/");
                    s.append(this.subPeriodicity);
                }
            }
        }
        return s.toString();
    }

    public String[] timeAxisStringArray(int t) {
        if (t < 1) {
            throw new IllegalArgumentException("t < 1 for axis creation of " + this + ".");
        }
        String[] timeAxis = new String[t];
        for (int i = 0; i < t; ++i) {
            timeAxis[i] = this.addPeriods(i).printNice();
        }
        return timeAxis;
    }

    public Date getDate() {
        if (this.date == null) {
            if (this.subPeriodicity == 7 || this.subPeriodicity == 5) {
                calendar.setTime(START);
                calendar.add(3, this.mainPeriod);
                calendar.add(7, this.subPeriod - 1);
                this.date = calendar.getTime();
            } else {
                throw new IllegalStateException("Conversion to java.util.Date is not implemented for this frequency.");
            }
        }
        return (Date)this.date.clone();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.subPeriodicity == 5 || this.subPeriodicity == 7) {
            s.append(dateFormatUS.format(this.getDate()) + " (" + this.subPeriodicity + ")");
        } else {
            s.append(this.mainPeriod);
            switch (this.subPeriodicity) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.subPeriod == 1) {
                        s.append(" I");
                        break;
                    }
                    s.append(" II");
                    break;
                }
                case 4: {
                    s.append(" Q");
                    s.append(this.subPeriod);
                    break;
                }
                case 12: {
                    s.append(" M");
                    s.append(this.subPeriod);
                    break;
                }
                default: {
                    s.append(" ");
                    s.append(this.subPeriod);
                    s.append("/");
                    s.append(this.subPeriodicity);
                }
            }
        }
        return s.toString();
    }

    public static TSDate valueOf(String exp) {
        TSDate tsDate = null;
        if (exp == null) {
            throw new IllegalArgumentException("TSDate construction from null argument failed.");
        }
        tsDate = TSDate.parseDailyData(exp);
        if (tsDate != null) {
            return tsDate;
        }
        try {
            tsDate = new TSDateParser().parseString(exp, -1);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("TSDate construction from \"" + exp + "\" failed.\n" + ex);
        }
        return tsDate;
    }

    private static TSDate parseDailyData(String exp) {
        String orig = exp;
        exp = exp.trim();
        String ending = "";
        int index = exp.indexOf("(");
        if (index == -1) {
            return null;
        }
        ending = exp.substring(index);
        if (ending.endsWith(")")) {
            ending = ending.substring(1, ending.length() - 1);
            ending = ending.trim();
            exp = exp.substring(0, index);
            Date parseDate = null;
            try {
                parseDate = dateFormatUS.parse(exp);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("TSDate construction from \"" + orig + "\" failed.\n" + ex);
            }
            if (ending.equals("5") || ending.equals("7")) {
                calendar.setTime(parseDate);
                int day = calendar.get(7) - 1;
                if (day == 0) {
                    day = 7;
                }
                int periodicity = 7;
                if (ending.equals("5")) {
                    periodicity = 5;
                    day = calendar.get(7);
                    if (day == 7) {
                        parseDate.setTime(parseDate.getTime() + 172800000L);
                        day = 1;
                    } else if (day == 1) {
                        parseDate.setTime(parseDate.getTime() + 86400000L);
                        day = 1;
                    } else {
                        --day;
                    }
                }
                double num = ((double)parseDate.getTime() - (double)START.getTime()) / 6.048E8;
                int main = DateDiff.getDateDiff(3, START, parseDate);
                if (num < 0.0 && day > 1) {
                    --main;
                }
                int subperiod = day;
                TSDate tsDate = new TSDate(main, subperiod, periodicity);
                tsDate.date = parseDate;
                return tsDate;
            }
            throw new IllegalArgumentException("TSDate construction from \"" + orig + "\" argument failed.\nIllegal number of weekdays.");
        }
        throw new IllegalArgumentException("TSDate construction from \"" + orig + "\" argument failed.\nThere was an unclosed \"(\".");
    }
}

