/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.DataHandlerTypes;
import com.jstatcom.io.FileSupport;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDescDialog;
import com.jstatcom.ts.TSDummyDialog;
import com.jstatcom.ts.TSEditDialog;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSList;
import com.jstatcom.ts.TSListAccessor;
import com.jstatcom.ts.TSProject;
import com.jstatcom.ts.TSTransDialog;
import com.jstatcom.ts.TSTypes;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public abstract class TSActionTypes
extends AbstractAction
implements TSListAccessor {
    private static final Logger log = Logger.getLogger(TSActionTypes.class);
    private final String name;
    private TSList tSList = null;
    public static final TSActionTypes DELETE = new TSActionTypes("Delete"){

        @Override
        public void doAction(TSList tsList) {
            TS[] selection = tsList.getSelectedTS();
            if (selection.length == 1) {
                String name = selection[0].name();
                if (0 == JOptionPane.showConfirmDialog(TopFrameReference.getTopFrameRef(), "Really delete variable \"" + name + "\"?", "Delete", 0, 3)) {
                    TSHolder.getInstance().removeTS(name);
                }
            }
            if (selection.length > 1 && 0 == JOptionPane.showConfirmDialog(TopFrameReference.getTopFrameRef(), "Really delete selected variables?", "Delete", 0, 3)) {
                for (int j = 0; j < selection.length; ++j) {
                    TSHolder.getInstance().removeTS(selection[j].name());
                }
            }
        }
    };
    public static final TSActionTypes RENAME = new TSActionTypes("Rename"){

        @Override
        public void doAction(TSList tsList) {
            TS[] selection = tsList.getSelectedTS();
            if (selection.length > 0) {
                TS ts = selection[0];
                String name = ts.name();
                Object obj = JOptionPane.showInputDialog(TopFrameReference.getTopFrameRef(), "Enter new name for \"" + name + "\"", "Rename", -1, null, null, name);
                if (obj == null) {
                    return;
                }
                String newName = obj.toString().trim();
                String error = JSCConstants.isValidName(newName);
                if (error != null) {
                    StdMessages.errorInput(error);
                    return;
                }
                if (!newName.toString().equals(name)) {
                    if (TSHolder.getInstance().contains(newName) && !newName.toString().equalsIgnoreCase(name)) {
                        StdMessages.errorInput("Variable \"" + newName + "\" already exists.\nPlease choose a different name.");
                        return;
                    }
                    TSHolder.getInstance().removeTS(name);
                    ts.setName(newName);
                    TSHolder.getInstance().addTS(ts);
                }
            }
        }
    };
    public static final TSActionTypes TRANSFORM = new TSActionTypes("Transform"){
        private TSTransDialog transDialog = null;

        @Override
        public void doAction(TSList tsList) {
            if (this.transDialog == null) {
                this.transDialog = new TSTransDialog((Frame)TopFrameReference.getTopFrameRef(), true);
            }
            this.transDialog.setTSList(tsList);
            this.transDialog.setVisible(true);
        }
    };
    public static final TSActionTypes CREATE_DUMMY = new TSActionTypes("Create Dummy"){
        private TSDummyDialog dummyDialog = null;

        @Override
        public void doAction(TSList tsList) {
            if (this.dummyDialog == null) {
                this.dummyDialog = new TSDummyDialog(TopFrameReference.getTopFrameRef(), true);
            }
            this.dummyDialog.setTSList(tsList);
            this.dummyDialog.setVisible(true);
        }
    };
    public static final TSActionTypes SHOW_DESCRIPTION = new TSActionTypes("Show Description"){

        @Override
        public void doAction(TSList tsList) {
            TS[] selection = tsList.getSelectedTS();
            if (selection.length > 0) {
                ArrayList<TSProject> list = new ArrayList<TSProject>();
                for (int i = 0; i < selection.length; ++i) {
                    TSProject proj = selection[i].project();
                    if (list.contains(proj)) continue;
                    list.add(proj);
                }
                StringBuffer des = new StringBuffer();
                String marker = "\n------------------------------------\n";
                for (TSProject proj : list) {
                    des.append(proj.getDescription().trim() + marker);
                }
                des.delete(des.length() - marker.length(), des.length());
                JOptionPane.showMessageDialog(TopFrameReference.getTopFrameRef(), des.toString(), "Project Description", 1);
                return;
            }
        }
    };
    public static final TSActionTypes SAVE_DAT = new TSActionTypes("Save Data to File"){
        private TSDescDialog descDialog = null;

        @Override
        public void doAction(TSList tsList) {
            if (this.descDialog == null) {
                this.descDialog = new TSDescDialog((Frame)TopFrameReference.getTopFrameRef(), true);
            }
            this.descDialog.setTSList(tsList);
            this.descDialog.setVisible(true);
            if (this.descDialog.isCanceled()) {
                return;
            }
            File file = FileSupport.getInstance().saveDataFile(TopFrameReference.getTopFrameRef(), null, DataHandlerTypes.EXCEL, DataHandlerTypes.MATLAB, DataHandlerTypes.GAUSS_DAT, DataHandlerTypes.GAUSS_FMT, DataHandlerTypes.DAT);
            if (file == null) {
                return;
            }
            DataHandlerTypes handlerType = FileSupport.getInstance().getSelectedSaveHandlerType();
            try {
                handlerType.getHandler().exportTS(file, tsList.getSelectedTS(), this.descDialog.getDescription());
            }
            catch (Throwable ex) {
                String msg = "Error exporting data to file \"" + file.getAbsolutePath() + "\".";
                String message = msg + "\n" + ex.getMessage();
                log.error((Object)msg, ex);
                StdMessages.error(message, "Data Export Error");
            }
        }
    };
    public static final TSActionTypes EDIT_TS = new TSActionTypes("Edit Time Series"){
        private TSEditDialog editDialog = null;

        @Override
        public void doAction(TSList tsList) {
            if (this.editDialog == null) {
                this.editDialog = new TSEditDialog((Frame)TopFrameReference.getTopFrameRef(), false);
            }
            this.editDialog.setTSList(tsList);
            this.editDialog.setVisible(true);
        }
    };
    public static final TSActionTypes ENDOGENOUS = new TSActionTypes("Endogenous"){

        @Override
        public void doAction(TSList tsList) {
            TS[] sel = tsList.getSelectedTS();
            for (int i = 0; i < sel.length; ++i) {
                sel[i].setTSType(TSTypes.ENDOGENOUS);
            }
        }
    };
    public static final TSActionTypes EXOGENOUS = new TSActionTypes("Exogenous"){

        @Override
        public void doAction(TSList tsList) {
            TS[] sel = tsList.getSelectedTS();
            for (int i = 0; i < sel.length; ++i) {
                sel[i].setTSType(TSTypes.EXOGENOUS);
            }
        }
    };
    public static final TSActionTypes DETERMINISTIC = new TSActionTypes("Deterministic"){

        @Override
        public void doAction(TSList tsList) {
            TS[] sel = tsList.getSelectedTS();
            for (int i = 0; i < sel.length; ++i) {
                sel[i].setTSType(TSTypes.DETERMINISTIC);
            }
        }
    };

    protected TSActionTypes(String name) {
        this(name, null);
    }

    protected TSActionTypes(String name, Icon icon) {
        super(name, icon);
        this.name = name;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.doAction(this.tSList);
    }

    public abstract void doAction(TSList var1);

    @Override
    public void enableForTSList(TSList tsList) {
        this.setEnabled(tsList.getSelectedIndices().length != 0);
        this.tSList = tsList;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        return this.name;
    }
}

