/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.table.JSCAbstractTableModel;

public class JSCSArrayTableModel
extends JSCAbstractTableModel {
    private boolean transposed = false;

    public JSCSArrayTableModel(Symbol symbol) {
        super(symbol);
        if (symbol != null && symbol.type != JSCTypes.SARRAY) {
            throw new IllegalArgumentException("Symbol type " + symbol.type + " different from table type " + JSCTypes.SARRAY + ".");
        }
    }

    @Override
    public int getColumnCount() {
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            return 0;
        }
        if (this.isTransposed()) {
            return this.getCurrentSymbol().getJSCSArray().rows();
        }
        return this.getCurrentSymbol().getJSCSArray().cols();
    }

    @Override
    public int getRowCount() {
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            return 0;
        }
        if (this.isTransposed()) {
            return this.getCurrentSymbol().getJSCSArray().cols();
        }
        return this.getCurrentSymbol().getJSCSArray().rows();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            return null;
        }
        if (this.isTransposed()) {
            return this.getCurrentSymbol().getJSCSArray().stringAt(columnIndex, rowIndex);
        }
        return this.getCurrentSymbol().getJSCSArray().stringAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            throw new IllegalArgumentException("Value at [" + rowIndex + ":" + columnIndex + "] is null.");
        }
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            throw new IllegalStateException("Symbol is empty or null.");
        }
        if (this.isTransposed()) {
            this.getCurrentSymbol().getJSCSArray().setValAt(aValue.toString(), columnIndex, rowIndex);
        } else {
            this.getCurrentSymbol().getJSCSArray().setValAt(aValue.toString(), rowIndex, columnIndex);
        }
    }

    public final boolean isTransposed() {
        return this.transposed;
    }

    public final void setTransposed(boolean isTransposed) {
        this.transposed = isTransposed;
        this.fireTableStructureChanged();
    }
}

