/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.table.JSCAbstractTableModel;

public class JSCNArrayTableModel
extends JSCAbstractTableModel {
    public JSCNArrayTableModel(Symbol symbol) {
        super(symbol);
        if (symbol != null && symbol.type != JSCTypes.NARRAY) {
            throw new IllegalArgumentException("Symbol type " + symbol.type + " different from table type " + JSCTypes.NARRAY + ".");
        }
    }

    @Override
    public int getColumnCount() {
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            return 0;
        }
        return this.getCurrentSymbol().getJSCNArray().cols();
    }

    @Override
    public int getRowCount() {
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            return 0;
        }
        return this.getCurrentSymbol().getJSCNArray().rows();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            return null;
        }
        return new Double(this.getCurrentSymbol().getJSCNArray().doubleAt(rowIndex, columnIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!(aValue instanceof Double)) {
            throw new IllegalArgumentException("Value at [" + rowIndex + ":" + columnIndex + "] is not a Double.");
        }
        if (this.getCurrentSymbol() == null || this.getCurrentSymbol().isEmpty()) {
            throw new IllegalStateException("Symbol is empty or null.");
        }
        this.getCurrentSymbol().getJSCNArray().setValAt((Double)aValue, rowIndex, columnIndex);
    }

    public Class<Double> getColumnClass(int columnIndex) {
        return Double.class;
    }
}

