/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.equation.CoeffTable;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.table.JSCAbstractDataTable;
import com.jstatcom.table.JSCNArrayTable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

public abstract class JSCMouseListenerTypes
implements MouseListener {
    private final String name;
    public static final JSCMouseListenerTypes SUBSET_01 = new JSCMouseListenerTypes("SUBSET_01"){

        @Override
        public void clicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
            if (table instanceof JSCNArrayTable && this.isSubsetRes((JSCNArrayTable)table, row, col)) {
                return;
            }
            if (data instanceof JSCNArray) {
                JSCNArray narray = (JSCNArray)data;
                int oldValue = narray.intAt(row, col);
                double newValue = 0.0;
                if (oldValue == 0) {
                    newValue = 1.0;
                }
                narray.setValAt(newValue, row, col);
            }
        }

        @Override
        public void doubleClicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
        }
    };
    public static final JSCMouseListenerTypes SUBSET_012 = new JSCMouseListenerTypes("SUBSET_012"){

        @Override
        public void clicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
            if (table instanceof JSCNArrayTable && this.isSubsetRes((JSCNArrayTable)table, row, col)) {
                return;
            }
            if (data instanceof JSCNArray) {
                JSCNArray narray = (JSCNArray)data;
                int oldValue = narray.intAt(row, col);
                double newValue = 0.0;
                if (oldValue == 0) {
                    newValue = 2.0;
                } else if (oldValue == 2) {
                    newValue = 1.0;
                }
                narray.setValAt(newValue, row, col);
            }
        }

        @Override
        public void doubleClicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
        }
    };
    public static final JSCMouseListenerTypes SUBSET_01M1 = new JSCMouseListenerTypes("SUBSET_01M1"){

        @Override
        public void clicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
            if (data instanceof JSCNArray) {
                JSCNArray narray = (JSCNArray)data;
                int oldValue = narray.intAt(row, col);
                double newValue = 0.0;
                if (oldValue == 0) {
                    newValue = 1.0;
                } else if (oldValue == 1) {
                    newValue = -1.0;
                }
                narray.setValAt(newValue, row, col);
            }
        }

        @Override
        public void doubleClicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
        }
    };
    public static final JSCMouseListenerTypes DIAGONAL_01 = new JSCMouseListenerTypes("DIAGONAL_01"){

        @Override
        public void clicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
            if (row == col) {
                return;
            }
            if (table instanceof JSCNArrayTable && this.isSubsetRes((JSCNArrayTable)table, row, col)) {
                return;
            }
            if (data instanceof JSCNArray) {
                JSCNArray narray = (JSCNArray)data;
                int oldValue = narray.intAt(row, col);
                double newValue = 0.0;
                if (oldValue == 0) {
                    newValue = 1.0;
                }
                narray.setValAt(newValue, row, col);
            }
        }

        @Override
        public void doubleClicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
        }
    };
    public static final JSCMouseListenerTypes DIAG_01NEGINF = new JSCMouseListenerTypes("DIAG_01NEGINF"){

        @Override
        public void clicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
            if (row == col) {
                return;
            }
            if (data instanceof JSCNArray) {
                JSCNArray narray = (JSCNArray)data;
                double oldValue = narray.doubleAt(row, col);
                double newValue = 0.0;
                if (oldValue == 0.0) {
                    newValue = 1.0;
                } else if (oldValue == 1.0) {
                    newValue = Double.NEGATIVE_INFINITY;
                }
                narray.setValAt(newValue, row, col);
            }
        }

        @Override
        public void doubleClicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
        }
    };
    public static final JSCMouseListenerTypes SUBSET_0NEGINF = new JSCMouseListenerTypes("SUBSET_0NEGINF"){

        @Override
        public void clicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
            if (data instanceof JSCNArray) {
                JSCNArray narray = (JSCNArray)data;
                double oldValue = narray.doubleAt(row, col);
                double newValue = 0.0;
                if (oldValue == 0.0) {
                    newValue = Double.NEGATIVE_INFINITY;
                }
                narray.setValAt(newValue, row, col);
            }
        }

        @Override
        public void doubleClicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
        }
    };
    public static final JSCMouseListenerTypes DIAG_0NEGINF = new JSCMouseListenerTypes("DIAG_0NEGINF"){

        @Override
        public void clicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
            if (row == col) {
                return;
            }
            if (data instanceof JSCNArray) {
                JSCNArray narray = (JSCNArray)data;
                double oldValue = narray.doubleAt(row, col);
                double newValue = 0.0;
                if (oldValue == 0.0) {
                    newValue = Double.NEGATIVE_INFINITY;
                }
                narray.setValAt(newValue, row, col);
            }
        }

        @Override
        public void doubleClicked(JSCAbstractDataTable table, JSCData data, int row, int col) {
        }
    };

    protected JSCMouseListenerTypes(String name) {
        this.name = name;
    }

    public abstract void clicked(JSCAbstractDataTable var1, JSCData var2, int var3, int var4);

    public abstract void doubleClicked(JSCAbstractDataTable var1, JSCData var2, int var3, int var4);

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final String getName() {
        return this.name;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private void invokeAbstractMethod(MouseEvent e, boolean isDoubleClick) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        Component comp = e.getComponent();
        if (!comp.isEnabled()) {
            return;
        }
        if (!(comp instanceof JSCAbstractDataTable)) {
            throw new RuntimeException("Wrong component.");
        }
        JSCAbstractDataTable table = (JSCAbstractDataTable)e.getComponent();
        int r = table.rowAtPoint(e.getPoint());
        int c = table.columnAtPoint(e.getPoint());
        if (r >= 0 && c >= 0) {
            c = table.convertColumnIndexToModel(c);
            JSCData data = table.getJSCData();
            if (isDoubleClick) {
                this.doubleClicked(table, data, r, c);
            } else {
                this.clicked(table, data, r, c);
            }
        }
    }

    protected boolean isSubsetRes(JSCNArrayTable table, int row, int col) {
        if (!(table instanceof CoeffTable)) {
            return false;
        }
        JSCNArray subsetRes = ((CoeffTable)table).getJSCNArraySubsetRes();
        if (subsetRes != null && row < subsetRes.rows() && col < subsetRes.cols()) {
            return subsetRes.intAt(row, col) == 0;
        }
        return false;
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.invokeAbstractMethod(e, true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this.invokeAbstractMethod(e, false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public final String toString() {
        return this.name;
    }
}

