/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.component.CompSettings;
import com.jstatcom.project.Project;
import com.jstatcom.project.ProjectTree;
import com.jstatcom.project.SettingsElement;
import java.io.File;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class ProjectTreeNode
extends DefaultMutableTreeNode
implements SettingsElement {
    private String name;
    private String desription;
    private File projectFile;
    private Date date;
    private boolean currentProject = false;
    private boolean lastState = false;
    public static final XmlFormat<ProjectTreeNode> ProjectTreeNode_XML = new XmlFormat<ProjectTreeNode>(ProjectTreeNode.class){

        @Override
        public void format(ProjectTreeNode data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            xml.setAttribute("date", data.date.getTime());
            xml.setAttribute("description", data.desription);
            xml.setAttribute("file", data.projectFile.getAbsolutePath());
            xml.setAttribute("current", data.currentProject);
        }

        @Override
        public ProjectTreeNode parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            long dateMillis = Long.parseLong(xml.getAttribute("date") + "");
            String description = xml.getAttribute("description") + "";
            File file = new File(xml.getAttribute("file") + "");
            boolean current = Boolean.valueOf(xml.getAttribute("current") + "");
            return new ProjectTreeNode(nam, description, new Date(dateMillis), file, current);
        }
    };

    public ProjectTreeNode(Project project, File projectFile, boolean isCurrent) {
        if (project == null || projectFile == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = project.getName();
        this.desription = project.getDescription();
        this.date = project.getDate();
        this.projectFile = projectFile;
        this.setAllowsChildren(false);
        this.currentProject = isCurrent;
    }

    private ProjectTreeNode(String name, String description, Date date, File projectFile, boolean currentProject) {
        if (date == null || projectFile == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name;
        this.desription = description;
        this.date = date;
        this.projectFile = projectFile;
        this.currentProject = currentProject;
        this.setAllowsChildren(false);
    }

    String getDescription() {
        return this.desription;
    }

    File getProjectFile() {
        return this.projectFile;
    }

    String getName() {
        return this.name;
    }

    Date getDate() {
        return this.date;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectTreeNode)) {
            return false;
        }
        return this.projectFile.equals(((ProjectTreeNode)o).getProjectFile());
    }

    public int hashCode() {
        return this.projectFile.hashCode();
    }

    void setNode(ProjectTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = node.getName();
        this.desription = node.getDescription();
        this.date = node.getDate();
        this.projectFile = node.getProjectFile();
    }

    @Override
    public String toString() {
        String proj = this.name;
        return proj + " <" + CompSettings.getDefaultDateFormat().format(this.date) + ">";
    }

    boolean isCurrentProject() {
        return this.currentProject;
    }

    void setCurrentProject(boolean currentProject) {
        this.currentProject = currentProject;
    }

    @Override
    public void setElement() {
        this.currentProject = false;
        if (this.projectFile != null && this.projectFile.canRead()) {
            ProjectTree.getInstance().addProjectNode(this);
        }
    }

    boolean isLastState() {
        return this.lastState;
    }

    void setLastState(boolean lastState) {
        this.lastState = lastState;
    }
}

