/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.project.ModuleTreeNode;
import com.jstatcom.project.ProjectManager;
import com.jstatcom.project.ProjectNodePopup;
import com.jstatcom.project.ProjectTreeCellRenderer;
import com.jstatcom.project.ProjectTreeNode;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public final class ProjectTree
extends JTree {
    private static final Logger log = Logger.getLogger(ProjectTree.class);
    private static final List<ProjectTreeNode> projectList = new ArrayList<ProjectTreeNode>();
    private static final ProjectTree INSTANCE = new ProjectTree();
    private final DefaultMutableTreeNode ROOT = new DefaultMutableTreeNode("ROOT");
    private final DefaultTreeModel projectTreeModel = new DefaultTreeModel(this.ROOT);

    private ProjectTree() {
        this.setBorder(new EmptyBorder(3, 3, 0, 0));
        this.setModel(this.projectTreeModel);
        this.setRowHeight(18);
        this.setRootVisible(false);
        this.setCellRenderer(new ProjectTreeCellRenderer());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    ProjectTree.this.deleteSelectedProjects();
                    return;
                }
                if (keyEvent.getKeyCode() == 10) {
                    TreePath treePath = ProjectTree.this.getSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object o = treePath.getLastPathComponent();
                    if (o instanceof ProjectTreeNode) {
                        ProjectTreeNode node = (ProjectTreeNode)o;
                        ProjectTree.this.loadProjectForNode(node);
                        return;
                    }
                    if (o instanceof ModuleTreeNode) {
                        ModuleTreeNode node = (ModuleTreeNode)o;
                        node.doAction();
                        return;
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath treePath = ProjectTree.this.getPathForLocation(e.getX(), e.getY());
                if (treePath == null) {
                    return;
                }
                Object o = treePath.getLastPathComponent();
                if (o instanceof ProjectTreeNode) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        ProjectTree.this.setSelectionPath(treePath);
                        ProjectTreeNode node = (ProjectTreeNode)o;
                        ProjectNodePopup popup = ProjectNodePopup.getInstance();
                        popup.pack();
                        popup.show(ProjectTree.this, e.getX(), e.getY());
                        popup.setCurrentNode(node);
                    } else if (e.getClickCount() == 2) {
                        ProjectTreeNode node = (ProjectTreeNode)o;
                        ProjectTree.this.loadProjectForNode(node);
                    }
                    return;
                }
                if (o instanceof ModuleTreeNode) {
                    ModuleTreeNode node = (ModuleTreeNode)o;
                    node.doAction();
                    return;
                }
            }
        });
    }

    public void deleteSelectedProjects() {
        if (this.getSelectionCount() == 0) {
            return;
        }
        TreePath[] treePath = this.getSelectionPaths();
        boolean hasProjectNodes = false;
        if (treePath.length > 0) {
            for (int i = 0; i < treePath.length; ++i) {
                Object o = treePath[i].getLastPathComponent();
                if (!(o instanceof ProjectTreeNode)) continue;
                hasProjectNodes = true;
                break;
            }
        }
        if (!hasProjectNodes) {
            return;
        }
        String msg = "Removing selected projects.\nAlso delete project files?\n\n";
        msg = msg + "YES - delete project and file\nNO - only remove project from list\nCANCEL - do nothing";
        int status = JOptionPane.showConfirmDialog(TopFrameReference.getTopFrameRef(), msg, "Remove Selected Projects", 1, 3);
        if (status == 2) {
            return;
        }
        for (int i = 0; i < treePath.length; ++i) {
            Object o = treePath[i].getLastPathComponent();
            if (!(o instanceof ProjectTreeNode)) continue;
            ProjectTreeNode node = (ProjectTreeNode)o;
            this.projectTreeModel.removeNodeFromParent(node);
            projectList.remove(node);
            if (status != 0) continue;
            node.getProjectFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProjectForNode(ProjectTreeNode node) {
        try {
            this.setCursor(new Cursor(3));
            ProjectManager.getInstance().deSerializeProject(node.getProjectFile());
            this.selectNode(node);
            this.repaint();
        }
        catch (Throwable ex) {
            String msg = "There was an error loading a project from file:\n\"" + node.getProjectFile().getAbsolutePath() + "\".";
            log.error((Object)msg, ex);
            StdMessages.error(msg + "\nThe error message was:\n\"" + ex.getMessage() + "\"\nPlease see the log for more details.", "Project Load Error");
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    public static ProjectTree getInstance() {
        return INSTANCE;
    }

    protected void selectNode(ProjectTreeNode node) {
        for (int i = 0; i < projectList.size(); ++i) {
            projectList.get(i).setCurrentProject(false);
        }
        if (node != null) {
            node.setCurrentProject(true);
        }
    }

    Iterator getProjectNodesIterator() {
        return projectList.iterator();
    }

    public void removeTreeNode(MutableTreeNode node) {
        if (node == null) {
            return;
        }
        this.projectTreeModel.removeNodeFromParent(node);
        projectList.remove(node);
    }

    public void addModuleNode(ModuleTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        boolean inserted = false;
        for (int i = 0; i < this.ROOT.getChildCount(); ++i) {
            TreeNode item = this.ROOT.getChildAt(i);
            if (item instanceof ModuleTreeNode) {
                ModuleTreeNode mNode = (ModuleTreeNode)item;
                if (mNode.getName().compareTo(node.getName()) < 0) continue;
                this.ROOT.insert(node, i);
                inserted = true;
                break;
            }
            this.ROOT.insert(node, i);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.ROOT.add(node);
        }
        this.projectTreeModel.reload();
    }

    public void addProjectNode(ProjectTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (projectList.contains(node)) {
            int i = projectList.indexOf(node);
            ProjectTreeNode containedNode = projectList.get(i);
            containedNode.setNode(node);
            if (node.isCurrentProject()) {
                this.selectNode(containedNode);
            }
            this.repaint();
            return;
        }
        if (node.isCurrentProject()) {
            this.selectNode(node);
        }
        boolean inserted = false;
        for (int i = 0; i < this.ROOT.getChildCount(); ++i) {
            ProjectTreeNode pNode;
            TreeNode item = this.ROOT.getChildAt(i);
            if (!(item instanceof ProjectTreeNode) || (pNode = (ProjectTreeNode)item).getName().compareToIgnoreCase(node.getName()) < 0 || pNode.isLastState()) continue;
            this.ROOT.insert(node, i);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.ROOT.add(node);
        }
        projectList.add(node);
        this.projectTreeModel.reload();
    }
}

