/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrame;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.FileSupport;
import com.jstatcom.project.OutputData;
import com.jstatcom.project.OutputList;
import com.jstatcom.project.Project;
import com.jstatcom.project.ProjectData;
import com.jstatcom.project.ProjectDataManager;
import com.jstatcom.project.ProjectDialog;
import com.jstatcom.project.ProjectState;
import com.jstatcom.project.ProjectStateHandler;
import com.jstatcom.project.ProjectTree;
import com.jstatcom.project.ProjectTreeNode;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javolution37.javolution.xml.ObjectReader;
import javolution37.javolution.xml.ObjectWriter;
import javolution37.javolution.xml.XmlFormat;
import org.apache.log4j.Logger;

public final class ProjectManager {
    private static final Logger log = Logger.getLogger(ProjectManager.class);
    private final Map<String, String> addedPackagePrefsMap = new HashMap<String, String>();
    private static final ProjectManager INSTANCE = new ProjectManager();
    private final Map<String, ProjectStateHandler> handlerMap = new HashMap<String, ProjectStateHandler>();
    private final Map<String, ProjectState> projectStatesMap = new HashMap<String, ProjectState>();
    private AbstractAction serializationAction = null;
    private AbstractAction deSerializationAction = null;
    private TopFrame topFrame = null;

    private ProjectManager() {
    }

    public static ProjectManager getInstance() {
        return INSTANCE;
    }

    public AbstractAction getSerializationAction() {
        if (this.serializationAction == null) {
            URL url = this.getClass().getResource("/images/saveprojectas.gif");
            ImageIcon icon = null;
            if (url != null) {
                icon = new ImageIcon(url);
            }
            this.serializationAction = new AbstractAction("Save Project As", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProjectDialog pDialog = ProjectDialog.getInstance();
                    pDialog.setSaveDialog(true);
                    pDialog.setVisible(true);
                    if (pDialog.isCancelled()) {
                        return;
                    }
                    ProjectTreeNode node = pDialog.getProjectNode();
                    if (node == null) {
                        throw new IllegalStateException("Project node from dialog was null.");
                    }
                    try {
                        ProjectManager.getInstance().serializeProject(node.getProjectFile(), node.getName(), node.getDescription());
                    }
                    catch (Throwable ex) {
                        String msg = "There was an error saving a project to file:\n\"" + node.getProjectFile().getAbsolutePath() + "\".";
                        log.error((Object)msg, ex);
                        StdMessages.error(msg + "\nThe error message was:\n\"" + ex.getMessage() + "\"\nPlease see the log for more details.", "Project Save Error");
                    }
                }
            };
            this.serializationAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
        }
        return this.serializationAction;
    }

    public AbstractAction getDeSerializationAction() {
        if (this.deSerializationAction == null) {
            URL url = this.getClass().getResource("/images/openproject.gif");
            ImageIcon icon = null;
            if (url != null) {
                icon = new ImageIcon(url);
            }
            this.deSerializationAction = new AbstractAction("Open Project", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    File file = FileSupport.getInstance().selectProjectFile(TopFrameReference.getTopFrameRef());
                    if (file == null) {
                        return;
                    }
                    try {
                        ProjectManager.getInstance().deSerializeProject(file);
                    }
                    catch (Throwable ex) {
                        String msg = "There was an error loading a project from file:\n\"" + file.getAbsolutePath() + "\".";
                        log.error((Object)msg, ex);
                        StdMessages.error(msg + "\nThe error message was:\n\"" + ex.getMessage() + "\"\nPlease see the log for more details.", "Project Load Error");
                    }
                }
            };
            this.deSerializationAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control O"));
        }
        return this.deSerializationAction;
    }

    public void setProjectToFile(File currentProjectFile, Project project) {
        if (currentProjectFile == null || project == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.topFrame != null) {
            project.setCurrentModuleFrame(this.topFrame.getTopModuleByName());
        }
        try {
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(currentProjectFile));
            GZIPOutputStream out = new GZIPOutputStream(fout);
            ObjectWriter<Project> objectWriter = new ObjectWriter<Project>();
            objectWriter.setPackagePrefix("", "com.jstatcom.model");
            objectWriter.setPackagePrefix("jstatcom", "com.jstatcom");
            for (String nam : this.addedPackagePrefsMap.keySet()) {
                objectWriter.setPackagePrefix(nam, this.addedPackagePrefsMap.get(nam));
            }
            objectWriter.write(project, out);
            fout.close();
        }
        catch (IOException ivjExc) {
            throw new RuntimeException(ivjExc);
        }
    }

    public void addPackagePrefix(String name, String packageName) {
        if (name == null || packageName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (name.length() == 0 || packageName.length() == 0) {
            throw new IllegalArgumentException("Argument was empty.");
        }
        if (name.equalsIgnoreCase("jstatcom") || packageName.equalsIgnoreCase("com.jstatcom")) {
            throw new IllegalArgumentException("Tried to overwrite default package prefix.");
        }
        if (this.addedPackagePrefsMap.containsKey(name)) {
            throw new IllegalArgumentException("Package prefix \"" + name + "\" already set.");
        }
        if (this.addedPackagePrefsMap.containsValue(packageName)) {
            throw new IllegalArgumentException("Package prefix for \"" + packageName + "\" already set.");
        }
        this.addedPackagePrefsMap.put(name, packageName);
    }

    public void serializeProject(File currentProjectFile, String name, String description) {
        if (currentProjectFile == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        Project project = new Project(name, description);
        if (this.topFrame != null) {
            project.setCurrentModuleFrame(this.topFrame.getTopModuleByName());
        }
        ListModel listModel = OutputList.getInstance().getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            project.addOutputData((OutputData)listModel.getElementAt(i));
        }
        ProjectData[] pData = ProjectDataManager.getInstance().getProjectData();
        for (int i = 0; i < pData.length; ++i) {
            project.addProjectData(pData[i]);
        }
        for (ProjectStateHandler element : this.handlerMap.values()) {
            project.addProjectState(element.getState());
        }
        this.setProjectToFile(currentProjectFile, project);
        ProjectTreeNode node = new ProjectTreeNode(project, currentProjectFile, true);
        ProjectTree.getInstance().addProjectNode(node);
    }

    public Project getProjectFromFile(File currentProjectFile) {
        if (currentProjectFile == null) {
            throw new IllegalArgumentException("Project file was null.");
        }
        if (!currentProjectFile.isFile() || !currentProjectFile.canRead()) {
            throw new IllegalArgumentException("Project file " + currentProjectFile.getAbsolutePath() + " does not exist or is not readable.");
        }
        ObjectReader constructor = new ObjectReader();
        Project project = null;
        try {
            BufferedInputStream fin;
            try {
                fin = new BufferedInputStream(new FileInputStream(currentProjectFile));
                GZIPInputStream in = new GZIPInputStream(fin);
                project = (Project)constructor.read(in);
                ((InputStream)in).close();
            }
            catch (Throwable t) {
                project = null;
                log.warn((Object)("GZIP import failed for file \"" + currentProjectFile + "\": " + t.getMessage()));
            }
            fin = new BufferedInputStream(new FileInputStream(currentProjectFile));
            if (project == null) {
                project = (Project)constructor.read(fin);
            }
            ((InputStream)fin).close();
        }
        catch (Throwable t) {
            log.error((Object)"XML deserialization failed", t);
        }
        return project;
    }

    public ProjectTreeNode deSerializeProject(File currentProjectFile) {
        Object element;
        Project project = this.getProjectFromFile(currentProjectFile);
        ProjectTreeNode node = new ProjectTreeNode(project, currentProjectFile, true);
        ProjectTree.getInstance().addProjectNode(node);
        Iterator iter = project.getProjectDataIterator();
        while (iter.hasNext()) {
            element = (ProjectData)iter.next();
            ProjectDataManager.getInstance().setProjectData((ProjectData)element);
        }
        OutputList.getInstance().removeAll();
        iter = project.getOutputDataIterator();
        while (iter.hasNext()) {
            element = (OutputData)iter.next();
            OutputList.getInstance().addOutput((OutputData)element);
        }
        iter = project.getProjectStatesIterator();
        while (iter.hasNext()) {
            element = (ProjectState)iter.next();
            ProjectStateHandler handler = this.handlerMap.get(element.getHandlerID());
            if (handler != null) {
                try {
                    handler.setState((ProjectState)element);
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to set state for element: " + element), t);
                }
                continue;
            }
            this.projectStatesMap.put(element.getHandlerID(), (ProjectState)element);
        }
        if (this.topFrame != null) {
            String top = this.topFrame.getTopModuleByName();
            String newCurrent = project.getCurrentModuleFrame();
            if (!newCurrent.equals(top)) {
                this.topFrame.setTopModuleByName(newCurrent);
            }
        }
        return node;
    }

    public void addProjectStateHandler(ProjectStateHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.handlerMap.put(handler.getID(), handler);
        if (this.projectStatesMap.containsKey(handler.getID())) {
            try {
                handler.setState(this.projectStatesMap.get(handler.getID()));
            }
            catch (Throwable t) {
                log.error((Object)("Failed to set state for handler ID:" + handler.getID()), t);
            }
        }
    }

    public void setTopFrame(TopFrame topFrame) {
        this.topFrame = topFrame;
    }

    public TopFrame getTopFrame() {
        return this.topFrame;
    }

    public void addClassTransformation(String oldClassName, String newClassName) {
        XmlFormat.addClassTransformation(oldClassName, newClassName);
    }
}

