/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.project.OutputData;
import com.jstatcom.project.ProjectData;
import com.jstatcom.project.ProjectState;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;
import org.apache.log4j.Logger;

public final class Project {
    private static final Logger log = Logger.getLogger(Project.class);
    private final Date date;
    private final String name;
    private String currentModuleFrame = "";
    private final String description;
    private final String version = "1.0";
    private final List<OutputData> outputDataList = new ArrayList<OutputData>();
    private final List<ProjectData> projectDataList = new ArrayList<ProjectData>();
    private final List<ProjectState> projectStatesList = new ArrayList<ProjectState>();
    public static final XmlFormat<Project> Project_XML = new XmlFormat<Project>(Project.class){

        @Override
        public void format(Project data, XmlElement xml) {
            xml.setAttribute("version", "1.0");
            xml.setAttribute("date", data.date.getTime());
            xml.setAttribute("name", data.name);
            xml.setAttribute("description", data.description);
            xml.setAttribute("showing_module", data.currentModuleFrame);
            for (Object el : data.projectDataList) {
                xml.add(el);
            }
            for (Object el : data.outputDataList) {
                xml.add(el);
            }
            for (Object el : data.projectStatesList) {
                xml.add(el);
            }
        }

        @Override
        public Project parse(XmlElement xml) {
            long dateLong = Long.valueOf(xml.getAttribute("date") + "");
            String nam = xml.getAttribute("name") + "";
            String des = xml.getAttribute("description") + "";
            String showing_module = xml.getAttribute("showing_module") + "";
            if (nam.equalsIgnoreCase("null")) {
                nam = "";
            }
            if (des.equalsIgnoreCase("null")) {
                des = "";
            }
            if (showing_module.equalsIgnoreCase("null")) {
                showing_module = "";
            }
            Project project = new Project(new Date(dateLong), nam, des);
            project.setCurrentModuleFrame(showing_module);
            while (xml.hasNext()) {
                try {
                    Object el = xml.getNext();
                    if (el instanceof OutputData) {
                        project.addOutputData((OutputData)el);
                        continue;
                    }
                    if (el instanceof ProjectData) {
                        project.addProjectData((ProjectData)el);
                        continue;
                    }
                    if (!(el instanceof ProjectState)) continue;
                    project.addProjectState((ProjectState)el);
                }
                catch (Throwable t) {
                    log.warn((Object)("problem reading parts of project: " + project.name), t);
                }
            }
            return project;
        }
    };

    public Project(String name, String description) {
        this(new Date(), name, description);
    }

    private Project(Date date, String name, String description) {
        if (name == null || name.length() == 0) {
            name = "project";
        }
        if (description == null) {
            description = "";
        }
        this.date = date;
        this.name = name;
        this.description = description;
    }

    public void addProjectData(ProjectData pData) {
        if (pData == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!this.projectDataList.contains(pData)) {
            this.projectDataList.add(pData);
        }
    }

    public void addOutputData(OutputData outputData) {
        if (outputData == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.outputDataList.add(outputData);
    }

    public void addProjectState(ProjectState projectState) {
        if (projectState == null) {
            return;
        }
        this.projectStatesList.add(projectState);
    }

    public Iterator getOutputDataIterator() {
        return this.outputDataList.iterator();
    }

    public Iterator getProjectDataIterator() {
        return this.projectDataList.iterator();
    }

    public Iterator getProjectStatesIterator() {
        return this.projectStatesList.iterator();
    }

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getCurrentModuleFrame() {
        return this.currentModuleFrame;
    }

    public void setCurrentModuleFrame(String currentModuleFrame) {
        if (currentModuleFrame == null) {
            return;
        }
        this.currentModuleFrame = currentModuleFrame;
    }
}

