/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.project.OutputData;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;

public final class OutputList
extends JList {
    private boolean isOutputHistory = true;
    private static final OutputList INSTANCE = new OutputList();
    private final DefaultListModel model = new DefaultListModel();
    private boolean sortByTime = true;
    private JFrame parent = null;

    public void addOutput(OutputData dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!this.isOutputHistory) {
            return;
        }
        if (this.sortByTime) {
            this.model.addElement(dataObject);
        } else {
            boolean inserted = false;
            for (int i = 0; i < this.model.size(); ++i) {
                Object item = this.model.elementAt(i);
                if (!(item instanceof OutputData)) continue;
                OutputData data = (OutputData)item;
                int compare = data.name.compareTo(dataObject.name);
                if (compare < 0) continue;
                if (compare == 0) {
                    if (i + 1 < this.model.size()) {
                        this.model.add(i + 1, dataObject);
                    } else {
                        this.model.addElement(dataObject);
                    }
                } else {
                    this.model.add(i, dataObject);
                }
                inserted = true;
                break;
            }
            if (!inserted) {
                this.model.addElement(dataObject);
            }
        }
    }

    public void removeSelected() {
        int[] index = this.getSelectedIndices();
        Arrays.sort(index);
        for (int i = index.length - 1; i >= 0; --i) {
            this.model.remove(index[i]);
        }
    }

    @Override
    public void removeAll() {
        this.model.clear();
    }

    private void sortKeepSelection(Comparator<? super Object> comparator) {
        Object[] listElements = new Object[this.model.size()];
        this.model.copyInto(listElements);
        for (int i = 0; i < this.model.size(); ++i) {
            ((OutputData)listElements[i]).selected = this.isSelectedIndex(i);
        }
        Arrays.sort(listElements, comparator);
        int[] selection = this.getSelectedIndices();
        this.model.clear();
        int k = 0;
        for (int i = 0; i < listElements.length; ++i) {
            if (((OutputData)listElements[i]).selected) {
                selection[k++] = i;
            }
            this.model.addElement(listElements[i]);
        }
        this.setSelectedIndices(selection);
    }

    public void sortByTime() {
        if (this.sortByTime) {
            return;
        }
        this.sortByTime = true;
        this.sortKeepSelection(OutputListComparators.ByTimeComparator);
    }

    public void sortByName() {
        if (!this.sortByTime) {
            return;
        }
        this.sortByTime = false;
        this.sortKeepSelection(OutputListComparators.ByNameComparator);
    }

    private OutputList() {
        this.setModel(this.model);
        URL url = this.getClass().getResource("/images/outputdata.gif");
        if (url == null) {
            return;
        }
        final ImageIcon icon = new ImageIcon(url);
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setIcon(icon);
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setText(value.toString());
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                return this;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object obj = keyEvent.getSource();
                if (!(obj instanceof OutputList)) {
                    return;
                }
                OutputList list = (OutputList)obj;
                if (keyEvent.getKeyChar() == '\u007f') {
                    if (JOptionPane.showConfirmDialog(OutputList.this.parent, "Remove selected output elements?", "Clear Selected", 0, 3) == 1) {
                        return;
                    }
                    list.removeSelected();
                }
                if (keyEvent.getKeyCode() == 65 && keyEvent.getModifiers() == 2 && list.getModel().getSize() > 0) {
                    list.setSelectedIndex(0);
                }
            }
        });
    }

    public static OutputList getInstance() {
        return INSTANCE;
    }

    public boolean isSortByTime() {
        return this.sortByTime;
    }

    public void setSortByTime(boolean sortByTime) {
        this.sortByTime = sortByTime;
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    public boolean isOutputHistory() {
        return this.isOutputHistory;
    }

    public void setOutputHistory(boolean isOutputHistory) {
        this.isOutputHistory = isOutputHistory;
    }

    private static abstract class OutputListComparators
    implements Comparator<Object> {
        public static final OutputListComparators ByNameComparator = new OutputListComparators(){

            @Override
            public int compare(Object a, Object b) {
                if (!(a instanceof OutputData) || !(b instanceof OutputData)) {
                    throw new IllegalArgumentException("Wrong argument for OutputListComparators");
                }
                return ((OutputData)a).name.compareTo(((OutputData)b).name);
            }
        };
        public static final OutputListComparators ByTimeComparator = new OutputListComparators(){

            @Override
            public int compare(Object a, Object b) {
                if (!(a instanceof OutputData) || !(b instanceof OutputData)) {
                    throw new IllegalArgumentException("Wrong argument for OutputListComparators");
                }
                return ((OutputData)a).date.compareTo(((OutputData)b).date);
            }
        };

        private OutputListComparators() {
        }

        @Override
        public abstract int compare(Object var1, Object var2);
    }
}

