/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.component.CompSettings;
import java.util.Date;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class OutputData {
    public final String output;
    public final Date date;
    public final String name;
    public boolean selected = false;
    public static final XmlFormat<OutputData> OutputData_XML = new XmlFormat<OutputData>(OutputData.class){

        @Override
        public void format(OutputData data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            xml.setAttribute("date", data.date.getTime());
            xml.setAttribute("output", data.output);
        }

        @Override
        public OutputData parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            long dateMillis = Long.parseLong(xml.getAttribute("date") + "");
            String output = xml.getAttribute("output") + "";
            return new OutputData(nam, output, new Date(dateMillis));
        }
    };

    public OutputData(String name, String output) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name;
        this.output = output;
        this.date = new Date();
    }

    private OutputData(String name, String output, Date date) {
        this.name = name;
        this.output = output;
        this.date = date;
    }

    public String toString() {
        return this.name + " <" + CompSettings.getDefaultDateFormat().format(this.date) + ">";
    }
}

