/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.parser;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.NumberRange;
import com.jstatcom.model.NumberRangeTypes;
import com.jstatcom.parser.NumberRangeParserConstants;
import com.jstatcom.parser.NumberRangeParserTokenManager;
import com.jstatcom.parser.ParseException;
import com.jstatcom.parser.SimpleCharStream;
import com.jstatcom.parser.Token;
import com.jstatcom.parser.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import java.util.Vector;

public class NumberRangeParser
implements NumberRangeParserConstants {
    private final Stack<Object> argStack = new Stack();
    public NumberRangeParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[10];
    private final int[] jj_la1_0 = new int[]{17, 17, 49, 17, 17, 49, 72256, 6720, 72768, 7232};
    private Vector<Object> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public NumberRangeParser() {
        this(new StringReader(""));
    }

    public NumberRangeParser(NumberRangeParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public NumberRangeParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new NumberRangeParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public NumberRangeParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new NumberRangeParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public final void disable_tracing() {
    }

    public final void enable_tracing() {
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[18];
        for (i = 0; i < 18; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 10; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 18; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final void leftBracket() throws ParseException {
        this.jj_consume_token(5);
        if (this.token.image.equals("(")) {
            this.argStack.push(Boolean.valueOf("TRUE"));
        } else {
            this.argStack.push(Boolean.valueOf("FALSE"));
        }
    }

    public final void lowerBound() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                this.argStack.push(this.token.image);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf("-" + this.token.image));
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf(this.token.image));
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                this.argStack.push(JSCConstants.NEG_INF);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                throw new ParseException("NaN is not a valid bound.");
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void lowerBound_noSymbols() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf("-" + this.token.image));
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf(this.token.image));
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                this.argStack.push(JSCConstants.NEG_INF);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                throw new ParseException("NaN is not a valid bound.");
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static void main(String[] args) throws ParseException {
        NumberRangeParser parser = new NumberRangeParser(System.in);
        while (true) {
            System.out.print("Enter Range Expression: ");
            System.out.flush();
            try {
                switch (parser.toeval()) {
                    case 0: {
                        System.out.println("nothing.");
                        return;
                    }
                    case 1: {
                        NumberRangeTypes rangeType = (NumberRangeTypes)parser.argStack.pop();
                        Object upperBound = parser.argStack.pop();
                        Object lowerBound = parser.argStack.pop();
                        System.out.println("assembled Range = " + rangeType.leftBracket + lowerBound + ", " + upperBound + rangeType.rightBracket);
                    }
                }
            }
            catch (ParseException x) {
                System.out.println("Exiting.");
                throw x;
            }
        }
    }

    public Object[] parseString(String inputString) throws ParseException, TokenMgrError {
        this.ReInit(new StringReader(inputString));
        this.toeval();
        Object rangeType = this.argStack.pop();
        Object upperBound = this.argStack.pop();
        Object lowerBound = this.argStack.pop();
        return new Object[]{lowerBound, upperBound, rangeType};
    }

    public NumberRange parseStringToRange(String inputString) throws ParseException, TokenMgrError {
        this.ReInit(new StringReader(inputString));
        this.toeval_noSymbols();
        return (NumberRange)this.argStack.pop();
    }

    public void ReInit(NumberRangeParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 10; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public final void rightBracket() throws ParseException {
        this.jj_consume_token(7);
        if (this.token.image.equals(")")) {
            this.argStack.push(Boolean.valueOf("TRUE"));
        } else {
            this.argStack.push(Boolean.valueOf("FALSE"));
        }
    }

    public final int toeval() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.leftBracket();
                this.lowerBound();
                this.jj_consume_token(8);
                this.upperBound();
                this.rightBracket();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        break;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                boolean isRightOpen = (Boolean)this.argStack.pop();
                Object upper = this.argStack.pop();
                String upperSName = null;
                Double upperNumber = null;
                if (upper instanceof Double) {
                    upperNumber = (Double)upper;
                } else {
                    upperSName = upper.toString();
                }
                Object lower = this.argStack.pop();
                String lowerSName = null;
                Double lowerNumber = null;
                if (lower instanceof Double) {
                    lowerNumber = (Double)lower;
                } else {
                    lowerSName = lower.toString();
                }
                boolean isLeftOpen = (Boolean)this.argStack.pop();
                NumberRangeTypes rangeType = NumberRangeTypes.getTypeForBounds(isLeftOpen, isRightOpen);
                if (lowerNumber != null && upperNumber != null) {
                    if (lowerNumber.doubleValue() == upperNumber.doubleValue() && (isLeftOpen || isRightOpen)) {
                        throw new IllegalArgumentException("If bounds are equal, interval type must be CLOSED.");
                    }
                    if (lowerNumber > upperNumber) {
                        throw new IllegalArgumentException("Lower bound is greater than upper bound.");
                    }
                }
                if (lowerSName != null && upperSName != null && (isLeftOpen || isRightOpen) && lowerSName.equalsIgnoreCase(upperSName)) {
                    throw new IllegalArgumentException("If bounds are equal, interval type must be CLOSED.");
                }
                if (lowerSName != null) {
                    this.argStack.push(lowerSName);
                } else {
                    if (!isLeftOpen && lowerNumber == Double.NEGATIVE_INFINITY) {
                        throw new IllegalArgumentException("Lower bound cannot be closed and -INFINITY.");
                    }
                    this.argStack.push(lowerNumber);
                }
                if (upperSName != null) {
                    this.argStack.push(upperSName);
                } else {
                    if (!isRightOpen && upperNumber == Double.POSITIVE_INFINITY) {
                        throw new IllegalArgumentException("Upper bound cannot be closed and +INFINITY.");
                    }
                    this.argStack.push(upperNumber);
                }
                this.argStack.push(rangeType);
                return 1;
            }
            case 0: 
            case 4: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        break;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return 0;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int toeval_noSymbols() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.leftBracket();
                this.lowerBound_noSymbols();
                this.jj_consume_token(8);
                this.upperBound_noSymbols();
                this.rightBracket();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        break;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                boolean isRightOpen = (Boolean)this.argStack.pop();
                double upperBound = (Double)this.argStack.pop();
                double lowerBound = (Double)this.argStack.pop();
                boolean isLeftOpen = (Boolean)this.argStack.pop();
                NumberRange range = new NumberRange(lowerBound, upperBound, NumberRangeTypes.getTypeForBounds(isLeftOpen, isRightOpen));
                this.argStack.push(range);
                return 1;
            }
            case 0: 
            case 4: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        break;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return 0;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void upperBound() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                this.argStack.push(this.token.image);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf("-" + this.token.image));
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf(this.token.image));
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                this.argStack.push(JSCConstants.POS_INF);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                throw new ParseException("NaN is not a valid bound.");
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void upperBound_noSymbols() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf("-" + this.token.image));
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.argStack.push(Double.valueOf(this.token.image));
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                this.argStack.push(JSCConstants.POS_INF);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                throw new ParseException("NaN is not a valid bound.");
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }
}

