/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model.control;

import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.model.control.SymbolTreeNode;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public final class SymbolTableTreeNode
extends DefaultMutableTreeNode {
    public final SymbolTable symbolTable;
    private final DefaultTreeModel symbolTreeModel;
    private final DefaultMutableTreeNode parent;

    public SymbolTableTreeNode(SymbolTable symbolTable, DefaultTreeModel symbolTreeModel) {
        super(symbolTable.NAME, true);
        if (symbolTable == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.symbolTreeModel = symbolTreeModel;
        this.symbolTable = symbolTable;
        SymbolTable parentTable = symbolTable.getParentTable();
        this.parent = parentTable == null ? (DefaultMutableTreeNode)symbolTreeModel.getRoot() : parentTable.getSymbolTableNode();
        symbolTable.setSymbolTableNode(this);
        if (this.getChildCount() > 0) {
            SymbolTableTreeNode.addSymbolTableNode(this, this.parent);
        }
        this.reloadInEDT();
    }

    private static void addSymbolTableNode(SymbolTableTreeNode symbolTableTreeNode, DefaultMutableTreeNode parent) {
        if (parent.getChildCount() == 0) {
            parent.add(symbolTableTreeNode);
            return;
        }
        boolean inserted = false;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode item = parent.getChildAt(i);
            if (item instanceof SymbolTreeNode) {
                parent.insert(symbolTableTreeNode, i);
                inserted = true;
                break;
            }
            if (!(item instanceof SymbolTableTreeNode)) continue;
            SymbolTableTreeNode node = (SymbolTableTreeNode)item;
            if (node.symbolTable.NAME.compareTo(symbolTableTreeNode.symbolTable.NAME) < 0) continue;
            parent.insert(symbolTableTreeNode, i);
            inserted = true;
            break;
        }
        if (!inserted) {
            parent.add(symbolTableTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbol(Symbol symbol) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.parent;
        synchronized (defaultMutableTreeNode) {
            SymbolTableTreeNode symbolTableTreeNode = this;
            synchronized (symbolTableTreeNode) {
                boolean wasEmpty = this.getChildCount() == 0;
                boolean inserted = false;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    TreeNode item = this.getChildAt(i);
                    if (!(item instanceof SymbolTreeNode)) continue;
                    SymbolTreeNode node = (SymbolTreeNode)item;
                    if (node.symbol.NAME.compareTo(symbol.NAME) < 0) continue;
                    this.insert(new SymbolTreeNode(symbol), i);
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    this.add(new SymbolTreeNode(symbol));
                }
                boolean alreadUpdated = false;
                if (wasEmpty) {
                    SymbolTableTreeNode.addSymbolTableNode(this, this.parent);
                    if (this.parent instanceof SymbolTableTreeNode) {
                        alreadUpdated = ((SymbolTableTreeNode)this.parent).updateAfterAdd();
                    }
                }
                if (!alreadUpdated) {
                    this.reloadInEDT();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSymbol(String name) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.parent;
        synchronized (defaultMutableTreeNode) {
            SymbolTableTreeNode symbolTableTreeNode = this;
            synchronized (symbolTableTreeNode) {
                boolean lastElement = this.getChildCount() == 1;
                boolean alreadUpdated = false;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    TreeNode item = this.getChildAt(i);
                    if (!(item instanceof SymbolTreeNode)) continue;
                    SymbolTreeNode node = (SymbolTreeNode)this.getChildAt(i);
                    if (node.symbol.NAME.compareToIgnoreCase(name) != 0) continue;
                    this.remove(i);
                    if (lastElement) {
                        ((DefaultMutableTreeNode)this.getParent()).remove(this);
                        if (this.parent instanceof SymbolTableTreeNode) {
                            alreadUpdated = ((SymbolTableTreeNode)this.parent).updateAfterRemove();
                        }
                    }
                    if (!alreadUpdated) {
                        this.reloadInEDT();
                    }
                    return;
                }
            }
        }
    }

    public void clear() {
        if (this.getChildCount() == 0) {
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode item = this.getChildAt(i);
            if (!(item instanceof SymbolTreeNode)) continue;
            this.remove(i--);
        }
        boolean alreadUpdated = false;
        if (this.getChildCount() == 0) {
            this.parent.remove(this);
        }
        if (this.parent instanceof SymbolTableTreeNode) {
            alreadUpdated = ((SymbolTableTreeNode)this.parent).updateAfterRemove();
        }
        if (!alreadUpdated) {
            this.reloadInEDT();
        }
    }

    private boolean updateAfterAdd() {
        boolean wasEmpty = this.getChildCount() == 1;
        boolean alreadUpdated = false;
        if (wasEmpty) {
            SymbolTableTreeNode.addSymbolTableNode(this, this.parent);
            if (this.parent instanceof SymbolTableTreeNode) {
                alreadUpdated = ((SymbolTableTreeNode)this.parent).updateAfterAdd();
            }
            if (!alreadUpdated) {
                this.symbolTreeModel.reload(this.parent);
            }
            return true;
        }
        return false;
    }

    private boolean updateAfterRemove() {
        boolean empty = this.getChildCount() == 0;
        boolean alreadUpdated = false;
        if (empty) {
            this.parent.remove(this);
            if (this.parent instanceof SymbolTableTreeNode) {
                alreadUpdated = ((SymbolTableTreeNode)this.parent).updateAfterRemove();
            }
            if (!alreadUpdated) {
                this.reloadInEDT();
            }
            return true;
        }
        return false;
    }

    private void reloadInEDT() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.symbolTreeModel.reload(this.parent);
        } else {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    SymbolTableTreeNode.this.symbolTreeModel.reload(SymbolTableTreeNode.this.parent);
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }
}

