/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model.control;

import com.jstatcom.component.AppSettings;
import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrame;
import com.jstatcom.io.DataHandlerTypes;
import com.jstatcom.io.FileSupport;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.control.NArraySaveDlg;
import com.jstatcom.model.control.SymbolPanel;
import com.jstatcom.table.JSCDataTableScrollPane;
import com.jstatcom.table.JSCNArrayTable;
import com.jstatcom.table.JSCNArrayTableModel;
import com.jstatcom.util.UMatrix;
import com.jstatcom.util.UStringArray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public final class JSCNArrayPanel
extends SymbolPanel {
    private static final Logger log = Logger.getLogger(JSCNArrayPanel.class);
    private JFrame top = null;
    private Symbol currentSymbol = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private NArraySaveDlg optionsDlg = null;
    private JSCDataTableScrollPane JSCDataTableScrollPane = null;
    private JSCNArrayTable JSCNArrayTable = null;
    private JComboBox selModeCombo = null;

    public JSCNArrayPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints11 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints12 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints10 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints13 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints15 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints16 = new GridBagConstraints();
        consGridBagConstraints1.fill = 1;
        consGridBagConstraints1.weighty = 1.0;
        consGridBagConstraints1.weightx = 1.0;
        consGridBagConstraints1.gridy = 4;
        consGridBagConstraints1.gridx = 0;
        consGridBagConstraints1.gridwidth = 6;
        consGridBagConstraints13.gridy = 3;
        consGridBagConstraints13.gridx = 1;
        consGridBagConstraints13.fill = 2;
        consGridBagConstraints13.insets = new Insets(2, 0, 5, 0);
        consGridBagConstraints12.gridy = 1;
        consGridBagConstraints12.gridx = 1;
        consGridBagConstraints12.fill = 2;
        consGridBagConstraints15.gridy = 1;
        consGridBagConstraints15.gridx = 2;
        consGridBagConstraints15.gridheight = 3;
        consGridBagConstraints15.weightx = 0.0;
        consGridBagConstraints16.gridy = 1;
        consGridBagConstraints16.gridx = 3;
        consGridBagConstraints16.gridheight = 3;
        consGridBagConstraints16.weightx = 0.0;
        consGridBagConstraints11.gridy = 3;
        consGridBagConstraints11.gridx = 0;
        consGridBagConstraints11.fill = 2;
        consGridBagConstraints10.gridy = 1;
        consGridBagConstraints10.gridx = 0;
        consGridBagConstraints10.fill = 2;
        consGridBagConstraints10.insets = new Insets(0, 5, 0, 0);
        consGridBagConstraints11.insets = new Insets(2, 5, 5, 0);
        consGridBagConstraints12.insets = new Insets(0, 0, 0, 0);
        consGridBagConstraints15.insets = new Insets(0, 10, 0, 0);
        consGridBagConstraints16.anchor = 17;
        consGridBagConstraints16.insets = new Insets(0, 10, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJLabel(), consGridBagConstraints10);
        this.add((Component)this.getJLabel1(), consGridBagConstraints11);
        this.add((Component)this.getRowsLabel(), consGridBagConstraints12);
        this.add((Component)this.getColsLabel(), consGridBagConstraints13);
        this.add((Component)this.getSaveButton(), consGridBagConstraints15);
        this.setSize(500, 302);
        this.setBorder(new TitledBorder(new BevelBorder(1), "Value of " + JSCTypes.NARRAY + "", 3, 2));
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints1.gridheight = 3;
        this.add((Component)this.getOptionsButton(), consGridBagConstraints16);
        this.add((Component)this.getJSCDataTableScrollPane(), consGridBagConstraints1);
        this.add((Component)this.getSelModeCombo(), gridBagConstraints1);
    }

    private NArraySaveDlg getArraySaveDlg() {
        if (this.optionsDlg == null) {
            SwingUtilities.getWindowAncestor(this);
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof JFrame) {
                this.top = (JFrame)window;
            }
            this.optionsDlg = new NArraySaveDlg((Frame)this.top, true);
            if (this.top != null) {
                this.optionsDlg.setLocationRelativeTo(this.top);
            }
        }
        return this.optionsDlg;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        int max;
        if (symbol == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (symbol.type != JSCTypes.NARRAY) {
            throw new IllegalArgumentException("Invalid type " + symbol.type + " for " + JSCTypes.NARRAY + " panel.");
        }
        JSCNArray nArray = symbol.getJSCNArray();
        this.getRowsLabel().setText(nArray.rows() + "");
        this.getColsLabel().setText(nArray.cols() + "");
        this.currentSymbol = symbol;
        AppSettings app = TopFrame.getApplicationSettings();
        JSCInt maxNum = app.getMaxArrayDisplaySize();
        int n = max = maxNum == null ? 10000 : maxNum.intVal();
        if (nArray.rows() * nArray.cols() > max) {
            this.getJSCDataTableScrollPane().setColumnHeaderData(new JSCSArray("colHeader", "Array too large for display"));
            this.getJSCDataTableScrollPane().setRowHeaderData(new JSCSArray("rowHeader", new String[0]));
            this.getJSCNArrayTable().setModel(new JSCNArrayTableModel(new Symbol(new JSCTypeDef("EMPTY", JSCTypes.NARRAY))));
            this.getSelModeCombo().setEnabled(false);
            return;
        }
        this.getSelModeCombo().setEnabled(true);
        String[] colHeader = UStringArray.createNamedIndex("", UMatrix.seqa(1.0, 1.0, nArray.cols()));
        String[] rowHeader = UStringArray.createNamedIndex("", UMatrix.seqa(1.0, 1.0, nArray.rows()));
        this.getJSCDataTableScrollPane().setColumnHeaderData(new JSCSArray("colHeader", colHeader));
        this.getJSCDataTableScrollPane().setRowHeaderData(new JSCSArray("rowHeader", rowHeader));
        this.getJSCNArrayTable().setModel(new JSCNArrayTableModel(symbol));
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Rows");
            this.jLabel.setPreferredSize(new Dimension(38, 20));
            this.jLabel.setMinimumSize(new Dimension(40, 16));
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Cols");
            this.jLabel1.setPreferredSize(new Dimension(40, 20));
            this.jLabel1.setMinimumSize(new Dimension(40, 16));
        }
        return this.jLabel1;
    }

    private JLabel getRowsLabel() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("");
            this.jLabel2.setPreferredSize(new Dimension(38, 20));
        }
        return this.jLabel2;
    }

    private JLabel getColsLabel() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("");
            this.jLabel3.setPreferredSize(new Dimension(50, 20));
            this.jLabel3.setMinimumSize(new Dimension(50, 20));
        }
        return this.jLabel3;
    }

    private Symbol getCurrentSymbol() {
        return this.currentSymbol;
    }

    private void saveSymbolToFile(Symbol symbol) {
        if (symbol == null || symbol.isEmpty()) {
            StdMessages.infoGeneral("Symbol is empty. There is nothing to save.", this.top);
        } else {
            File saveFile = FileSupport.getInstance().saveDataFile(this.top, symbol.name, DataHandlerTypes.EXCEL, DataHandlerTypes.MATLAB, DataHandlerTypes.GAUSS_DAT, DataHandlerTypes.GAUSS_FMT, DataHandlerTypes.DAT);
            if (saveFile == null) {
                return;
            }
            JSCNArray data = symbol.getJSCNArray();
            if (this.getArraySaveDlg().isTransposed()) {
                data = new JSCNArray(data.name(), data.getTransposed());
            }
            String header = null;
            if (this.getArraySaveDlg().isInfo()) {
                String trans = this.getArraySaveDlg().isTransposed() ? ", transposed" : "";
                header = "name = " + symbol.NAME + ", type = NARRAY" + ", rows = " + data.rows() + ", cols = " + data.cols() + trans;
                String des = symbol.getDescription();
                if (des != null && des.length() > 0) {
                    header = header + "\r\n" + des;
                }
            }
            String format = "%- " + this.getArraySaveDlg().getFWidth() + "." + this.getArraySaveDlg().getPrec() + "f ";
            if (this.getArraySaveDlg().isRaw()) {
                format = "%-s ";
            }
            data.setFormatString(format);
            DataHandlerTypes handlerType = FileSupport.getInstance().getSelectedSaveHandlerType();
            try {
                handlerType.getHandler().exportData(saveFile, data, header);
            }
            catch (Throwable t) {
                String msg = "Error writing symbol \"" + symbol.NAME + "\" to file\n\"" + saveFile.getAbsolutePath() + "\".";
                String message = msg + "\n\n" + t.getMessage();
                StdMessages.error(message, "Data Export Error");
                log.error((Object)msg, t);
            }
        }
    }

    private JButton getSaveButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Save");
            this.jButton.setPreferredSize(new Dimension(100, 25));
            this.jButton.setMinimumSize(new Dimension(100, 25));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JSCNArrayPanel.this.saveSymbolToFile(JSCNArrayPanel.this.getCurrentSymbol());
                }
            });
        }
        return this.jButton;
    }

    private JButton getOptionsButton() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setPreferredSize(new Dimension(100, 25));
            this.jButton1.setMinimumSize(new Dimension(100, 25));
            this.jButton1.setMargin(new Insets(1, 1, 1, 1));
            this.jButton1.setText("Save Options");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JSCNArrayPanel.this.getArraySaveDlg().setVisible(true);
                }
            });
        }
        return this.jButton1;
    }

    private JSCDataTableScrollPane getJSCDataTableScrollPane() {
        if (this.JSCDataTableScrollPane == null) {
            this.JSCDataTableScrollPane = new JSCDataTableScrollPane();
            this.JSCDataTableScrollPane.setViewportView(this.getJSCNArrayTable());
            this.JSCDataTableScrollPane.setColumnHeaderShowing(true);
            this.JSCDataTableScrollPane.setRowHeaderShowing(true);
        }
        return this.JSCDataTableScrollPane;
    }

    private JSCNArrayTable getJSCNArrayTable() {
        if (this.JSCNArrayTable == null) {
            this.JSCNArrayTable = new JSCNArrayTable();
            this.JSCNArrayTable.setPrecision(4);
            this.JSCNArrayTable.setRowSelectionAllowed(true);
        }
        return this.JSCNArrayTable;
    }

    @Override
    public void setSymbolEditable(boolean editable) {
        this.getJSCNArrayTable().setEditable(editable);
    }

    private JComboBox getSelModeCombo() {
        if (this.selModeCombo == null) {
            this.selModeCombo = new JComboBox();
            this.selModeCombo.setPreferredSize(new Dimension(100, 25));
            this.selModeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JSCNArrayPanel.this.selModeCombo.getSelectedIndex() == 0) {
                        JSCNArrayPanel.this.getJSCNArrayTable().setRowSelectionAllowed(false);
                        JSCNArrayPanel.this.getJSCNArrayTable().setColumnSelectionAllowed(true);
                        return;
                    }
                    if (JSCNArrayPanel.this.selModeCombo.getSelectedIndex() == 1) {
                        JSCNArrayPanel.this.getJSCNArrayTable().setRowSelectionAllowed(true);
                        JSCNArrayPanel.this.getJSCNArrayTable().setColumnSelectionAllowed(false);
                        return;
                    }
                    if (JSCNArrayPanel.this.selModeCombo.getSelectedIndex() == 2) {
                        JSCNArrayPanel.this.getJSCNArrayTable().setRowSelectionAllowed(true);
                        JSCNArrayPanel.this.getJSCNArrayTable().setColumnSelectionAllowed(true);
                        return;
                    }
                }
            });
            this.selModeCombo.addItem("Column Selection");
            this.selModeCombo.addItem("Row Selection");
            this.selModeCombo.addItem("Rectangular Selection");
        }
        return this.selModeCombo;
    }
}

