/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model.control;

import com.jstatcom.component.ResultField;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolListener;
import com.jstatcom.model.control.SymbolPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public final class DefaultSymbolPanel
extends SymbolPanel {
    private JSCTypes currentType = null;
    private ResultField resultField = null;

    public DefaultSymbolPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getResultField(), "Center");
        this.setSize(400, 236);
        this.setBorder(new TitledBorder(new BevelBorder(1), "Value", 3, 2));
        this.getResultField().setText("");
        this.getResultField().getTextArea().setBackground(Color.LIGHT_GRAY);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.currentType != symbol.type) {
            this.currentType = symbol.type;
            this.setBorder(new TitledBorder(new BevelBorder(1), "Value of " + symbol.type + "", 3, 2));
        }
        this.setDisplay(symbol);
        symbol.addSymbolListener(new SymbolListener(){

            @Override
            public void valueChanged(SymbolEvent evt) {
                DefaultSymbolPanel.this.setDisplay(evt.getSource());
            }
        });
    }

    private void setDisplay(Symbol sym) {
        if (sym.isEmpty()) {
            this.getResultField().setText("");
            this.getResultField().getTextArea().setBackground(Color.LIGHT_GRAY);
        } else {
            this.getResultField().setText(sym.display());
            this.getResultField().getTextArea().setBackground(Color.WHITE);
        }
    }

    private ResultField getResultField() {
        if (this.resultField == null) {
            this.resultField = new ResultField();
            this.resultField.setEditable(false);
        }
        return this.resultField;
    }

    @Override
    public void setSymbolEditable(boolean editable) {
    }
}

