/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.NumberRangeTypes;
import com.jstatcom.parser.NumberRangeParser;
import com.jstatcom.util.UMath;
import java.text.NumberFormat;

public final class NumberRange {
    public final double lowerBound;
    public final double upperBound;
    public final NumberRangeTypes rangeType;

    public NumberRange() {
        this.lowerBound = Double.NEGATIVE_INFINITY;
        this.upperBound = Double.POSITIVE_INFINITY;
        this.rangeType = NumberRangeTypes.OPEN;
    }

    public NumberRange(double lowerBoundNew, double upperBoundNew, NumberRangeTypes rangeType) {
        this.checkArguments(lowerBoundNew, upperBoundNew, rangeType);
        this.lowerBound = lowerBoundNew;
        this.upperBound = upperBoundNew;
        this.rangeType = rangeType;
    }

    private void checkArguments(double lowerBoundNew, double upperBoundNew, NumberRangeTypes rangeType) {
        if (rangeType == null) {
            throw new IllegalArgumentException("Range type is null.");
        }
        Double lowerB = new Double(lowerBoundNew);
        Double upperB = new Double(upperBoundNew);
        if (Double.isNaN(lowerB) || Double.isNaN(upperB)) {
            throw new IllegalArgumentException("NaN are not allowed for bounds.");
        }
        if (lowerBoundNew == Double.POSITIVE_INFINITY || upperBoundNew == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Wrong +/-INFINITY bounds.");
        }
        if (lowerBoundNew == Double.NEGATIVE_INFINITY && !rangeType.leftOpen) {
            throw new IllegalArgumentException("Lower bound cannot be closed and -INFINITY.");
        }
        if (upperBoundNew == Double.POSITIVE_INFINITY && !rangeType.rightOpen) {
            throw new IllegalArgumentException("Upper bound cannot be closed and +INFINITY.");
        }
        if (upperBoundNew == lowerBoundNew && (rangeType.leftOpen || rangeType.rightOpen)) {
            throw new IllegalArgumentException("If bounds are equal, interval type must be CLOSED.");
        }
        if (upperBoundNew < lowerBoundNew) {
            throw new IllegalArgumentException("Lower bound is greater than upper bound.");
        }
    }

    public double defaultNumber() {
        if (this.upperBound == Double.POSITIVE_INFINITY && this.lowerBound == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (this.lowerBound > Double.NEGATIVE_INFINITY && !this.rangeType.leftOpen) {
            return this.lowerBound;
        }
        if (this.upperBound < Double.POSITIVE_INFINITY && !this.rangeType.rightOpen) {
            return this.upperBound;
        }
        if (this.upperBound < Double.POSITIVE_INFINITY && this.lowerBound > Double.NEGATIVE_INFINITY) {
            if (this.upperBound - this.lowerBound > 1.0) {
                return this.lowerBound + 1.0;
            }
            return (this.upperBound - this.lowerBound) / 2.0 + this.lowerBound;
        }
        if (this.lowerBound > Double.NEGATIVE_INFINITY) {
            return this.lowerBound + 1.0;
        }
        if (this.upperBound < Double.POSITIVE_INFINITY) {
            return this.upperBound - 1.0;
        }
        throw new RuntimeException("Code should never be reached.");
    }

    public NumberRange defaultNumberRange() {
        if (this.upperBound == Double.POSITIVE_INFINITY && this.lowerBound == Double.NEGATIVE_INFINITY) {
            return NumberRange.valueOf("[0,100]");
        }
        if (this.rangeType == NumberRangeTypes.CLOSED) {
            return this;
        }
        if (this.upperBound < Double.POSITIVE_INFINITY && this.lowerBound > Double.NEGATIVE_INFINITY) {
            double lBound = 0.0;
            double uBound = 0.0;
            if (this.rangeType == NumberRangeTypes.LEFT_OPEN) {
                uBound = this.upperBound;
                lBound = this.upperBound - this.lowerBound > 1.0 ? this.lowerBound + 1.0 : this.upperBound;
                return new NumberRange(lBound, uBound, NumberRangeTypes.CLOSED);
            }
            if (this.rangeType == NumberRangeTypes.RIGHT_OPEN) {
                lBound = this.lowerBound;
                uBound = this.upperBound - this.lowerBound > 1.0 ? this.upperBound - 1.0 : this.lowerBound;
                return new NumberRange(lBound, uBound, NumberRangeTypes.CLOSED);
            }
            if (this.rangeType == NumberRangeTypes.OPEN) {
                uBound = this.upperBound;
                if (this.upperBound - this.lowerBound > 1.0) {
                    lBound = this.lowerBound + 1.0;
                    uBound = this.upperBound - 1.0;
                    return new NumberRange(lBound, uBound, NumberRangeTypes.CLOSED);
                }
                double val = (this.upperBound - this.lowerBound) / 2.0 + this.lowerBound;
                return new NumberRange(val, val, NumberRangeTypes.CLOSED);
            }
        }
        double defaultNumber = this.defaultNumber();
        return new NumberRange(defaultNumber, defaultNumber, NumberRangeTypes.CLOSED);
    }

    public String encloses(double number) {
        boolean rightCheck;
        boolean leftCheck;
        boolean bl = leftCheck = this.lowerBound < number;
        if (!this.rangeType.leftOpen && !leftCheck) {
            leftCheck = this.lowerBound == number;
        }
        boolean bl2 = rightCheck = this.upperBound > number;
        if (!this.rangeType.rightOpen && !rightCheck) {
            boolean bl3 = rightCheck = this.upperBound == number;
        }
        if (leftCheck && rightCheck) {
            return null;
        }
        String msg = number + " is not contained in " + this.toString() + ".";
        return msg;
    }

    public String encloses(double number, int precision, NumberFormat formatter) {
        boolean rightCheck;
        boolean leftCheck;
        if (precision < 0) {
            throw new IllegalArgumentException("Precision < 0.");
        }
        double orig = number;
        String rounded = "";
        boolean isNaN = Double.isNaN(number);
        if (!isNaN && number != Double.NEGATIVE_INFINITY && number != Double.POSITIVE_INFINITY && (number = UMath.round(number, precision)) - orig != 0.0) {
            rounded = " (rounded)";
        }
        boolean bl = leftCheck = this.lowerBound < number;
        if (!this.rangeType.leftOpen && !leftCheck) {
            leftCheck = this.lowerBound == number;
        }
        boolean bl2 = rightCheck = this.upperBound > number;
        if (!this.rangeType.rightOpen && !rightCheck) {
            boolean bl3 = rightCheck = this.upperBound == number;
        }
        if (leftCheck && rightCheck) {
            return null;
        }
        String num = number + "";
        if (formatter != null) {
            formatter.setMaximumFractionDigits(precision);
            formatter.setMinimumFractionDigits(precision);
            num = formatter.format(number);
            formatter.setMaximumFractionDigits(100);
        }
        String msg = num + rounded + " is not contained in " + this.formattedString(formatter) + ".";
        return msg;
    }

    public String encloses(NumberRange numberRange) {
        boolean rightCheck;
        boolean leftCheck;
        boolean bl = leftCheck = this.lowerBound < numberRange.lowerBound;
        if (!this.rangeType.leftOpen && !leftCheck) {
            leftCheck = this.lowerBound == numberRange.lowerBound;
        }
        boolean bl2 = rightCheck = this.upperBound > numberRange.upperBound;
        if (!this.rangeType.rightOpen && !rightCheck) {
            boolean bl3 = rightCheck = this.upperBound == numberRange.upperBound;
        }
        if (leftCheck && rightCheck) {
            return null;
        }
        String msg = numberRange + " is not contained in " + this.toString() + ".";
        return msg;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NumberRange)) {
            return false;
        }
        NumberRange other = (NumberRange)o;
        return this.lowerBound == other.lowerBound && this.upperBound == other.upperBound && this.rangeType == other.rangeType;
    }

    public String formattedString(NumberFormat formatter) {
        StringBuffer ret = new StringBuffer();
        ret.append(this.rangeType.leftBracket);
        if (formatter == null) {
            if (Math.rint(this.lowerBound) - this.lowerBound == 0.0) {
                ret.append(new Double(this.lowerBound).intValue());
            } else {
                ret.append(this.lowerBound);
            }
        } else {
            ret.append(formatter.format(this.lowerBound));
        }
        ret.append(", ");
        if (formatter == null) {
            if (Math.rint(this.upperBound) - this.upperBound == 0.0) {
                ret.append(new Double(this.upperBound).intValue());
            } else {
                ret.append(this.upperBound);
            }
        } else {
            ret.append(formatter.format(this.upperBound));
        }
        ret.append(this.rangeType.rightBracket);
        return ret.toString();
    }

    public double lowerBound() {
        return this.lowerBound;
    }

    public NumberRangeTypes type() {
        return this.rangeType;
    }

    public double upperBound() {
        return this.upperBound;
    }

    public int hashCode() {
        int result = 17;
        long f = Double.doubleToLongBits(this.lowerBound);
        result = 37 * result + (int)(f ^ f >>> 32);
        f = Double.doubleToLongBits(this.upperBound);
        result = 37 * result + (int)(f ^ f >>> 32);
        result = 37 * result + this.rangeType.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.rangeType.leftBracket);
        if (Math.rint(this.lowerBound) - this.lowerBound == 0.0) {
            ret.append(new Double(this.lowerBound).intValue());
        } else {
            ret.append(this.lowerBound);
        }
        ret.append(", ");
        if (Math.rint(this.upperBound) - this.upperBound == 0.0) {
            ret.append(new Double(this.upperBound).intValue());
        } else {
            ret.append(this.upperBound);
        }
        ret.append(this.rangeType.rightBracket);
        return ret.toString();
    }

    public static NumberRange valueOf(String exp) {
        NumberRange range = null;
        try {
            range = new NumberRangeParser().parseStringToRange(exp);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("NumberRange construction from \"" + exp + "\" failed.\n" + ex);
        }
        return range;
    }
}

