/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCTypes;

public final class JSCTypeDef {
    public final String name;
    public final JSCTypes type;
    public final String description;

    public JSCTypeDef(String name, JSCTypes type, String description) {
        JSCConstants.checkNameThrowEx(name);
        if (type == null) {
            throw new IllegalArgumentException("Type was null");
        }
        if (description != null && (description.indexOf("/*") > -1 || description.indexOf("*/") > -1)) {
            throw new IllegalArgumentException("Description \"" + description + "\" contains /* or */.");
        }
        this.name = name.toUpperCase();
        this.type = type;
        this.description = description == null ? "" : description.trim();
    }

    public JSCTypeDef(String name, JSCTypes type) {
        this(name, type, null);
    }

    public final String toString() {
        String des = this.description;
        if (this.description.length() > 40) {
            des = des.substring(0, 40) + "...";
        }
        return "<TYPEDEF name=" + this.name + " type=" + this.type + ", description=\"" + des + "\">";
    }

    public JSCData getInstance() {
        return this.type.valueOfEmpty(this.name);
    }
}

