/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCDataEventTypes;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.util.FArg;
import com.jstatcom.util.UMatrix;
import com.jstatcom.util.UString;
import com.jstatcom.util.UStringArray;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JSCSArray
extends AbstractJSCData {
    private String formatString = "%-12s ";
    private final String name;
    private String[][] value = new String[0][0];
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCSArray> JSCSArray_XML = new XmlFormat<JSCSArray>(JSCSArray.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCSArray data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            JSCSArray jSCSArray = data;
            synchronized (jSCSArray) {
                xml.setAttribute("rows", data.rows());
                for (int i = 0; i < data.rows(); ++i) {
                    xml.add(new Row(data.value[i], i));
                }
            }
        }

        @Override
        public JSCSArray parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            String rowString = xml.getAttribute("rows") + "";
            int rows = UString.parseToNumber(rowString).intValue();
            if (rows == 0) {
                JSCSArray array = new JSCSArray(nam);
                return array;
            }
            String[][] val = new String[rows][];
            for (int i = 0; i < rows; ++i) {
                val[i] = ((Row)xml.getNext()).value;
            }
            JSCSArray array = new JSCSArray(nam, val);
            return array;
        }
    };

    public JSCSArray(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.value = new String[0][0];
    }

    public JSCSArray(String name, String[][] value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        if (value != null && value.length > 0) {
            UStringArray.checkRowLengths(value);
        }
        this.value = UStringArray.cloneStringArray(value);
    }

    public JSCSArray(JSCSArray sarray) {
        if (sarray == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = sarray.name();
        this.value = sarray.stringArray();
    }

    public JSCSArray(String name, String ... value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        JSCConstants.checkNameThrowEx(name);
        this.name = name;
        this.value = UStringArray.toStringMatrix(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendCols(JSCSArray newCols) {
        if (newCols == null) {
            throw new IllegalArgumentException("Argument was null for " + this.toString() + ".");
        }
        if (newCols.isEmpty()) {
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        String[][] newVal = null;
        String[][] oldValue = null;
        String[][] toAppend = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            JSCSArray jSCSArray2 = newCols;
            synchronized (jSCSArray2) {
                if (newCols.isEmpty()) {
                    return;
                }
                int rows = this.rows();
                int otherRows = newCols.rows();
                if (rows > 0 && rows != otherRows) {
                    throw new IllegalArgumentException("Number of rows do not match between\n" + this.toString() + " and\n" + newCols.toString() + ".");
                }
                toAppend = newCols.stringArray();
            }
            if (this.isEmpty()) {
                wasEmpty = true;
                oldValue = this.value;
                this.value = toAppend;
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UStringArray.cloneStringArray(toAppend);
                }
            } else {
                wasEmpty = false;
                oldValue = this.value;
                this.value = UStringArray.appendStringCols(this.value, toAppend);
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UStringArray.cloneStringArray(this.value);
                }
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRows(JSCSArray newRows) {
        if (newRows == null) {
            throw new IllegalArgumentException("Argument was null for " + this.toString() + ".");
        }
        if (newRows.isEmpty()) {
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        String[][] newVal = null;
        String[][] oldValue = null;
        String[][] toAppend = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            JSCSArray jSCSArray2 = newRows;
            synchronized (jSCSArray2) {
                if (newRows.isEmpty()) {
                    return;
                }
                int cols = this.cols();
                int otherCols = newRows.cols();
                if (cols > 0 && cols != otherCols) {
                    throw new IllegalArgumentException("Number of cols do not match between\n" + this.toString() + " and\n" + newRows.toString() + ".");
                }
                toAppend = newRows.stringArray();
            }
            if (this.isEmpty()) {
                wasEmpty = true;
                oldValue = this.value;
                this.value = toAppend;
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UStringArray.cloneStringArray(toAppend);
                }
            } else {
                wasEmpty = false;
                oldValue = this.value;
                this.value = UStringArray.appendStringRows(this.value, toAppend);
                isEmpty = this.isEmpty();
                if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                    newVal = UStringArray.cloneStringArray(this.value);
                }
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    private void checkIndices(int i, int j) {
        if (i >= this.rows() || j >= this.cols() || i < 0 || j < 0) {
            throw new IllegalArgumentException("[" + i + "," + j + "] is not a valid index for " + this.toString() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        String[][] oldValue;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            if (this.isEmpty()) {
                return;
            }
            oldValue = this.value;
            this.value = new String[0][0];
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, new String[0][0]));
    }

    public synchronized int cols() {
        if (this.value == null || this.value.length == 0) {
            return 0;
        }
        return this.value[0].length;
    }

    @Override
    public synchronized JSCSArray copy() {
        return new JSCSArray(this.name, this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delCol(int i) {
        String[][] oldValue = null;
        boolean isEmpty = false;
        String[][] newVal = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete column " + i + " from empty object " + this.toString() + ".");
            }
            if (i < 0 || this.cols() <= i) {
                throw new IllegalArgumentException("Bad column index " + i + " for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UStringArray.delCol(this.value, i);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                newVal = UStringArray.cloneStringArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delColsIf(int[] index) {
        String[][] oldValue = null;
        boolean isEmpty = false;
        String[][] newVal = null;
        boolean changed = UMatrix.getNonzeroIntCount(index) > 0;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete columns from empty object " + this.toString() + ".");
            }
            if (index.length != this.cols()) {
                throw new IllegalArgumentException("Bad column selection index (" + index.length + "x" + "1) for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UStringArray.delif(this.value, index);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
                newVal = UStringArray.cloneStringArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRow(int i) {
        String[][] oldValue = null;
        boolean isEmpty = false;
        String[][] newVal = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete row " + i + " from empty object " + this.toString() + ".");
            }
            if (i < 0 || this.rows() <= i) {
                throw new IllegalArgumentException("Bad row index " + i + " for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UStringArray.delRow(this.value, i);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                newVal = UStringArray.cloneStringArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRowsIf(int[] index) {
        String[][] oldValue = null;
        boolean isEmpty = false;
        String[][] newVal = null;
        boolean changed = UMatrix.getNonzeroIntCount(index) > 0;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            if (this.isEmpty()) {
                throw new IllegalStateException("Cannot delete rows from empty object " + this.toString() + ".");
            }
            if (index.length != this.rows()) {
                throw new IllegalArgumentException("Bad row selection index (" + index.length + "x" + "1) for " + this.toString() + ".");
            }
            oldValue = this.value;
            this.value = UStringArray.delRowsIf(this.value, index);
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
                newVal = UStringArray.cloneStringArray(this.value);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && changed) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newVal));
        }
        if (isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    @Override
    public synchronized String display() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                buffer.append(FArg.sprintf(this.formatString, new FArg(this.value[i][j] + "")));
            }
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.value == null || this.value.length == 0 || this.value[0].length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCSArray)) {
            return false;
        }
        JSCSArray otherSArray = (JSCSArray)o;
        boolean ret = true;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                if (this.isEmpty() && otherSArray.isEmpty()) {
                    return true;
                }
                ret = UStringArray.compareStringArrays(this.value, otherSArray.stringArray());
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return this.name;
    }

    public synchronized int rows() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    public void setFormatString(String newFormatString) {
        try {
            FArg.sprintf(newFormatString, new FArg("test"));
        }
        catch (Throwable thr) {
            throw new IllegalArgumentException("\"" + newFormatString + "\" is not a valid format string.");
        }
        this.formatString = newFormatString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(String[][] newValue) {
        if (newValue == null) {
            this.clear();
            return;
        }
        if (newValue.length > 0) {
            UStringArray.checkRowLengths(newValue);
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        String[][] oldValue = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = UStringArray.cloneStringArray(newValue);
            isEmpty = this.isEmpty();
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UStringArray.compareStringArrays(oldValue, newValue)) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(String ... newValue) {
        String[][] toCompare;
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        String[][] oldValue = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = UStringArray.toStringMatrix(newValue);
            isEmpty = this.isEmpty();
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UStringArray.compareStringArrays(oldValue, toCompare = UStringArray.toStringMatrix(newValue))) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, toCompare));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(JSCSArray val) {
        if (val == null) {
            throw new IllegalArgumentException("Argument was null for " + this.toString() + ".");
        }
        String[][] newValue = val.stringArray();
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        boolean isEmpty = false;
        String[][] valToCompare = null;
        String[][] oldValue = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = newValue;
            isEmpty = this.isEmpty();
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                valToCompare = UStringArray.cloneStringArray(newValue);
            }
        }
        if (wasEmpty && isEmpty) {
            return;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UStringArray.compareStringArrays(oldValue, valToCompare)) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, valToCompare));
        }
        if (wasEmpty && !isEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
        if (!wasEmpty && isEmpty) {
            if (this.clearEvent == null) {
                this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
            }
            this.getEventSupport().dispatchEvent(this.clearEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValAt(String val, int i, int j) {
        String oldVal;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            this.checkIndices(i, j);
            oldVal = this.value[i][j];
            this.value[i][j] = val;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (!oldVal.equals(val)) {
            Integer intI = new Integer(i);
            Integer intJ = new Integer(j);
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, new Object[]{oldVal, intI, intJ}, new Object[]{val, intI, intJ}));
        }
    }

    public synchronized String[][] stringArray() {
        if (this.value == null) {
            return new String[0][0];
        }
        return UStringArray.cloneStringArray(this.value);
    }

    public synchronized String[] vec() {
        if (this.value == null || this.value.length == 0) {
            return new String[0];
        }
        String[] rtn = new String[this.value[0].length * this.value.length];
        int index = 0;
        for (int i = 0; i < this.value[0].length; ++i) {
            for (int j = 0; j < this.value.length; ++j) {
                rtn[index++] = this.value[j][i];
            }
        }
        return rtn;
    }

    public synchronized String stringAt(int i, int j) {
        this.checkIndices(i, j);
        return this.value[i][j];
    }

    @Override
    public synchronized String toString() {
        String display = this.isEmpty() ? "{}" : this.value.length + "x" + this.value[0].length + ",[0,0]=" + this.value[0][0];
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " [name=" + this.name + ",type=" + JSCTypes.SARRAY + ",value=" + display + "]";
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.SARRAY;
    }

    @Override
    public synchronized Object value() {
        if (this.value == null) {
            return new String[0][0];
        }
        return UStringArray.cloneStringArray(this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transpose() {
        String[][] valToCompare = null;
        String[][] oldValue = null;
        JSCSArray jSCSArray = this;
        synchronized (jSCSArray) {
            if (this.isEmpty()) {
                return;
            }
            String[][] newValue = new String[this.value[0].length][this.value.length];
            for (int i = 0; i < newValue.length; ++i) {
                for (int j = 0; j < newValue[0].length; ++j) {
                    newValue[i][j] = this.value[j][i];
                }
            }
            oldValue = this.value;
            this.value = newValue;
            if (this.eventSupport != null && this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0) {
                valToCompare = UStringArray.cloneStringArray(newValue);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.eventSupport.getListenersForType(JSCDataEventTypes.VALUE_CHANGED).size() > 0 && !UStringArray.compareStringArrays(oldValue, valToCompare)) {
            this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, valToCompare));
        }
    }

    public synchronized String[][] selRowsIf(int[] rowIndex) {
        return UStringArray.selRowsIf(this.value, rowIndex);
    }

    public synchronized String[] getCol(int colIndex) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot get cols from empty object " + this.toString() + ".");
        }
        return UStringArray.getStringCol(this.value, colIndex);
    }

    public static class Row {
        final String[] value;
        final int index;
        static final String element = "_";
        public static final XmlFormat<Row> Row_XML = new XmlFormat<Row>(Row.class){

            @Override
            public void format(Row data, XmlElement xml) {
                xml.setAttribute("i", data.index);
                xml.setAttribute("cols", data.value.length);
                for (int i = 0; i < data.value.length; ++i) {
                    if (data.value[i] == null) continue;
                    xml.setAttribute(Row.element + i, data.value[i]);
                }
            }

            @Override
            public Row parse(XmlElement xml) {
                String colString = xml.getAttribute("cols") + "";
                String indexString = xml.getAttribute("i") + "";
                int cols = UString.parseToNumber(colString).intValue();
                int index = UString.parseToNumber(indexString).intValue();
                String[] value = new String[cols];
                for (int i = 0; i < cols; ++i) {
                    String o = xml.getAttribute(Row.element + i, (String)null);
                    if (o == null) continue;
                    value[i] = o.toString();
                }
                return new Row(value, index);
            }
        };

        public Row(String[] value, int i) {
            this.value = (String[])value.clone();
            this.index = i;
        }
    }
}

