/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEventTypes;

public class JSCDataEvent {
    private final JSCData source;
    private final JSCDataEventTypes type;
    private final Object newValue;
    private final Object oldValue;

    private JSCDataEvent(JSCData source, JSCDataEventTypes type, boolean newVal) {
        this(source, type, new Boolean(!newVal), new Boolean(newVal));
    }

    public JSCDataEvent(JSCData source, JSCDataEventTypes type, Object oldValue, Object newValue) {
        this.source = source;
        this.type = type;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public final Object getNewValue() {
        return this.newValue;
    }

    public final Object getOldValue() {
        return this.oldValue;
    }

    public final JSCData getSource() {
        return this.source;
    }

    public final JSCDataEventTypes getType() {
        return this.type;
    }

    public String toString() {
        return super.toString() + " [source:name=" + this.source.name() + ",type=" + this.source.type() + ";evttype=" + this.type + "]";
    }

    public static JSCDataEvent valueOfChanged(JSCData source, Object oldValue, Object newValue) {
        return new JSCDataEvent(source, JSCDataEventTypes.VALUE_CHANGED, oldValue, newValue);
    }

    public static JSCDataEvent valueOfEmptyState(JSCData source, boolean isEmptyNow) {
        return new JSCDataEvent(source, JSCDataEventTypes.EMPTY_STATE, isEmptyNow);
    }

    public final boolean isSourceEmpty() {
        if (this.newValue instanceof Boolean) {
            return (Boolean)this.newValue;
        }
        if (this.newValue == null) {
            return false;
        }
        return this.source.isEmpty();
    }
}

