/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.ts.TSDateRange;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JSCDRange
extends AbstractJSCData {
    private final String name;
    private TSDateRange tsRange;
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCDRange> JSCDRange_XML = new XmlFormat<JSCDRange>(JSCDRange.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCDRange data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            JSCDRange jSCDRange = data;
            synchronized (jSCDRange) {
                xml.setAttribute("value", data.tsRange + "");
            }
        }

        @Override
        public JSCDRange parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            String rangeString = xml.getAttribute("value") + "";
            TSDateRange newRange = null;
            if (!rangeString.equalsIgnoreCase("null")) {
                newRange = TSDateRange.valueOf(rangeString);
            }
            return new JSCDRange(nam, newRange);
        }
    };

    public JSCDRange(String name) {
        this(name, null);
    }

    public JSCDRange(String name, TSDateRange tsRange) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.tsRange = tsRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        TSDateRange oldValue;
        JSCDRange jSCDRange = this;
        synchronized (jSCDRange) {
            if (this.tsRange == null) {
                return;
            }
            oldValue = this.tsRange;
            this.tsRange = null;
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, null));
    }

    @Override
    public synchronized JSCDRange copy() {
        return new JSCDRange(this.name, this.tsRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encloses(JSCDate date) {
        if (date == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (date.isEmpty()) {
            throw new IllegalArgumentException("JSCDate arg is empty.");
        }
        JSCDRange jSCDRange = this;
        synchronized (jSCDRange) {
            if (this.isEmpty()) {
                throw new IllegalArgumentException("JSCDateRange is empty.");
            }
            return this.tsRange.encloses(date.getTSDate()) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encloses(JSCDRange dRange) {
        if (dRange == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (dRange.isEmpty()) {
            throw new IllegalArgumentException("JSCDRange arg is empty.");
        }
        JSCDRange jSCDRange = this;
        synchronized (jSCDRange) {
            if (this.isEmpty()) {
                throw new IllegalArgumentException("JSCDRange is empty.");
            }
            return this.tsRange.encloses(dRange.getTSDateRange()) == null;
        }
    }

    public synchronized TSDateRange getTSDateRange() {
        return this.tsRange;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.tsRange == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCDRange)) {
            return false;
        }
        JSCDRange otherRange = (JSCDRange)o;
        boolean ret = true;
        JSCDRange jSCDRange = this;
        synchronized (jSCDRange) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                ret = this.tsRange != null ? this.tsRange.equals(otherRange.getTSDateRange()) : otherRange.getTSDateRange() == null;
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(TSDateRange newRange) {
        if (newRange == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        TSDateRange oldValue = null;
        JSCDRange jSCDRange = this;
        synchronized (jSCDRange) {
            if (newRange.equals(this.tsRange)) {
                return;
            }
            wasEmpty = this.isEmpty();
            oldValue = this.tsRange;
            this.tsRange = newRange;
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newRange));
        if (wasEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.DRANGE;
    }

    @Override
    public synchronized Object value() {
        return this.tsRange;
    }
}

